/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.colossus;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.colossus.ExtImpColossus;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class ColossusBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpColossus>> COLOSSUS_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpColossus>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public ColossusBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<HttpRequest<BidRequest>> requests = new ArrayList<HttpRequest<BidRequest>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                ExtImpColossus extImpColossus = this.parseImpExt(imp);
                Imp modifiedImp = ColossusBidder.modifyImp(imp, extImpColossus.getTagId());
                requests.add(this.makeRequest(bidRequest, modifiedImp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private ExtImpColossus parseImpExt(Imp imp) {
        try {
            return (ExtImpColossus)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), COLOSSUS_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private static Imp modifyImp(Imp imp, String tagId) {
        return imp.toBuilder().tagid(tagId).build();
    }

    private HttpRequest<BidRequest> makeRequest(BidRequest bidRequest, Imp imp) {
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
        return BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List<BidderBid> bids = this.extractBids(httpCall.getRequest().getPayload(), bidResponse, errors);
        return Result.of(bids, errors);
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.makeBidderBid((Bid)bid, bidRequest.getImp(), bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid makeBidderBid(Bid bid, List<Imp> imps, String currency, List<BidderError> errors) {
        try {
            return BidderBid.of(bid, this.resolveBidType(bid.getExt(), bid.getImpid(), imps), currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
    }

    private BidType resolveBidType(ObjectNode objectNode, String impId, List<Imp> imps) {
        BidType bidType;
        JsonNode mediaType = objectNode != null ? objectNode.get("mediaType") : null;
        BidType bidType2 = bidType = mediaType != null ? BidType.fromString(mediaType.asText()) : null;
        if (bidType != null) {
            return bidType;
        }
        for (Imp imp : imps) {
            if (!Objects.equals(impId, imp.getId())) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        throw new PreBidException("Failed to find impression for ID: " + impId);
    }
}

