/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.beachfront;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.util.BidderUtil;

public class BeachfrontFloorResolver {
    public static final BigDecimal MIN_BID_FLOOR = BigDecimal.valueOf(0.01);
    public static final String DEFAULT_BID_CURRENCY = "USD";
    private final CurrencyConversionService currencyConversionService;

    public BeachfrontFloorResolver(CurrencyConversionService currencyConversionService) {
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
    }

    public BidFloorResult resolveBidFloor(BigDecimal extImpBidFloor, Imp imp, BidRequest bidRequest) {
        BidFloorResult bidFloorResult = this.convertBidFloor(bidRequest, imp.getBidfloor(), extImpBidFloor, imp.getBidfloorcur());
        return bidFloorResult.isError() || bidFloorResult.isWarning() ? bidFloorResult : BeachfrontFloorResolver.proceedWithHigherFloor(extImpBidFloor, bidFloorResult.getPrice().getValue());
    }

    private BidFloorResult convertBidFloor(BidRequest bidRequest, BigDecimal impBidFloor, BigDecimal extImpBidFloor, String impBidFloorCur) {
        Price initialBidFloorPrice = Price.of(impBidFloorCur, impBidFloor);
        if (!BidderUtil.shouldConvertBidFloor(initialBidFloorPrice, DEFAULT_BID_CURRENCY)) {
            return BidFloorResult.succeeded(initialBidFloorPrice);
        }
        BidFloorResult result = this.convertBidFloor(initialBidFloorPrice, bidRequest);
        return result.isError() ? BeachfrontFloorResolver.processBidFloorFallback(impBidFloor, extImpBidFloor, impBidFloorCur) : result;
    }

    private BidFloorResult convertBidFloor(Price bidFloor, BidRequest bidRequest) {
        try {
            BigDecimal conversionResult = this.currencyConversionService.convertCurrency(bidFloor.getValue(), bidRequest, bidFloor.getCurrency(), DEFAULT_BID_CURRENCY);
            return BidFloorResult.succeeded(Price.of(DEFAULT_BID_CURRENCY, conversionResult));
        }
        catch (PreBidException e) {
            return BidFloorResult.error(BidderError.badInput(e.getMessage()));
        }
    }

    private static BidFloorResult processBidFloorFallback(BigDecimal impBidFloor, BigDecimal extImpBidFloor, String bidFloorCur) {
        return extImpBidFloor != null && extImpBidFloor.compareTo(MIN_BID_FLOOR) > 0 ? BeachfrontFloorResolver.fallbackWithWarning(impBidFloor, extImpBidFloor, bidFloorCur) : BeachfrontFloorResolver.currencyConversionError(impBidFloor, bidFloorCur);
    }

    private static BidFloorResult fallbackWithWarning(BigDecimal impBidFloor, BigDecimal extImpBidFloor, String bidFloorCur) {
        BidderError fallbackWarning = BidderError.badInput("The following error was received from the currency converter while attempting to convert the imp.bidfloor value of %s from %s to USD: Currency service was unable to convert currency.\nThe provided value of imp.ext.beachfront.bidfloor, %s USD is being used as a fallback.".formatted(impBidFloor, bidFloorCur, extImpBidFloor));
        return BidFloorResult.fallbackWithWarning(Price.of(DEFAULT_BID_CURRENCY, extImpBidFloor), fallbackWarning);
    }

    private static BidFloorResult currencyConversionError(BigDecimal impBidFloor, String bidFloorCur) {
        return BidFloorResult.error(BidderError.badInput("The following error was received from the currency converter while attempting to convert the imp.bidfloor value of %s from %s to USD: Currency service was unable to convert currency.\nA value of imp.ext.beachfront.bidfloor was not provided. The bid is being skipped.".formatted(impBidFloor, bidFloorCur)));
    }

    private static BidFloorResult proceedWithHigherFloor(BigDecimal extImpBidFloor, BigDecimal convertedBidFloor) {
        BigDecimal resolvedExtImpBidFloor = (BigDecimal)ObjectUtils.defaultIfNull((Object)extImpBidFloor, (Object)BigDecimal.ZERO);
        if (convertedBidFloor != null && convertedBidFloor.compareTo(resolvedExtImpBidFloor) >= 0) {
            return BidFloorResult.succeeded(Price.of(DEFAULT_BID_CURRENCY, convertedBidFloor));
        }
        Price resultingPrice = extImpBidFloor != null && extImpBidFloor.compareTo(MIN_BID_FLOOR) > 0 ? Price.of(DEFAULT_BID_CURRENCY, resolvedExtImpBidFloor) : Price.of("", BigDecimal.ZERO);
        return BidFloorResult.succeeded(resultingPrice);
    }

    public static final class BidFloorResult {
        private final BidderError warning;
        private final BidderError error;
        private final Price price;

        public static BidFloorResult error(BidderError error) {
            return BidFloorResult.of(null, error, null);
        }

        public static BidFloorResult fallbackWithWarning(Price fallback, BidderError warning) {
            return BidFloorResult.of(warning, null, fallback);
        }

        public static BidFloorResult succeeded(Price price) {
            return BidFloorResult.of(null, null, price);
        }

        public boolean isError() {
            return this.error != null;
        }

        public boolean isWarning() {
            return this.warning != null;
        }

        @ConstructorProperties(value={"warning", "error", "price"})
        private BidFloorResult(BidderError warning, BidderError error, Price price) {
            this.warning = warning;
            this.error = error;
            this.price = price;
        }

        public static BidFloorResult of(BidderError warning, BidderError error, Price price) {
            return new BidFloorResult(warning, error, price);
        }

        public BidderError getWarning() {
            return this.warning;
        }

        public BidderError getError() {
            return this.error;
        }

        public Price getPrice() {
            return this.price;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BidFloorResult)) {
                return false;
            }
            BidFloorResult other = (BidFloorResult)o;
            BidderError this$warning = this.getWarning();
            BidderError other$warning = other.getWarning();
            if (this$warning == null ? other$warning != null : !((Object)this$warning).equals(other$warning)) {
                return false;
            }
            BidderError this$error = this.getError();
            BidderError other$error = other.getError();
            if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
                return false;
            }
            Price this$price = this.getPrice();
            Price other$price = other.getPrice();
            return !(this$price == null ? other$price != null : !((Object)this$price).equals(other$price));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BidderError $warning = this.getWarning();
            result = result * 59 + ($warning == null ? 43 : ((Object)$warning).hashCode());
            BidderError $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            Price $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
            return result;
        }

        public String toString() {
            return "BeachfrontFloorResolver.BidFloorResult(warning=" + this.getWarning() + ", error=" + this.getError() + ", price=" + this.getPrice() + ")";
        }
    }
}

