/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adyoulike;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adyoulike.ExtImpAdyoulike;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class AdyoulikeBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdyoulike>> ADYOULIKE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAdyoulike>>(){};
    private static final String BIDDER_CURRENCY = "USD";
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final CurrencyConversionService currencyConversionService;

    public AdyoulikeBidder(String endpointUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpAdyoulike impExt = this.parseImpExt(imp);
                Price bidFloorPrice = this.resolveBidFloor(imp, request);
                modifiedImps.add(AdyoulikeBidder.modifyImp(imp, impExt, bidFloorPrice));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (errors.size() > 0) {
            return Result.withErrors(errors);
        }
        BidRequest outgoingRequest = request.toBuilder().cur(Collections.singletonList(BIDDER_CURRENCY)).imp(modifiedImps).build();
        return Result.withValue(HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(AdyoulikeBidder.resolveHeaders()).payload(outgoingRequest).body(this.mapper.encodeToBytes(outgoingRequest)).build());
    }

    private static Imp modifyImp(Imp imp, ExtImpAdyoulike impExt, Price bidFloorPrice) {
        return imp.toBuilder().bidfloorcur(bidFloorPrice.getCurrency()).bidfloor(bidFloorPrice.getValue()).tagid(impExt.getPlacement()).build();
    }

    private Price resolveBidFloor(Imp imp, BidRequest bidRequest) {
        Price initialBidFloorPrice = Price.of(imp.getBidfloorcur(), imp.getBidfloor());
        return BidderUtil.isValidPrice(initialBidFloorPrice) && !StringUtils.equalsIgnoreCase((CharSequence)initialBidFloorPrice.getCurrency(), (CharSequence)BIDDER_CURRENCY) ? this.convertBidFloor(initialBidFloorPrice, imp.getId(), bidRequest) : initialBidFloorPrice;
    }

    private Price convertBidFloor(Price bidFloorPrice, String impId, BidRequest bidRequest) {
        String bidFloorCur = bidFloorPrice.getCurrency();
        try {
            BigDecimal convertedPrice = this.currencyConversionService.convertCurrency(bidFloorPrice.getValue(), bidRequest, bidFloorCur, BIDDER_CURRENCY);
            return Price.of(BIDDER_CURRENCY, convertedPrice);
        }
        catch (PreBidException e) {
            throw new PreBidException("Unable to convert provided bid floor currency from %s to %s for imp `%s`".formatted(bidFloorCur, BIDDER_CURRENCY, impId));
        }
    }

    private ExtImpAdyoulike parseImpExt(Imp imp) {
        try {
            return (ExtImpAdyoulike)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADYOULIKE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private static MultiMap resolveHeaders() {
        return HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(AdyoulikeBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return AdyoulikeBidder.bidsFromResponse(bidRequest, bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, AdyoulikeBidder.getBidType(bid.getImpid(), bidRequest.getImp()), BIDDER_CURRENCY)).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() == null && imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getBanner() != null || imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

