/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adview;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adview.ExtImpAdview;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class AdviewBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdview>> ADVIEW_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAdview>>(){};
    private static final String ACCOUNT_ID_MACRO = "{{AccountId}}";
    private static final String BIDDER_CURRENCY = "USD";
    private final String endpointUrl;
    private final CurrencyConversionService currencyConversionService;
    private final JacksonMapper mapper;

    public AdviewBidder(String endpointUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        BidRequest modifiedBidRequest;
        ExtImpAdview extImpAdview;
        Imp firstImp = request.getImp().get(0);
        try {
            extImpAdview = this.parseExtImp(firstImp);
            Price bidFloorPrice = this.resolveBidFloor(firstImp, request);
            modifiedBidRequest = AdviewBidder.modifyRequest(request, extImpAdview.getMasterTagId(), bidFloorPrice);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        return Result.withValue(BidderUtil.defaultRequest(modifiedBidRequest, this.resolveEndpoint(extImpAdview.getAccountId()), this.mapper));
    }

    private ExtImpAdview parseExtImp(Imp imp) {
        try {
            return (ExtImpAdview)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADVIEW_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("invalid imp.ext");
        }
    }

    private Price resolveBidFloor(Imp imp, BidRequest bidRequest) {
        Price initialBidFloorPrice = Price.of(imp.getBidfloorcur(), imp.getBidfloor());
        return BidderUtil.isValidPrice(initialBidFloorPrice) ? this.convertBidFloor(initialBidFloorPrice, imp.getId(), bidRequest) : initialBidFloorPrice;
    }

    private Price convertBidFloor(Price bidFloorPrice, String impId, BidRequest bidRequest) {
        String bidFloorCur = bidFloorPrice.getCurrency();
        try {
            BigDecimal convertedPrice = this.currencyConversionService.convertCurrency(bidFloorPrice.getValue(), bidRequest, bidFloorCur, BIDDER_CURRENCY);
            return Price.of(BIDDER_CURRENCY, convertedPrice);
        }
        catch (PreBidException e) {
            throw new PreBidException("Unable to convert provided bid floor currency from %s to %s for imp `%s`".formatted(bidFloorCur, BIDDER_CURRENCY, impId));
        }
    }

    private static BidRequest modifyRequest(BidRequest bidRequest, String masterTagId, Price bidFloorPrice) {
        return bidRequest.toBuilder().imp(AdviewBidder.modifyImps(bidRequest.getImp(), masterTagId, bidFloorPrice)).cur(Collections.singletonList(BIDDER_CURRENCY)).build();
    }

    private static List<Imp> modifyImps(List<Imp> imps, String masterTagId, Price bidFloorPrice) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>(imps);
        modifiedImps.set(0, AdviewBidder.modifyImp(imps.get(0), masterTagId, bidFloorPrice));
        return modifiedImps;
    }

    private static Imp modifyImp(Imp imp, String masterTagId, Price bidFloorPrice) {
        return imp.toBuilder().tagid(masterTagId).bidfloor(bidFloorPrice.getValue()).bidfloorcur(bidFloorPrice.getCurrency()).banner(AdviewBidder.resolveBanner(imp.getBanner())).build();
    }

    private static Banner resolveBanner(Banner banner) {
        List<Format> formats;
        List<Format> list = formats = banner != null ? banner.getFormat() : null;
        if (CollectionUtils.isNotEmpty(formats)) {
            Format firstFormat = formats.get(0);
            return firstFormat != null ? banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build() : banner;
        }
        return banner;
    }

    private String resolveEndpoint(String accountId) {
        return this.endpointUrl.replace(ACCOUNT_ID_MACRO, HttpUtil.encodeUrl(accountId));
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(AdviewBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return AdviewBidder.bidsFromResponse(bidRequest, bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, AdviewBidder.getBidMediaType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getBidMediaType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

