/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adman;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adman.ExtImpAdman;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class AdmanBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdman>> ADMAN_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAdman>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdmanBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            ExtImpAdman extImpAdman;
            try {
                extImpAdman = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
                continue;
            }
            Imp modifiedImp = this.modifyImp(imp, extImpAdman);
            httpRequests.add(this.makeRequest(request, modifiedImp));
        }
        return Result.of(httpRequests, errors);
    }

    private ExtImpAdman parseImpExt(Imp imp) {
        try {
            return (ExtImpAdman)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADMAN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp modifyImp(Imp imp, ExtImpAdman extImpAdman) {
        return imp.toBuilder().tagid(extImpAdman.getTagId()).build();
    }

    private HttpRequest<BidRequest> makeRequest(BidRequest bidRequest, Imp imp) {
        BidRequest modifyBidRequest = bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
        return BidderUtil.defaultRequest(modifyBidRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            List<Imp> imps = httpCall.getRequest().getPayload().getImp();
            List<BidderBid> bidderBids = this.extractBids(bidResponse, errors, imps);
            return Result.of(bidderBids, errors);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors, List<Imp> imps) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.resolveBidderBid(bidResponse.getCur(), imps, (Bid)bid, errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid resolveBidderBid(String currency, List<Imp> imps, Bid bid, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = this.getBidType(bid.getImpid(), imps);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
        return BidderBid.of(bid, bidType, currency);
    }

    private BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() == null && imp.getVideo() != null) {
                return BidType.video;
            }
            return BidType.banner;
        }
        throw new PreBidException("Failed to find impression \"%s\"".formatted(impId));
    }
}

