/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adgeneration;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.adgeneration.model.AdgenerationResponse;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.HttpResponse;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adgeneration.ExtImpAdgeneration;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class AdgenerationBidder
implements Bidder<Void> {
    private static final String VERSION = "1.0.3";
    private static final String DEFAULT_REQUEST_CURRENCY = "JPY";
    private static final Pattern REPLACE_VAST_XML_PATTERN = Pattern.compile("/\\r?\\n/g", 2);
    private static final Pattern APPEND_CHILD_TO_BODY_PATTERN = Pattern.compile("</\\s?body>", 2);
    private static final TypeReference<ExtPrebid<?, ExtImpAdgeneration>> ADGENERATION_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAdgeneration>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdgenerationBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<Void>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest<Void>> requests = new ArrayList<HttpRequest<Void>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpAdgeneration extImpAdgeneration = this.parseAndValidateImpExt(imp);
                String adgenerationId = extImpAdgeneration.getId();
                String adSizes = AdgenerationBidder.getAdSize(imp);
                String currency = AdgenerationBidder.getCurrency(request);
                String uri = this.getUri(adSizes, adgenerationId, currency, request);
                requests.add(AdgenerationBidder.createSingleRequest(uri, request.getDevice()));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private ExtImpAdgeneration parseAndValidateImpExt(Imp imp) {
        ExtImpAdgeneration extImpAdgeneration;
        try {
            extImpAdgeneration = (ExtImpAdgeneration)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADGENERATION_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)extImpAdgeneration.getId())) {
            throw new PreBidException("No Location ID in ExtImpAdgeneration.");
        }
        return extImpAdgeneration;
    }

    private String getUri(String adSize, String id, String currency, BidRequest bidRequest) {
        String deviceOs;
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(this.endpointUrl);
        }
        catch (URISyntaxException e) {
            throw new PreBidException("Invalid url: %s, error: %s".formatted(this.endpointUrl, e.getMessage()));
        }
        uriBuilder.addParameter("posall", "SSPLOC").addParameter("id", id).addParameter("hb", "true").addParameter("t", "json3").addParameter("currency", currency).addParameter("sdkname", "prebidserver").addParameter("adapterver", VERSION);
        AdgenerationBidder.addParameterIfNotEmpty(uriBuilder, "sizes", adSize);
        AdgenerationBidder.addParameterIfNotEmpty(uriBuilder, "tp", ObjectUtil.getIfNotNull(bidRequest.getSite(), Site::getPage));
        AdgenerationBidder.addParameterIfNotEmpty(uriBuilder, "appbundle", ObjectUtil.getIfNotNull(bidRequest.getApp(), App::getBundle));
        AdgenerationBidder.addParameterIfNotEmpty(uriBuilder, "appname", ObjectUtil.getIfNotNull(bidRequest.getApp(), App::getName));
        AdgenerationBidder.addParameterIfNotEmpty(uriBuilder, "transactionid", ObjectUtil.getIfNotNull(bidRequest.getSource(), Source::getTid));
        Device device = bidRequest.getDevice();
        String string = deviceOs = device != null ? device.getOs() : null;
        if ("android".equals(deviceOs)) {
            uriBuilder.addParameter("sdktype", "1");
            AdgenerationBidder.addParameterIfNotEmpty(uriBuilder, "advertising_id", device.getIfa());
        } else if ("ios".equals(deviceOs)) {
            uriBuilder.addParameter("sdktype", "2");
            AdgenerationBidder.addParameterIfNotEmpty(uriBuilder, "idfa", device.getIfa());
        } else {
            uriBuilder.addParameter("sdktype", "0");
        }
        return uriBuilder.toString();
    }

    private static void addParameterIfNotEmpty(URIBuilder uriBuilder, String parameter, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            uriBuilder.addParameter(parameter, value);
        }
    }

    private static String getAdSize(Imp imp) {
        Banner banner = imp.getBanner();
        List<Format> formats = banner != null ? banner.getFormat() : null;
        return CollectionUtils.emptyIfNull(formats).stream().map(format -> "%sx%s".formatted(format.getW(), format.getH())).collect(Collectors.joining(","));
    }

    private static String getCurrency(BidRequest bidRequest) {
        List<String> currencies = bidRequest.getCur();
        return CollectionUtils.isEmpty(currencies) ? DEFAULT_REQUEST_CURRENCY : (currencies.contains(DEFAULT_REQUEST_CURRENCY) ? DEFAULT_REQUEST_CURRENCY : currencies.get(0));
    }

    private static HttpRequest<Void> createSingleRequest(String uri, Device device) {
        return HttpRequest.builder().method(HttpMethod.GET).uri(uri).headers(AdgenerationBidder.resolveHeaders(device)).build();
    }

    private static MultiMap resolveHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, device.getIp());
        }
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<Void> httpCall, BidRequest bidRequest) {
        try {
            AdgenerationResponse adgenerationResponse = this.decodeBodyToBidResponse(httpCall.getResponse());
            if (CollectionUtils.isEmpty(adgenerationResponse.getResults())) {
                return Result.withError(BidderError.badServerResponse("Results object in BidResponse is empty"));
            }
            return this.resultWithBidderBids(bidRequest, adgenerationResponse);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private AdgenerationResponse decodeBodyToBidResponse(HttpResponse httpResponse) {
        try {
            return this.mapper.decodeValue(httpResponse.getBody(), AdgenerationResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private Result<List<BidderBid>> resultWithBidderBids(BidRequest bidRequest, AdgenerationResponse adgenerationResponse) {
        for (Imp imp : bidRequest.getImp()) {
            ExtImpAdgeneration extImpAdgeneration = this.parseAndValidateImpExt(imp);
            String locationId = adgenerationResponse.getLocationid();
            if (!extImpAdgeneration.getId().equals(locationId)) continue;
            String adm = this.getAdm(adgenerationResponse, imp.getId());
            Bid updatedBid = Bid.builder().id(locationId).impid(imp.getId()).adm(adm).price(adgenerationResponse.getCpm()).w(adgenerationResponse.getW()).h(adgenerationResponse.getH()).crid(adgenerationResponse.getCreativeid()).dealid(adgenerationResponse.getDealid()).build();
            BidderBid bidderBid = BidderBid.of(updatedBid, BidType.banner, AdgenerationBidder.getCurrency(bidRequest));
            return Result.withValue(bidderBid);
        }
        return null;
    }

    private String getAdm(AdgenerationResponse adgenerationResponse, String impId) {
        String ad = adgenerationResponse.getAd();
        if (StringUtils.isNotBlank((CharSequence)adgenerationResponse.getVastxml())) {
            ad = "<body>\n<div id=\"apvad-%s\"></div>\n<script type=\"text/javascript\" id=\"apv\" src=\"https://cdn.apvdr.com/js/VideoAd.min.js\"></script>\n%s\n</body>".formatted(impId, this.insertVASTMethod(impId, adgenerationResponse.getVastxml()));
        }
        String updateAd = StringUtils.isNotBlank((CharSequence)adgenerationResponse.getBeacon()) ? this.appendChildToBody(ad, adgenerationResponse.getBeacon()) : ad;
        String unwrappedAd = this.removeWrapper(updateAd);
        return StringUtils.isNotBlank((CharSequence)unwrappedAd) ? unwrappedAd : updateAd;
    }

    private String insertVASTMethod(String impId, String vastXml) {
        String replacedVastxml = REPLACE_VAST_XML_PATTERN.matcher(vastXml).replaceAll("");
        return "<script type=\"text/javascript\">\n(function() {\n    new APV.VideoAd({s:\"%s\"}).load('%s');\n})();\n</script>".formatted(impId, replacedVastxml);
    }

    private String appendChildToBody(String ad, String beacon) {
        return APPEND_CHILD_TO_BODY_PATTERN.matcher(ad).replaceAll(beacon + "</body>");
    }

    private String removeWrapper(String ad) {
        return !ad.contains("<body>") || ad.lastIndexOf("</body>") == -1 ? "" : ad.replace("<body>", "").replaceFirst("<body>", "").trim();
    }
}

