/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import com.iab.openrtb.request.BidRequest;
import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.BidderAliases;
import org.prebid.server.auction.model.BidRejectionReason;
import org.prebid.server.auction.model.BidRejectionTracker;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.BidderErrorNotifier;
import org.prebid.server.bidder.BidderRequestCompletionTracker;
import org.prebid.server.bidder.BidderRequestCompletionTrackerFactory;
import org.prebid.server.bidder.HttpBidderRequestEnricher;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderCallType;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.BidderSeatBid;
import org.prebid.server.bidder.model.CompositeBidderResponse;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.HttpResponse;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.proto.openrtb.ext.response.ExtHttpCall;
import org.prebid.server.proto.openrtb.ext.response.FledgeAuctionConfig;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

public class HttpBidderRequester {
    private static final Logger logger = LoggerFactory.getLogger(HttpBidderRequester.class);
    private final HttpClient httpClient;
    private final BidderRequestCompletionTrackerFactory completionTrackerFactory;
    private final BidderErrorNotifier bidderErrorNotifier;
    private final HttpBidderRequestEnricher requestEnricher;
    private final JacksonMapper mapper;

    public HttpBidderRequester(HttpClient httpClient, BidderRequestCompletionTrackerFactory completionTrackerFactory, BidderErrorNotifier bidderErrorNotifier, HttpBidderRequestEnricher requestEnricher, JacksonMapper mapper) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.completionTrackerFactory = HttpBidderRequester.completionTrackerFactoryOrFallback(completionTrackerFactory);
        this.bidderErrorNotifier = Objects.requireNonNull(bidderErrorNotifier);
        this.requestEnricher = Objects.requireNonNull(requestEnricher);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public <T> Future<BidderSeatBid> requestBids(Bidder<T> bidder, BidderRequest bidderRequest, BidRejectionTracker bidRejectionTracker, Timeout timeout, CaseInsensitiveMultiMap requestHeaders, BidderAliases aliases, boolean debugEnabled) {
        String bidderName = bidderRequest.getBidder();
        BidRequest bidRequest = bidderRequest.getBidRequest();
        Result<List<HttpRequest<T>>> httpRequestsWithErrors = bidder.makeHttpRequests(bidRequest);
        List<BidderError> errors = httpRequestsWithErrors.getErrors();
        List<HttpRequest<T>> httpRequests = this.enrichRequests(bidderName, httpRequestsWithErrors.getValue(), requestHeaders, aliases, bidRequest);
        HttpBidderRequester.recordBidderProvidedErrors(bidRejectionTracker, errors);
        if (CollectionUtils.isEmpty(httpRequests)) {
            return this.emptyBidderSeatBidWithErrors(errors);
        }
        String storedResponse = bidderRequest.getStoredResponse();
        Stream<Future> httpCalls = this.isStoredResponse(httpRequests, storedResponse, bidderName) ? Stream.of(this.makeStoredHttpCall(httpRequests.get(0), storedResponse)) : httpRequests.stream().map(httpRequest -> this.doRequest((HttpRequest)httpRequest, timeout));
        BidderRequestCompletionTracker completionTracker = this.completionTrackerFactory.create(bidRequest);
        ResultBuilder resultBuilder = new ResultBuilder(httpRequests, errors, completionTracker, bidRejectionTracker, this.mapper);
        List<Future> httpRequestFutures = httpCalls.map(httpCallFuture -> httpCallFuture.map(httpCall -> this.bidderErrorNotifier.processTimeout(httpCall, bidder)).map(httpCall -> this.processHttpCall(bidder, bidRequest, resultBuilder, (BidderCall)httpCall))).toList();
        return CompositeFuture.any((Future)CompositeFuture.join(new ArrayList<Future>(httpRequestFutures)), completionTracker.future()).map(ignored -> resultBuilder.toBidderSeatBid(debugEnabled)).onSuccess(seatBid -> bidRejectionTracker.restoreFromRejection(seatBid.getBids()));
    }

    private <T> List<HttpRequest<T>> enrichRequests(String bidderName, List<HttpRequest<T>> httpRequests, CaseInsensitiveMultiMap requestHeaders, BidderAliases aliases, BidRequest bidRequest) {
        return httpRequests.stream().map(httpRequest -> httpRequest.toBuilder().headers(this.requestEnricher.enrichHeaders(bidderName, httpRequest.getHeaders(), requestHeaders, aliases, bidRequest)).build()).toList();
    }

    private static void recordBidderProvidedErrors(BidRejectionTracker rejectionTracker, List<BidderError> errors) {
        errors.stream().filter(error -> CollectionUtils.isNotEmpty(error.getImpIds())).forEach(error -> rejectionTracker.reject(error.getImpIds(), BidRejectionReason.fromBidderError(error)));
    }

    private <T> boolean isStoredResponse(List<HttpRequest<T>> httpRequests, String storedResponse, String bidder) {
        if (StringUtils.isBlank((CharSequence)storedResponse)) {
            return false;
        }
        if (httpRequests.size() > 1) {
            logger.warn((Object)"More than one request was created for stored response, when only single stored response per bidder is supported for the moment. Request to real {0} bidder will be performed.", new Object[]{bidder});
            return false;
        }
        return true;
    }

    private <T> Future<BidderCall<T>> makeStoredHttpCall(HttpRequest<T> httpRequest, String storedResponse) {
        HttpResponse httpResponse = HttpResponse.of(HttpResponseStatus.OK.code(), null, storedResponse);
        return Future.succeededFuture(BidderCall.storedHttp(httpRequest, httpResponse));
    }

    private Future<BidderSeatBid> emptyBidderSeatBidWithErrors(List<BidderError> bidderErrors) {
        List<BidderError> errors = bidderErrors.isEmpty() ? Collections.singletonList(BidderError.failedToRequestBids("The bidder failed to generate any bid requests, but also failed to generate an error")) : bidderErrors;
        return Future.succeededFuture((Object)BidderSeatBid.builder().errors(errors).build());
    }

    private <T> Future<BidderCall<T>> doRequest(HttpRequest<T> httpRequest, Timeout timeout) {
        long remainingTimeout = timeout.remaining();
        if (remainingTimeout <= 0L) {
            return HttpBidderRequester.failResponse(new TimeoutException("Timeout has been exceeded"), httpRequest);
        }
        return this.createRequest(httpRequest, remainingTimeout).compose(response -> HttpBidderRequester.processResponse(response, httpRequest)).recover(exception -> HttpBidderRequester.failResponse(exception, httpRequest));
    }

    private <T> Future<HttpClientResponse> createRequest(HttpRequest<T> httpRequest, long remainingTimeout) {
        MultiMap requestHeaders = httpRequest.getHeaders();
        byte[] preparedBody = HttpBidderRequester.compressIfRequired(httpRequest.getBody(), requestHeaders);
        return this.httpClient.request(httpRequest.getMethod(), httpRequest.getUri(), requestHeaders, preparedBody, remainingTimeout);
    }

    private static byte[] compressIfRequired(byte[] body, MultiMap headers) {
        String contentEncodingHeader = headers.get(HttpUtil.CONTENT_ENCODING_HEADER);
        return Objects.equals(contentEncodingHeader, HttpHeaderValues.GZIP.toString()) ? HttpBidderRequester.gzip(body) : body;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] gzip(byte[] value) {
        try (ByteArrayOutputStream obj = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(obj);){
                gzip.write(value);
                gzip.finish();
                byArray = obj.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new PreBidException("Failed to compress request : " + e.getMessage());
        }
    }

    private static <T> Future<BidderCall<T>> failResponse(Throwable exception, HttpRequest<T> httpRequest) {
        logger.warn((Object)"Error occurred while sending HTTP request to a bidder url: {0} with message: {1}", new Object[]{httpRequest.getUri(), exception.getMessage()});
        logger.debug((Object)"Error occurred while sending HTTP request to a bidder url: {0}", exception, new Object[]{httpRequest.getUri()});
        BidderError.Type errorType = exception instanceof TimeoutException || exception instanceof ConnectTimeoutException ? BidderError.Type.timeout : BidderError.Type.generic;
        return Future.succeededFuture(BidderCall.failedHttp(httpRequest, BidderError.create(exception.getMessage(), errorType)));
    }

    private static <T> Future<BidderCall<T>> processResponse(HttpClientResponse response, HttpRequest<T> httpRequest) {
        int statusCode = response.getStatusCode();
        HttpResponse httpResponse = HttpResponse.of(statusCode, response.getHeaders(), response.getBody());
        return Future.succeededFuture(BidderCall.succeededHttp(httpRequest, httpResponse, HttpBidderRequester.errorOrNull(statusCode)));
    }

    private static BidderError errorOrNull(int statusCode) {
        if (statusCode != HttpResponseStatus.OK.code() && statusCode != HttpResponseStatus.NO_CONTENT.code()) {
            return BidderError.create("Unexpected status code: " + statusCode + ". Run with request.test = 1 for more info", statusCode == HttpResponseStatus.BAD_REQUEST.code() ? BidderError.Type.bad_input : BidderError.Type.bad_server_response);
        }
        return null;
    }

    private <T> Void processHttpCall(Bidder<T> bidder, BidRequest bidRequest, ResultBuilder<T> seatBidBuilder, BidderCall<T> httpCall) {
        seatBidBuilder.addHttpCall(httpCall, HttpBidderRequester.makeBids(bidder, httpCall, bidRequest));
        return null;
    }

    private static <T> CompositeBidderResponse makeBids(Bidder<T> bidder, BidderCall<T> httpCall, BidRequest bidRequest) {
        if (httpCall.getError() != null) {
            return null;
        }
        int statusCode = httpCall.getResponse().getStatusCode();
        if (statusCode == HttpResponseStatus.NO_CONTENT.code()) {
            return CompositeBidderResponse.empty();
        }
        if (statusCode != HttpResponseStatus.OK.code()) {
            return null;
        }
        return bidder.makeBidderResponse(HttpBidderRequester.toHttpCallWithSafeResponseBody(httpCall), bidRequest);
    }

    private static <T> BidderCall<T> toHttpCallWithSafeResponseBody(BidderCall<T> httpCall) {
        HttpResponse response = httpCall.getResponse();
        int statusCode = response.getStatusCode();
        if (statusCode == HttpResponseStatus.NO_CONTENT.code()) {
            HttpResponse updatedHttpResponse = HttpResponse.of(statusCode, response.getHeaders(), "{}");
            return BidderCall.succeededHttp(httpCall.getRequest(), updatedHttpResponse, null);
        }
        return httpCall;
    }

    private static BidderRequestCompletionTrackerFactory completionTrackerFactoryOrFallback(BidderRequestCompletionTrackerFactory completionTrackerFactory) {
        return completionTrackerFactory != null ? completionTrackerFactory : bidRequest -> new NoOpCompletionTracker();
    }

    private static class ResultBuilder<T> {
        private final List<HttpRequest<T>> httpRequests;
        private final List<BidderError> previousErrors;
        private final BidderRequestCompletionTracker completionTracker;
        private final BidRejectionTracker bidRejectionTracker;
        private final JacksonMapper mapper;
        private final Map<HttpRequest<T>, BidderCall<T>> bidderCallsRecorded = new HashMap<HttpRequest<T>, BidderCall<T>>();
        private final List<BidderBid> bidsRecorded = new ArrayList<BidderBid>();
        private final List<BidderError> errorsRecorded = new ArrayList<BidderError>();
        private final List<FledgeAuctionConfig> fledgeRecorded = new ArrayList<FledgeAuctionConfig>();

        ResultBuilder(List<HttpRequest<T>> httpRequests, List<BidderError> previousErrors, BidderRequestCompletionTracker completionTracker, BidRejectionTracker bidRejectionTracker, JacksonMapper mapper) {
            this.httpRequests = httpRequests;
            this.previousErrors = previousErrors;
            this.completionTracker = completionTracker;
            this.bidRejectionTracker = bidRejectionTracker;
            this.mapper = mapper;
        }

        void addHttpCall(BidderCall<T> bidderCall, CompositeBidderResponse bidderResponse) {
            this.bidderCallsRecorded.put(bidderCall.getRequest(), bidderCall);
            this.handleBids(bidderResponse);
            this.handleBidderErrors(bidderResponse);
            this.handleBidderCallError(bidderCall);
            this.handleFledgeAuctionConfigs(bidderResponse);
        }

        private void handleBids(CompositeBidderResponse bidderResponse) {
            List<BidderBid> bids;
            List<BidderBid> list = bids = bidderResponse != null ? bidderResponse.getBids() : null;
            if (bids != null) {
                this.bidsRecorded.addAll(bids);
                this.completionTracker.processBids(bids);
                this.bidRejectionTracker.succeed(bids);
            }
        }

        private void handleBidderErrors(CompositeBidderResponse bidderResponse) {
            List<BidderError> bidderErrors;
            List<BidderError> list = bidderErrors = bidderResponse != null ? bidderResponse.getErrors() : null;
            if (bidderErrors != null) {
                this.errorsRecorded.addAll(bidderErrors);
                HttpBidderRequester.recordBidderProvidedErrors(this.bidRejectionTracker, bidderErrors);
            }
        }

        private void handleBidderCallError(BidderCall<T> bidderCall) {
            BidderError callError = bidderCall.getError();
            BidderError.Type callErrorType = callError != null ? callError.getType() : null;
            Set<String> requestedImpIds = bidderCall.getRequest().getImpIds();
            if (callErrorType != null && CollectionUtils.isNotEmpty(requestedImpIds)) {
                this.bidRejectionTracker.reject(requestedImpIds, BidRejectionReason.fromBidderError(callError));
            }
        }

        private void handleFledgeAuctionConfigs(CompositeBidderResponse bidderResponse) {
            Optional.ofNullable(bidderResponse).map(CompositeBidderResponse::getFledgeAuctionConfigs).ifPresent(this.fledgeRecorded::addAll);
        }

        BidderSeatBid toBidderSeatBid(boolean debugEnabled) {
            ArrayList httpCalls = new ArrayList(this.bidderCallsRecorded.values());
            this.httpRequests.stream().filter(httpRequest -> !this.bidderCallsRecorded.containsKey(httpRequest)).map(BidderCall::unfinishedHttp).forEach(httpCalls::add);
            List<ExtHttpCall> extHttpCalls = debugEnabled ? httpCalls.stream().map(this::toExt).toList() : Collections.emptyList();
            List<BidderError> errors = ResultBuilder.combineErrors(this.previousErrors, httpCalls, this.errorsRecorded);
            return BidderSeatBid.builder().bids(this.bidsRecorded).httpCalls(extHttpCalls).errors(errors).fledgeAuctionConfigs(this.fledgeRecorded).build();
        }

        private ExtHttpCall toExt(BidderCall<T> httpCall) {
            HttpRequest<T> request = httpCall.getRequest();
            BidderCallType callType = httpCall.getCallType();
            ExtHttpCall.ExtHttpCallBuilder builder = ExtHttpCall.builder().uri(request.getUri()).calltype(callType != BidderCallType.HTTP ? callType : null).requestbody(this.mapper.encodeToString(request.getPayload())).requestheaders(HttpUtil.toDebugHeaders(request.getHeaders()));
            HttpResponse response = httpCall.getResponse();
            if (response != null) {
                builder.responsebody(response.getBody());
                builder.status(response.getStatusCode());
            }
            return builder.build();
        }

        private static <R> List<BidderError> combineErrors(List<BidderError> requestErrors, List<BidderCall<R>> calls, List<BidderError> responseErrors) {
            return Stream.of(requestErrors.stream(), responseErrors.stream(), calls.stream().map(BidderCall::getError).filter(Objects::nonNull)).flatMap(Function.identity()).toList();
        }
    }

    private static class NoOpCompletionTracker
    implements BidderRequestCompletionTracker {
        private NoOpCompletionTracker() {
        }

        @Override
        public Future<Void> future() {
            return Future.failedFuture((String)"No-op");
        }

        @Override
        public void processBids(List<BidderBid> bids) {
        }
    }
}

