/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Objects;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.Metrics;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

public class BidderErrorNotifier {
    private static final Logger logger = LoggerFactory.getLogger(BidderErrorNotifier.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private final int timeoutNotificationTimeoutMs;
    private final boolean logTimeoutNotificationResult;
    private final boolean logTimeoutNotificationFailureOnly;
    private final double logTimeoutNotificationSamplingRate;
    private final HttpClient httpClient;
    private final Metrics metrics;

    public BidderErrorNotifier(int timeoutNotificationTimeoutMs, boolean logTimeoutNotificationResult, boolean logTimeoutNotificationFailureOnly, double logTimeoutNotificationSamplingRate, HttpClient httpClient, Metrics metrics) {
        this.timeoutNotificationTimeoutMs = timeoutNotificationTimeoutMs;
        this.logTimeoutNotificationResult = logTimeoutNotificationResult;
        this.logTimeoutNotificationFailureOnly = logTimeoutNotificationFailureOnly;
        this.logTimeoutNotificationSamplingRate = logTimeoutNotificationSamplingRate;
        this.httpClient = Objects.requireNonNull(httpClient);
        this.metrics = Objects.requireNonNull(metrics);
    }

    public <T> BidderCall<T> processTimeout(BidderCall<T> httpCall, Bidder<T> bidder) {
        HttpRequest<Void> timeoutNotification;
        BidderError error = httpCall.getError();
        if (error != null && error.getType() == BidderError.Type.timeout && (timeoutNotification = bidder.makeTimeoutNotification(httpCall.getRequest())) != null) {
            this.httpClient.request(timeoutNotification.getMethod(), timeoutNotification.getUri(), timeoutNotification.getHeaders(), timeoutNotification.getBody(), (long)this.timeoutNotificationTimeoutMs).map(response -> this.handleTimeoutNotificationSuccess((HttpClientResponse)response, timeoutNotification)).otherwise(exception -> this.handleTimeoutNotificationFailure((Throwable)exception, timeoutNotification));
        }
        return httpCall;
    }

    private Void handleTimeoutNotificationSuccess(HttpClientResponse response, HttpRequest<Void> timeoutNotification) {
        boolean isSuccessful = response.getStatusCode() >= 200 && response.getStatusCode() < 300;
        this.metrics.updateTimeoutNotificationMetric(isSuccessful);
        if (!(!this.logTimeoutNotificationResult || this.logTimeoutNotificationFailureOnly && isSuccessful)) {
            conditionalLogger.warn("Notified bidder about timeout. Status code: %s. Request body: %s".formatted(response.getStatusCode(), new String(timeoutNotification.getBody())), this.logTimeoutNotificationSamplingRate);
        }
        return null;
    }

    private Void handleTimeoutNotificationFailure(Throwable exception, HttpRequest<Void> timeoutNotification) {
        this.metrics.updateTimeoutNotificationMetric(false);
        if (this.logTimeoutNotificationResult) {
            conditionalLogger.warn("Error occurred while notifying bidder about timeout. Error message: %s. Request body: %s".formatted(exception.getMessage(), new String(timeoutNotification.getBody())), this.logTimeoutNotificationSamplingRate);
        }
        return null;
    }
}

