/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model;

import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.User;
import java.beans.ConstructorProperties;

public final class BidderPrivacyResult {
    private final String requestBidder;
    private final User user;
    private final Device device;
    private final boolean blockedRequestByTcf;
    private final boolean blockedAnalyticsByTcf;

    @ConstructorProperties(value={"requestBidder", "user", "device", "blockedRequestByTcf", "blockedAnalyticsByTcf"})
    BidderPrivacyResult(String requestBidder, User user, Device device, boolean blockedRequestByTcf, boolean blockedAnalyticsByTcf) {
        this.requestBidder = requestBidder;
        this.user = user;
        this.device = device;
        this.blockedRequestByTcf = blockedRequestByTcf;
        this.blockedAnalyticsByTcf = blockedAnalyticsByTcf;
    }

    public static BidderPrivacyResultBuilder builder() {
        return new BidderPrivacyResultBuilder();
    }

    public BidderPrivacyResultBuilder toBuilder() {
        return new BidderPrivacyResultBuilder().requestBidder(this.requestBidder).user(this.user).device(this.device).blockedRequestByTcf(this.blockedRequestByTcf).blockedAnalyticsByTcf(this.blockedAnalyticsByTcf);
    }

    public String getRequestBidder() {
        return this.requestBidder;
    }

    public User getUser() {
        return this.user;
    }

    public Device getDevice() {
        return this.device;
    }

    public boolean isBlockedRequestByTcf() {
        return this.blockedRequestByTcf;
    }

    public boolean isBlockedAnalyticsByTcf() {
        return this.blockedAnalyticsByTcf;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidderPrivacyResult)) {
            return false;
        }
        BidderPrivacyResult other = (BidderPrivacyResult)o;
        if (this.isBlockedRequestByTcf() != other.isBlockedRequestByTcf()) {
            return false;
        }
        if (this.isBlockedAnalyticsByTcf() != other.isBlockedAnalyticsByTcf()) {
            return false;
        }
        String this$requestBidder = this.getRequestBidder();
        String other$requestBidder = other.getRequestBidder();
        if (this$requestBidder == null ? other$requestBidder != null : !this$requestBidder.equals(other$requestBidder)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Device this$device = this.getDevice();
        Device other$device = other.getDevice();
        return !(this$device == null ? other$device != null : !((Object)this$device).equals(other$device));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBlockedRequestByTcf() ? 79 : 97);
        result = result * 59 + (this.isBlockedAnalyticsByTcf() ? 79 : 97);
        String $requestBidder = this.getRequestBidder();
        result = result * 59 + ($requestBidder == null ? 43 : $requestBidder.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Device $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
        return result;
    }

    public String toString() {
        return "BidderPrivacyResult(requestBidder=" + this.getRequestBidder() + ", user=" + this.getUser() + ", device=" + this.getDevice() + ", blockedRequestByTcf=" + this.isBlockedRequestByTcf() + ", blockedAnalyticsByTcf=" + this.isBlockedAnalyticsByTcf() + ")";
    }

    public static class BidderPrivacyResultBuilder {
        private String requestBidder;
        private User user;
        private Device device;
        private boolean blockedRequestByTcf;
        private boolean blockedAnalyticsByTcf;

        BidderPrivacyResultBuilder() {
        }

        public BidderPrivacyResultBuilder requestBidder(String requestBidder) {
            this.requestBidder = requestBidder;
            return this;
        }

        public BidderPrivacyResultBuilder user(User user) {
            this.user = user;
            return this;
        }

        public BidderPrivacyResultBuilder device(Device device) {
            this.device = device;
            return this;
        }

        public BidderPrivacyResultBuilder blockedRequestByTcf(boolean blockedRequestByTcf) {
            this.blockedRequestByTcf = blockedRequestByTcf;
            return this;
        }

        public BidderPrivacyResultBuilder blockedAnalyticsByTcf(boolean blockedAnalyticsByTcf) {
            this.blockedAnalyticsByTcf = blockedAnalyticsByTcf;
            return this;
        }

        public BidderPrivacyResult build() {
            return new BidderPrivacyResult(this.requestBidder, this.user, this.device, this.blockedRequestByTcf, this.blockedAnalyticsByTcf);
        }

        public String toString() {
            return "BidderPrivacyResult.BidderPrivacyResultBuilder(requestBidder=" + this.requestBidder + ", user=" + this.user + ", device=" + this.device + ", blockedRequestByTcf=" + this.blockedRequestByTcf + ", blockedAnalyticsByTcf=" + this.blockedAnalyticsByTcf + ")";
        }
    }
}

