/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Content;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.request.video.BidRequestVideo;
import com.iab.openrtb.request.video.IncludeBrandCategory;
import com.iab.openrtb.request.video.Pod;
import com.iab.openrtb.request.video.PodError;
import com.iab.openrtb.request.video.Podconfig;
import io.vertx.core.Future;
import io.vertx.core.file.FileSystem;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.PriceGranularity;
import org.prebid.server.auction.model.Tuple2;
import org.prebid.server.auction.model.WithPodErrors;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.json.JsonMerger;
import org.prebid.server.metric.Metrics;
import org.prebid.server.proto.openrtb.ext.ExtIncludeBrandCategory;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCache;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCacheVastxml;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.validation.VideoRequestValidator;

public class VideoStoredRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(VideoStoredRequestProcessor.class);
    private static final String DEFAULT_CURRENCY = "USD";
    private final boolean enforceStoredRequest;
    private final List<String> blacklistedAccounts;
    private final long defaultTimeout;
    private final String currency;
    private final BidRequest defaultBidRequest;
    private final ApplicationSettings applicationSettings;
    private final VideoRequestValidator validator;
    private final Metrics metrics;
    private final TimeoutFactory timeoutFactory;
    private final JacksonMapper mapper;
    private final JsonMerger jsonMerger;

    public VideoStoredRequestProcessor(boolean enforceStoredRequest, List<String> blacklistedAccounts, long defaultTimeout, String adServerCurrency, String defaultBidRequestPath, FileSystem fileSystem, ApplicationSettings applicationSettings, VideoRequestValidator validator, Metrics metrics, TimeoutFactory timeoutFactory, JacksonMapper mapper, JsonMerger jsonMerger) {
        this.enforceStoredRequest = enforceStoredRequest;
        this.blacklistedAccounts = Objects.requireNonNull(blacklistedAccounts);
        this.defaultTimeout = defaultTimeout;
        this.currency = StringUtils.isBlank((CharSequence)adServerCurrency) ? DEFAULT_CURRENCY : adServerCurrency;
        this.defaultBidRequest = VideoStoredRequestProcessor.readBidRequest(defaultBidRequestPath, Objects.requireNonNull(fileSystem), Objects.requireNonNull(mapper));
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.validator = Objects.requireNonNull(validator);
        this.metrics = Objects.requireNonNull(metrics);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.mapper = Objects.requireNonNull(mapper);
        this.jsonMerger = Objects.requireNonNull(jsonMerger);
    }

    public Future<WithPodErrors<BidRequest>> processVideoRequest(String accountId, String storedBidRequestId, Set<String> podIds, BidRequestVideo videoRequest) {
        Set<String> storedRequestIds = StringUtils.isNotBlank((CharSequence)storedBidRequestId) ? Collections.singleton(storedBidRequestId) : Collections.emptySet();
        return this.applicationSettings.getVideoStoredData(accountId, storedRequestIds, podIds, this.timeoutFactory.create(this.defaultTimeout)).map(storedDataResult -> this.updateMetrics((StoredDataResult)storedDataResult, storedRequestIds, podIds)).map(storedData -> this.toBidRequestWithPodErrors((StoredDataResult)storedData, videoRequest, storedBidRequestId)).recover(exception -> Future.failedFuture((Throwable)new InvalidRequestException("Stored request fetching failed: " + exception.getMessage())));
    }

    private static BidRequest readBidRequest(String defaultBidRequestPath, FileSystem fileSystem, JacksonMapper mapper) {
        return StringUtils.isNotBlank((CharSequence)defaultBidRequestPath) ? mapper.decodeValue(fileSystem.readFileBlocking(defaultBidRequestPath), BidRequest.class) : null;
    }

    private StoredDataResult updateMetrics(StoredDataResult storedDataResult, Set<String> requestIds, Set<String> impIds) {
        requestIds.forEach(id -> this.metrics.updateStoredRequestMetric(storedDataResult.getStoredIdToRequest().containsKey(id)));
        impIds.forEach(id -> this.metrics.updateStoredImpsMetric(storedDataResult.getStoredIdToImp().containsKey(id)));
        return storedDataResult;
    }

    private WithPodErrors<BidRequest> toBidRequestWithPodErrors(StoredDataResult storedResult, BidRequestVideo videoRequest, String storedBidRequestId) {
        BidRequestVideo mergedStoredRequest = this.mergeBidRequest(videoRequest, storedBidRequestId, storedResult);
        this.validator.validateStoredBidRequest(mergedStoredRequest, this.enforceStoredRequest, this.blacklistedAccounts);
        Podconfig podconfig = mergedStoredRequest.getPodconfig();
        Video video = mergedStoredRequest.getVideo();
        Map<String, String> storedIdToImp = storedResult.getStoredIdToImp();
        WithPodErrors<List<Imp>> impsToPodErrors = this.mergeStoredImps(podconfig, video, storedIdToImp);
        BidRequest bidRequest = this.mergeWithDefaultBidRequest(mergedStoredRequest, impsToPodErrors.getData());
        return WithPodErrors.of(bidRequest, impsToPodErrors.getPodErrors());
    }

    private BidRequestVideo mergeBidRequest(BidRequestVideo originalRequest, String storedRequestId, StoredDataResult storedDataResult) {
        String storedRequest = storedDataResult.getStoredIdToRequest().get(storedRequestId);
        if (this.enforceStoredRequest && StringUtils.isBlank((CharSequence)storedRequest)) {
            throw new InvalidRequestException("Stored request is enforced but not found");
        }
        return StringUtils.isNotBlank((CharSequence)storedRequest) ? this.jsonMerger.merge(originalRequest, storedRequest, storedRequestId, BidRequestVideo.class) : originalRequest;
    }

    private WithPodErrors<List<Imp>> mergeStoredImps(Podconfig podconfig, Video video, Map<String, String> storedImpIdToJsonImp) {
        Map<String, Imp> storedImpIdToImp = this.storedIdToStoredImp(storedImpIdToJsonImp);
        WithPodErrors<List<Pod>> validPodsToPodErrors = this.validator.validPods(podconfig, storedImpIdToImp.keySet());
        List<Pod> validPods = validPodsToPodErrors.getData();
        List<PodError> podErrors = validPodsToPodErrors.getPodErrors();
        if (CollectionUtils.isEmpty(validPods)) {
            String errorMessage = podErrors.stream().map(PodError::getPodErrors).map(errorsForPod -> String.join((CharSequence)", ", errorsForPod)).collect(Collectors.joining("; "));
            throw new InvalidRequestException("all pods are incorrect:  " + errorMessage);
        }
        List<Imp> imps = VideoStoredRequestProcessor.createImps(storedImpIdToImp, validPods, podconfig, video);
        return WithPodErrors.of(imps, podErrors);
    }

    private Map<String, Imp> storedIdToStoredImp(Map<String, String> storedIdToImp) {
        HashMap<String, Imp> idToImps = new HashMap<String, Imp>();
        if (MapUtils.isNotEmpty(storedIdToImp)) {
            for (Map.Entry<String, String> idToImp : storedIdToImp.entrySet()) {
                try {
                    idToImps.put(idToImp.getKey(), (Imp)this.mapper.mapper().readValue(idToImp.getValue(), Imp.class));
                }
                catch (JsonProcessingException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        return idToImps;
    }

    private static List<Imp> createImps(Map<String, Imp> idToImps, List<Pod> validPods, Podconfig podconfig, Video video) {
        List<Integer> durationRangeSec = podconfig.getDurationRangeSec();
        Boolean requireExactDuration = podconfig.getRequireExactDuration();
        Tuple2<Integer, Integer> maxMin = VideoStoredRequestProcessor.minMax(durationRangeSec);
        ArrayList<Imp> imps = new ArrayList<Imp>();
        for (Pod pod : validPods) {
            Integer adpodDurationSec = pod.getAdpodDurationSec();
            int numImps = adpodDurationSec / maxMin.getLeft();
            if (BooleanUtils.isTrue((Boolean)requireExactDuration) || numImps == 0) {
                numImps = Math.max(numImps, durationRangeSec.size());
            }
            int impDivNumber = numImps / durationRangeSec.size();
            for (int i = 0; i < numImps; ++i) {
                Integer maxDuration;
                Integer minDuration = null;
                if (BooleanUtils.isTrue((Boolean)requireExactDuration)) {
                    int durationIndex = i / impDivNumber;
                    if (durationIndex > durationRangeSec.size() - 1) {
                        durationIndex = durationRangeSec.size() - 1;
                    }
                    maxDuration = durationRangeSec.get(durationIndex);
                    minDuration = durationRangeSec.get(durationIndex);
                } else {
                    maxDuration = maxMin.getRight();
                }
                String podConfigId = pod.getConfigId();
                Imp storedImp = idToImps.get(podConfigId);
                if (storedImp == null) continue;
                Imp imp = storedImp.toBuilder().id("%d_%d".formatted(pod.getPodId(), i)).video(VideoStoredRequestProcessor.updateVideo(video, minDuration, maxDuration)).build();
                imps.add(imp);
            }
        }
        return imps;
    }

    private static Tuple2<Integer, Integer> minMax(List<Integer> values) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Integer value : values) {
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        return Tuple2.of(min, max);
    }

    private static Video updateVideo(Video video, Integer minDuration, Integer maxDuration) {
        return video.toBuilder().minduration(minDuration).maxduration(maxDuration).build();
    }

    private BidRequest mergeWithDefaultBidRequest(BidRequestVideo videoRequest, List<Imp> imps) {
        Regs regs;
        List<String> badv;
        List<String> bcat;
        User user;
        Device device;
        App app;
        BidRequest.BidRequestBuilder bidRequestBuilder = this.defaultBidRequest != null ? this.defaultBidRequest.toBuilder() : BidRequest.builder();
        Site site = videoRequest.getSite();
        if (site != null) {
            Site updatedSite = VideoStoredRequestProcessor.updateSite(site, videoRequest);
            bidRequestBuilder.site(updatedSite);
        }
        if ((app = videoRequest.getApp()) != null) {
            App updatedApp = VideoStoredRequestProcessor.updateApp(app, videoRequest);
            bidRequestBuilder.app(updatedApp);
        }
        if ((device = videoRequest.getDevice()) != null) {
            bidRequestBuilder.device(device);
        }
        if ((user = videoRequest.getUser()) != null) {
            bidRequestBuilder.user(user);
        }
        if (CollectionUtils.isNotEmpty(bcat = videoRequest.getBcat())) {
            bidRequestBuilder.bcat(bcat);
        }
        if (CollectionUtils.isNotEmpty(badv = videoRequest.getBadv())) {
            bidRequestBuilder.badv(badv);
        }
        if ((regs = videoRequest.getRegs()) != null) {
            bidRequestBuilder.regs(regs);
        }
        bidRequestBuilder.tmax(videoRequest.getTmax());
        this.addRequiredOpenRtbFields(bidRequestBuilder);
        return bidRequestBuilder.id("bid_id").imp(imps).ext(this.createExtRequest(videoRequest)).test(videoRequest.getTest()).build();
    }

    private static Site updateSite(Site site, BidRequestVideo videoRequest) {
        Content content = videoRequest.getContent();
        if (content != null) {
            return site.toBuilder().content(content).build();
        }
        return site;
    }

    private static App updateApp(App app, BidRequestVideo videoRequest) {
        Content content = videoRequest.getContent();
        if (content != null) {
            return app.toBuilder().content(content).build();
        }
        return app;
    }

    private void addRequiredOpenRtbFields(BidRequest.BidRequestBuilder bidRequestBuilder) {
        bidRequestBuilder.cur(Collections.singletonList(this.currency));
    }

    private ExtRequest createExtRequest(BidRequestVideo videoRequest) {
        ExtRequestPrebidCache cache = ExtRequestPrebidCache.of(null, ExtRequestPrebidCacheVastxml.of(null, null), null);
        ExtIncludeBrandCategory extIncludeBrandCategory = VideoStoredRequestProcessor.createExtIncludeBrandCategory(videoRequest);
        Podconfig podconfig = videoRequest.getPodconfig();
        List<Integer> durationRangeSec = BooleanUtils.isFalse((Boolean)podconfig.getRequireExactDuration()) ? podconfig.getDurationRangeSec() : null;
        PriceGranularity priceGranularity = videoRequest.getPricegranularity();
        Integer precision = priceGranularity != null ? priceGranularity.getPrecision() : null;
        PriceGranularity updatedPriceGranularity = precision != null && precision != 0 ? priceGranularity : PriceGranularity.createFromString("med");
        ExtRequestTargeting targeting = ExtRequestTargeting.builder().includebidderkeys(true).includebrandcategory(extIncludeBrandCategory).durationrangesec(durationRangeSec).pricegranularity(this.mapper.mapper().valueToTree((Object)updatedPriceGranularity)).appendbiddernames(videoRequest.getAppendbiddernames()).build();
        ExtRequestPrebid extRequestPrebid = ExtRequestPrebid.builder().cache(cache).targeting(targeting).build();
        return ExtRequest.of(extRequestPrebid);
    }

    private static ExtIncludeBrandCategory createExtIncludeBrandCategory(BidRequestVideo videoRequest) {
        IncludeBrandCategory includeBrandCategory = videoRequest.getIncludebrandcategory();
        if (includeBrandCategory != null) {
            return ExtIncludeBrandCategory.of(includeBrandCategory.getPrimaryAdserver(), includeBrandCategory.getPublisher(), true, includeBrandCategory.getTranslateCategories());
        }
        return ExtIncludeBrandCategory.of(null, null, false, null);
    }
}

