/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.iab.openrtb.request.User;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.BidderAliases;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.model.UpdateResult;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.ExtUserPrebid;
import org.prebid.server.util.ObjectUtil;

public class UidUpdater {
    private final String hostCookieFamily;
    private final BidderCatalog bidderCatalog;
    private final UidsCookieService uidsCookieService;

    public UidUpdater(String hostCookieFamily, BidderCatalog bidderCatalog, UidsCookieService uidsCookieService) {
        this.hostCookieFamily = hostCookieFamily;
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
    }

    public UpdateResult<String> updateUid(String bidder, AuctionContext auctionContext, BidderAliases aliases) {
        String uidFromUser;
        User user = auctionContext.getBidRequest().getUser();
        String string = uidFromUser = user != null ? user.getBuyeruid() : null;
        if (StringUtils.isNotBlank((CharSequence)uidFromUser)) {
            return UpdateResult.unaltered(uidFromUser);
        }
        String resolvedBidder = aliases.resolveBidder(bidder);
        String baseBidder = this.bidderCatalog.resolveBaseBidder(resolvedBidder);
        String uidFromExt = UidUpdater.uidFromExtUser(user, bidder, resolvedBidder, baseBidder);
        String uidFromUidsCookie = this.uidFromUidsCookie(auctionContext.getUidsCookie(), resolvedBidder);
        String uidFromHostCookie = this.uidFromHostCookie(auctionContext, resolvedBidder);
        return Stream.of(uidFromExt, uidFromUidsCookie, uidFromHostCookie).filter(StringUtils::isNotBlank).findFirst().map(UpdateResult::updated).orElse(UpdateResult.unaltered(null));
    }

    private static String uidFromExtUser(User user, String bidder, String resolvedBidder, String baseBidder) {
        Map buyeruids = Optional.ofNullable(user).map(User::getExt).map(ExtUser::getPrebid).map(ExtUserPrebid::getBuyeruids).map(CaseInsensitiveMap::new).orElse(Collections.emptyMap());
        return (String)ObjectUtil.firstNonNull(() -> (String)buyeruids.get(bidder), () -> (String)buyeruids.get(resolvedBidder), () -> (String)buyeruids.get(baseBidder));
    }

    private String uidFromUidsCookie(UidsCookie uidsCookie, String bidder) {
        return this.bidderCatalog.cookieFamilyName(bidder).map(uidsCookie::uidFrom).orElse(null);
    }

    private String uidFromHostCookie(AuctionContext auctionContext, String bidder) {
        return this.bidderCatalog.cookieFamilyName(bidder).filter(cookieFamily -> StringUtils.equals((CharSequence)cookieFamily, (CharSequence)this.hostCookieFamily)).map(cookieFamily -> this.uidsCookieService.parseHostCookie(auctionContext.getHttpRequest())).orElse(null);
    }
}

