/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.Future;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.AuctionParticipation;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.auction.model.BidderResponse;
import org.prebid.server.auction.model.StoredResponseResult;
import org.prebid.server.auction.model.Tuple2;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderSeatBid;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.ExtImp;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtStoredAuctionResponse;
import org.prebid.server.proto.openrtb.ext.request.ExtStoredBidResponse;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.StoredResponseDataResult;

public class StoredResponseProcessor {
    private static final String PREBID_EXT = "prebid";
    private static final String DEFAULT_BID_CURRENCY = "USD";
    private static final String PBS_IMPID_MACRO = "##PBSIMPID##";
    private static final TypeReference<List<SeatBid>> SEATBID_LIST_TYPE = new TypeReference<List<SeatBid>>(){};
    private final ApplicationSettings applicationSettings;
    private final JacksonMapper mapper;

    public StoredResponseProcessor(ApplicationSettings applicationSettings, JacksonMapper mapper) {
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.mapper = Objects.requireNonNull(mapper);
    }

    Future<StoredResponseResult> getStoredResponseResult(List<Imp> imps, Timeout timeout) {
        Map<String, ExtImpPrebid> impExtPrebids = this.getImpsExtPrebid(imps);
        Map<String, String> auctionStoredResponseToImpId = this.getAuctionStoredResponses(impExtPrebids);
        List<Imp> requiredRequestImps = this.excludeStoredAuctionResponseImps(imps, auctionStoredResponseToImpId);
        Map<String, Map<String, String>> impToBidderToStoredBidResponseId = this.getStoredBidResponses(impExtPrebids, requiredRequestImps);
        HashSet<String> storedIds = new HashSet<String>(auctionStoredResponseToImpId.keySet());
        storedIds.addAll(impToBidderToStoredBidResponseId.values().stream().flatMap(bidderToId -> bidderToId.values().stream()).collect(Collectors.toSet()));
        if (storedIds.isEmpty()) {
            return Future.succeededFuture((Object)StoredResponseResult.of(imps, Collections.emptyList(), Collections.emptyMap()));
        }
        return this.applicationSettings.getStoredResponses(storedIds, timeout).recover(exception -> Future.failedFuture((Throwable)new InvalidRequestException("Stored response fetching failed with reason: " + exception.getMessage()))).map(storedResponseDataResult -> StoredResponseResult.of(requiredRequestImps, this.convertToSeatBid((StoredResponseDataResult)storedResponseDataResult, auctionStoredResponseToImpId), this.mapStoredBidResponseIdsToValues(storedResponseDataResult.getIdToStoredResponses(), impToBidderToStoredBidResponseId)));
    }

    private List<Imp> excludeStoredAuctionResponseImps(List<Imp> imps, Map<String, String> auctionStoredResponseToImpId) {
        return imps.stream().filter(imp -> !auctionStoredResponseToImpId.containsValue(imp.getId())).toList();
    }

    public List<AuctionParticipation> updateStoredBidResponse(List<AuctionParticipation> auctionParticipations) {
        return auctionParticipations.stream().map(StoredResponseProcessor::updateStoredBidResponse).collect(Collectors.toList());
    }

    private static AuctionParticipation updateStoredBidResponse(AuctionParticipation auctionParticipation) {
        BidderRequest bidderRequest = auctionParticipation.getBidderRequest();
        BidRequest bidRequest = bidderRequest.getBidRequest();
        List<Imp> imps = bidRequest.getImp();
        if (imps.size() > 1 || StringUtils.isEmpty((CharSequence)bidderRequest.getStoredResponse())) {
            return auctionParticipation;
        }
        BidderResponse bidderResponse = auctionParticipation.getBidderResponse();
        BidderSeatBid initialSeatBid = bidderResponse.getSeatBid();
        BidderSeatBid adjustedSeatBid = StoredResponseProcessor.updateSeatBid(initialSeatBid, imps.get(0).getId());
        return auctionParticipation.with(bidderResponse.with(adjustedSeatBid));
    }

    private static BidderSeatBid updateSeatBid(BidderSeatBid bidderSeatBid, String impId) {
        List<BidderBid> bids = bidderSeatBid.getBids().stream().map(bidderBid -> StoredResponseProcessor.resolveBidImpId(bidderBid, impId)).collect(Collectors.toList());
        return bidderSeatBid.with(bids);
    }

    private static BidderBid resolveBidImpId(BidderBid bidderBid, String impId) {
        Bid bid = bidderBid.getBid();
        String bidImpId = bid.getImpid();
        if (!StringUtils.contains((CharSequence)bidImpId, (CharSequence)PBS_IMPID_MACRO)) {
            return bidderBid;
        }
        return bidderBid.toBuilder().bid(bid.toBuilder().impid(bidImpId.replace(PBS_IMPID_MACRO, impId)).build()).build();
    }

    List<AuctionParticipation> mergeWithBidderResponses(List<AuctionParticipation> auctionParticipations, List<SeatBid> storedAuctionResponses, List<Imp> imps) {
        if (CollectionUtils.isEmpty(storedAuctionResponses)) {
            return auctionParticipations;
        }
        Map bidderToAuctionParticipation = auctionParticipations.stream().collect(Collectors.toMap(AuctionParticipation::getBidder, Function.identity()));
        Map bidderToSeatBid = storedAuctionResponses.stream().collect(Collectors.toMap(SeatBid::getSeat, Function.identity()));
        Map<String, BidType> impIdToBidType = imps.stream().collect(Collectors.toMap(Imp::getId, this::resolveBidType));
        HashSet<String> responseBidders = new HashSet<String>(bidderToAuctionParticipation.keySet());
        responseBidders.addAll(bidderToSeatBid.keySet());
        return responseBidders.stream().map(bidder -> this.updateBidderResponse((AuctionParticipation)bidderToAuctionParticipation.get(bidder), (SeatBid)bidderToSeatBid.get(bidder), impIdToBidType)).toList();
    }

    private Map<String, ExtImpPrebid> getImpsExtPrebid(List<Imp> imps) {
        return imps.stream().collect(Collectors.toMap(Imp::getId, imp -> this.getExtImp(imp.getExt(), imp.getId()).getPrebid()));
    }

    private Map<String, String> getAuctionStoredResponses(Map<String, ExtImpPrebid> extImpPrebids) {
        return extImpPrebids.entrySet().stream().map(impIdToExtPrebid -> Tuple2.of((String)impIdToExtPrebid.getKey(), this.extractAuctionStoredResponseId((ExtImpPrebid)impIdToExtPrebid.getValue()))).filter(impIdToStoredResponseId -> impIdToStoredResponseId.getRight() != null).collect(Collectors.toMap(Tuple2::getRight, Tuple2::getLeft));
    }

    private String extractAuctionStoredResponseId(ExtImpPrebid extImpPrebid) {
        ExtStoredAuctionResponse storedAuctionResponse = extImpPrebid.getStoredAuctionResponse();
        return storedAuctionResponse != null ? storedAuctionResponse.getId() : null;
    }

    private Map<String, Map<String, String>> getStoredBidResponses(Map<String, ExtImpPrebid> extImpPrebids, List<Imp> imps) {
        if (imps.size() != 1) {
            return Collections.emptyMap();
        }
        Set impsIds = imps.stream().map(Imp::getId).collect(Collectors.toSet());
        return extImpPrebids.entrySet().stream().filter(impIdToExtPrebid -> impsIds.contains(impIdToExtPrebid.getKey())).filter(impIdToExtPrebid -> CollectionUtils.isNotEmpty(((ExtImpPrebid)impIdToExtPrebid.getValue()).getStoredBidResponse())).collect(Collectors.toMap(Map.Entry::getKey, impIdToStoredResponses -> this.resolveStoredBidResponse(((ExtImpPrebid)impIdToStoredResponses.getValue()).getStoredBidResponse())));
    }

    private ExtImp getExtImp(ObjectNode extImpNode, String impId) {
        try {
            return (ExtImp)this.mapper.mapper().treeToValue((TreeNode)extImpNode, ExtImp.class);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Error decoding bidRequest.imp.ext for impId = %s : %s".formatted(impId, e.getMessage()));
        }
    }

    private Map<String, String> resolveStoredBidResponse(List<ExtStoredBidResponse> storedBidResponse) {
        return storedBidResponse.stream().collect(Collectors.toMap(ExtStoredBidResponse::getBidder, ExtStoredBidResponse::getId));
    }

    private List<SeatBid> convertToSeatBid(StoredResponseDataResult storedResponseDataResult, Map<String, String> auctionStoredResponses) {
        ArrayList<SeatBid> resolvedSeatBids = new ArrayList<SeatBid>();
        Map<String, String> idToStoredResponses = storedResponseDataResult.getIdToStoredResponses();
        for (Map.Entry<String, String> storedIdToImpId : auctionStoredResponses.entrySet()) {
            String id = storedIdToImpId.getKey();
            String impId = storedIdToImpId.getValue();
            String rowSeatBid = idToStoredResponses.get(id);
            if (rowSeatBid == null) {
                throw new InvalidRequestException("Failed to fetch stored auction response for impId = %s and storedAuctionResponse id = %s.".formatted(impId, id));
            }
            List<SeatBid> seatBids = this.parseSeatBid(id, rowSeatBid);
            this.validateStoredSeatBid(seatBids);
            resolvedSeatBids.addAll(seatBids.stream().map(seatBid -> this.updateSeatBidBids((SeatBid)seatBid, impId)).toList());
        }
        return this.mergeSameBidderSeatBid(resolvedSeatBids);
    }

    private List<SeatBid> parseSeatBid(String id, String rowSeatBid) {
        try {
            return (List)this.mapper.mapper().readValue(rowSeatBid, SEATBID_LIST_TYPE);
        }
        catch (IOException e) {
            throw new InvalidRequestException("Can't parse Json for stored response with id " + id);
        }
    }

    private SeatBid updateSeatBidBids(SeatBid seatBid, String impId) {
        return seatBid.toBuilder().bid(this.updateBidsWithImpId(seatBid.getBid(), impId)).build();
    }

    private List<Bid> updateBidsWithImpId(List<Bid> bids, String impId) {
        return bids.stream().map(bid -> StoredResponseProcessor.updateBidWithImpId(bid, impId)).toList();
    }

    private static Bid updateBidWithImpId(Bid bid, String impId) {
        return bid.toBuilder().impid(impId).build();
    }

    private void validateStoredSeatBid(List<SeatBid> seatBids) {
        for (SeatBid seatBid : seatBids) {
            if (StringUtils.isEmpty((CharSequence)seatBid.getSeat())) {
                throw new InvalidRequestException("Seat can't be empty in stored response seatBid");
            }
            if (!CollectionUtils.isEmpty(seatBid.getBid())) continue;
            throw new InvalidRequestException("There must be at least one bid in stored response seatBid");
        }
    }

    private List<SeatBid> mergeSameBidderSeatBid(List<SeatBid> seatBids) {
        return seatBids.stream().collect(Collectors.groupingBy(SeatBid::getSeat, Collectors.toList())).entrySet().stream().map(bidderToSeatBid -> this.makeMergedSeatBid((String)bidderToSeatBid.getKey(), (List)bidderToSeatBid.getValue())).toList();
    }

    private SeatBid makeMergedSeatBid(String seat, List<SeatBid> storedSeatBids) {
        return SeatBid.builder().bid(storedSeatBids.stream().map(SeatBid::getBid).flatMap(Collection::stream).toList()).seat(seat).ext(storedSeatBids.stream().map(SeatBid::getExt).filter(Objects::nonNull).findFirst().orElse(null)).build();
    }

    private Map<String, Map<String, String>> mapStoredBidResponseIdsToValues(Map<String, String> idToStoredResponses, Map<String, Map<String, String>> impToBidderToStoredBidResponseId) {
        return impToBidderToStoredBidResponseId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Map)((Map)entry.getValue()).entrySet().stream().filter(bidderToId -> idToStoredResponses.containsKey(bidderToId.getValue())).collect(Collectors.toMap(Map.Entry::getKey, bidderToId -> (String)idToStoredResponses.get(bidderToId.getValue()), (first, second) -> second, CaseInsensitiveMap::new))));
    }

    private AuctionParticipation updateBidderResponse(AuctionParticipation auctionParticipation, SeatBid storedSeatBid, Map<String, BidType> impIdToBidType) {
        if (auctionParticipation != null) {
            if (auctionParticipation.isRequestBlocked()) {
                return auctionParticipation;
            }
            BidderResponse bidderResponse = auctionParticipation.getBidderResponse();
            BidderSeatBid bidderSeatBid = bidderResponse.getSeatBid();
            BidderSeatBid updatedSeatBid = storedSeatBid == null ? bidderSeatBid : this.makeBidderSeatBid(bidderSeatBid, storedSeatBid, impIdToBidType);
            BidderResponse updatedBidderResponse = BidderResponse.of(bidderResponse.getBidder(), updatedSeatBid, bidderResponse.getResponseTime());
            return auctionParticipation.with(updatedBidderResponse);
        }
        String bidder = storedSeatBid != null ? storedSeatBid.getSeat() : null;
        BidderSeatBid updatedSeatBid = this.makeBidderSeatBid(null, storedSeatBid, impIdToBidType);
        BidderResponse updatedBidderResponse = BidderResponse.of(bidder, updatedSeatBid, 0);
        return AuctionParticipation.builder().bidder(bidder).bidderResponse(updatedBidderResponse).build();
    }

    private BidderSeatBid makeBidderSeatBid(BidderSeatBid bidderSeatBid, SeatBid seatBid, Map<String, BidType> impIdToBidType) {
        ArrayList<BidderBid> bidderBids;
        boolean nonNullBidderSeatBid = bidderSeatBid != null;
        String bidCurrency = nonNullBidderSeatBid ? bidderSeatBid.getBids().stream().map(BidderBid::getBidCurrency).filter(Objects::nonNull).findAny().orElse(DEFAULT_BID_CURRENCY) : DEFAULT_BID_CURRENCY;
        List<BidderBid> list = bidderBids = seatBid != null ? (List)seatBid.getBid().stream().map(bid -> this.makeBidderBid((Bid)bid, bidCurrency, impIdToBidType)).collect(Collectors.toCollection(ArrayList::new)) : new ArrayList<BidderBid>();
        if (nonNullBidderSeatBid) {
            bidderBids.addAll(bidderSeatBid.getBids());
        }
        return nonNullBidderSeatBid ? bidderSeatBid.with(bidderBids) : BidderSeatBid.of(bidderBids);
    }

    private BidderBid makeBidderBid(Bid bid, String bidCurrency, Map<String, BidType> impIdToBidType) {
        return BidderBid.of(bid, this.getBidType(bid.getExt(), impIdToBidType.get(bid.getImpid())), bidCurrency);
    }

    private BidType getBidType(ObjectNode bidExt, BidType bidType) {
        ObjectNode bidExtPrebid = bidExt != null ? (ObjectNode)bidExt.get(PREBID_EXT) : null;
        ExtBidPrebid extBidPrebid = bidExtPrebid != null ? this.parseExtBidPrebid(bidExtPrebid) : null;
        return extBidPrebid != null ? extBidPrebid.getType() : bidType;
    }

    private ExtBidPrebid parseExtBidPrebid(ObjectNode bidExtPrebid) {
        try {
            return (ExtBidPrebid)this.mapper.mapper().treeToValue((TreeNode)bidExtPrebid, ExtBidPrebid.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Error decoding stored response bid.ext.prebid");
        }
    }

    private BidType resolveBidType(Imp imp) {
        BidType bidType = BidType.banner;
        if (imp.getBanner() != null) {
            return bidType;
        }
        if (imp.getVideo() != null) {
            bidType = BidType.video;
        } else if (imp.getXNative() != null) {
            bidType = BidType.xNative;
        } else if (imp.getAudio() != null) {
            bidType = BidType.audio;
        }
        return bidType;
    }
}

