/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixList;
import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.util.HttpUtil;

public class ImplicitParametersExtractor {
    private final PublicSuffixList psl;

    public ImplicitParametersExtractor(PublicSuffixList psl) {
        this.psl = Objects.requireNonNull(psl);
    }

    public String refererFrom(HttpRequestContext request) {
        String urlOverride = request.getQueryParams().get("url_override");
        String url = StringUtils.isNotBlank((CharSequence)urlOverride) ? urlOverride : StringUtils.trimToNull((String)request.getHeaders().get(HttpUtil.REFERER_HEADER));
        return StringUtils.isNotBlank((CharSequence)url) && !StringUtils.startsWith((CharSequence)url, (CharSequence)"http") ? "http://" + url : url;
    }

    public String domainFrom(String host) throws PreBidException {
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new PreBidException("Host is not defined or can not be derived from request");
        }
        String domain = this.psl.getRegistrableDomain(host);
        if (domain == null) {
            throw new PreBidException("Cannot derive eTLD+1 for host " + host);
        }
        return domain;
    }

    public List<String> ipFrom(CaseInsensitiveMultiMap headers, String host) {
        return this.ipFrom(headers::get, host);
    }

    public List<String> ipFrom(MultiMap headers, String host) {
        return this.ipFrom(arg_0 -> ((MultiMap)headers).get(arg_0), host);
    }

    private List<String> ipFrom(Function<String, String> headerGetter, String host) {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(headerGetter.apply("True-Client-IP"));
        String xff = headerGetter.apply("X-Forwarded-For");
        if (xff != null) {
            candidates.addAll(Arrays.asList(xff.split(",")));
        }
        candidates.add(headerGetter.apply("X-Real-IP"));
        candidates.add(host);
        return candidates.stream().map(StringUtils::trimToNull).filter(Objects::nonNull).toList();
    }

    public String uaFrom(HttpRequestContext request) {
        return StringUtils.trimToNull((String)request.getHeaders().get(HttpUtil.USER_AGENT_HEADER));
    }

    public Integer secureFrom(HttpRequestContext httpRequest) {
        return StringUtils.equalsIgnoreCase((CharSequence)httpRequest.getHeaders().get("X-Forwarded-Proto"), (CharSequence)"https") || StringUtils.equalsIgnoreCase((CharSequence)httpRequest.getScheme(), (CharSequence)"https") ? Integer.valueOf(1) : null;
    }

    public String gpcFrom(HttpRequestContext httpRequest) {
        String gpcAsString = httpRequest.getHeaders().get(HttpUtil.SEC_GPC_HEADER);
        return "1".equals(gpcAsString) || "\"1\"".equals(gpcAsString) ? "1" : null;
    }
}

