/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Content;
import com.iab.openrtb.request.Deal;
import com.iab.openrtb.request.Dooh;
import com.iab.openrtb.request.Eid;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.SupplyChain;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.math.BigDecimal;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.activity.infrastructure.payload.impl.ActivityInvocationPayloadImpl;
import org.prebid.server.activity.infrastructure.payload.impl.BidRequestActivityInvocationPayload;
import org.prebid.server.auction.BidResponseCreator;
import org.prebid.server.auction.BidResponsePostProcessor;
import org.prebid.server.auction.BidderAliases;
import org.prebid.server.auction.DebugResolver;
import org.prebid.server.auction.FpdResolver;
import org.prebid.server.auction.ImpMediaTypeResolver;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.auction.StoredResponseProcessor;
import org.prebid.server.auction.SupplyChainResolver;
import org.prebid.server.auction.TimeoutResolver;
import org.prebid.server.auction.UidUpdater;
import org.prebid.server.auction.adjustment.BidAdjustmentFactorResolver;
import org.prebid.server.auction.mediatypeprocessor.MediaTypeProcessingResult;
import org.prebid.server.auction.mediatypeprocessor.MediaTypeProcessor;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.AuctionParticipation;
import org.prebid.server.auction.model.BidRejectionReason;
import org.prebid.server.auction.model.BidRejectionTracker;
import org.prebid.server.auction.model.BidRequestCacheInfo;
import org.prebid.server.auction.model.BidderPrivacyResult;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.auction.model.BidderResponse;
import org.prebid.server.auction.model.MultiBidConfig;
import org.prebid.server.auction.model.StoredResponseResult;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConversionManager;
import org.prebid.server.auction.versionconverter.OrtbVersion;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.bidder.HttpBidderRequester;
import org.prebid.server.bidder.Usersyncer;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.BidderSeatBid;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.deals.DealsService;
import org.prebid.server.deals.events.ApplicationEventService;
import org.prebid.server.deals.model.TxnLog;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.floors.PriceFloorAdjuster;
import org.prebid.server.floors.PriceFloorEnforcer;
import org.prebid.server.hooks.execution.HookStageExecutor;
import org.prebid.server.hooks.execution.model.ExecutionAction;
import org.prebid.server.hooks.execution.model.ExecutionStatus;
import org.prebid.server.hooks.execution.model.GroupExecutionOutcome;
import org.prebid.server.hooks.execution.model.HookExecutionOutcome;
import org.prebid.server.hooks.execution.model.HookId;
import org.prebid.server.hooks.execution.model.HookStageExecutionResult;
import org.prebid.server.hooks.execution.model.Stage;
import org.prebid.server.hooks.execution.model.StageExecutionOutcome;
import org.prebid.server.hooks.v1.analytics.AppliedTo;
import org.prebid.server.hooks.v1.analytics.Result;
import org.prebid.server.hooks.v1.analytics.Tags;
import org.prebid.server.hooks.v1.auction.AuctionResponsePayload;
import org.prebid.server.hooks.v1.bidder.BidderRequestPayload;
import org.prebid.server.hooks.v1.bidder.BidderResponsePayload;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.log.CriteriaLogManager;
import org.prebid.server.log.HttpInteractionLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.UpdateResult;
import org.prebid.server.proto.openrtb.ext.ExtPrebidBidders;
import org.prebid.server.proto.openrtb.ext.request.ExtApp;
import org.prebid.server.proto.openrtb.ext.request.ExtBidderConfigOrtb;
import org.prebid.server.proto.openrtb.ext.request.ExtDooh;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebidFloors;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestBidAdjustmentFactors;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidBidderConfig;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCache;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidData;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidDataEidPermissions;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidMultiBid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidSchain;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.ImpMediaType;
import org.prebid.server.proto.openrtb.ext.request.TraceLevel;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponse;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponsePrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtModules;
import org.prebid.server.proto.openrtb.ext.response.ExtModulesTrace;
import org.prebid.server.proto.openrtb.ext.response.ExtModulesTraceAnalyticsActivity;
import org.prebid.server.proto.openrtb.ext.response.ExtModulesTraceAnalyticsAppliedTo;
import org.prebid.server.proto.openrtb.ext.response.ExtModulesTraceAnalyticsResult;
import org.prebid.server.proto.openrtb.ext.response.ExtModulesTraceAnalyticsTags;
import org.prebid.server.proto.openrtb.ext.response.ExtModulesTraceGroup;
import org.prebid.server.proto.openrtb.ext.response.ExtModulesTraceInvocationResult;
import org.prebid.server.proto.openrtb.ext.response.ExtModulesTraceStage;
import org.prebid.server.proto.openrtb.ext.response.ExtModulesTraceStageOutcome;
import org.prebid.server.settings.model.Account;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.LineItemUtil;
import org.prebid.server.util.ObjectUtil;
import org.prebid.server.util.StreamUtil;
import org.prebid.server.validation.ResponseBidValidator;
import org.prebid.server.validation.model.ValidationResult;

public class ExchangeService {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeService.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private static final String PREBID_EXT = "prebid";
    private static final String BIDDER_EXT = "bidder";
    private static final String TID_EXT = "tid";
    private static final String ORIGINAL_BID_CPM = "origbidcpm";
    private static final String ORIGINAL_BID_CURRENCY = "origbidcur";
    private static final String ALL_BIDDERS_CONFIG = "*";
    private static final Integer DEFAULT_MULTIBID_LIMIT_MIN = 1;
    private static final Integer DEFAULT_MULTIBID_LIMIT_MAX = 9;
    private static final String EID_ALLOWED_FOR_ALL_BIDDERS = "*";
    private static final BigDecimal THOUSAND = BigDecimal.valueOf(1000L);
    private final double logSamplingRate;
    private final int timeoutAdjustmentFactor;
    private final BidderCatalog bidderCatalog;
    private final StoredResponseProcessor storedResponseProcessor;
    private final DealsService dealsService;
    private final PrivacyEnforcementService privacyEnforcementService;
    private final FpdResolver fpdResolver;
    private final SupplyChainResolver supplyChainResolver;
    private final DebugResolver debugResolver;
    private final MediaTypeProcessor mediaTypeProcessor;
    private final UidUpdater uidUpdater;
    private final TimeoutResolver timeoutResolver;
    private final TimeoutFactory timeoutFactory;
    private final BidRequestOrtbVersionConversionManager ortbVersionConversionManager;
    private final HttpBidderRequester httpBidderRequester;
    private final ResponseBidValidator responseBidValidator;
    private final CurrencyConversionService currencyService;
    private final BidResponseCreator bidResponseCreator;
    private final ApplicationEventService applicationEventService;
    private final BidResponsePostProcessor bidResponsePostProcessor;
    private final HookStageExecutor hookStageExecutor;
    private final HttpInteractionLogger httpInteractionLogger;
    private final PriceFloorAdjuster priceFloorAdjuster;
    private final PriceFloorEnforcer priceFloorEnforcer;
    private final BidAdjustmentFactorResolver bidAdjustmentFactorResolver;
    private final Metrics metrics;
    private final Clock clock;
    private final JacksonMapper mapper;
    private final CriteriaLogManager criteriaLogManager;

    public ExchangeService(double logSamplingRate, int timeoutAdjustmentFactor, BidderCatalog bidderCatalog, StoredResponseProcessor storedResponseProcessor, DealsService dealsService, PrivacyEnforcementService privacyEnforcementService, FpdResolver fpdResolver, SupplyChainResolver supplyChainResolver, DebugResolver debugResolver, MediaTypeProcessor mediaTypeProcessor, UidUpdater uidUpdater, TimeoutResolver timeoutResolver, TimeoutFactory timeoutFactory, BidRequestOrtbVersionConversionManager ortbVersionConversionManager, HttpBidderRequester httpBidderRequester, ResponseBidValidator responseBidValidator, CurrencyConversionService currencyService, BidResponseCreator bidResponseCreator, BidResponsePostProcessor bidResponsePostProcessor, HookStageExecutor hookStageExecutor, ApplicationEventService applicationEventService, HttpInteractionLogger httpInteractionLogger, PriceFloorAdjuster priceFloorAdjuster, PriceFloorEnforcer priceFloorEnforcer, BidAdjustmentFactorResolver bidAdjustmentFactorResolver, Metrics metrics, Clock clock, JacksonMapper mapper, CriteriaLogManager criteriaLogManager) {
        if (timeoutAdjustmentFactor < 0 || timeoutAdjustmentFactor > 100) {
            throw new IllegalArgumentException("Expected timeout adjustment factor should be in [0, 100].");
        }
        this.logSamplingRate = logSamplingRate;
        this.timeoutAdjustmentFactor = timeoutAdjustmentFactor;
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.storedResponseProcessor = Objects.requireNonNull(storedResponseProcessor);
        this.dealsService = dealsService;
        this.privacyEnforcementService = Objects.requireNonNull(privacyEnforcementService);
        this.fpdResolver = Objects.requireNonNull(fpdResolver);
        this.supplyChainResolver = Objects.requireNonNull(supplyChainResolver);
        this.debugResolver = Objects.requireNonNull(debugResolver);
        this.mediaTypeProcessor = Objects.requireNonNull(mediaTypeProcessor);
        this.uidUpdater = Objects.requireNonNull(uidUpdater);
        this.timeoutResolver = Objects.requireNonNull(timeoutResolver);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.ortbVersionConversionManager = Objects.requireNonNull(ortbVersionConversionManager);
        this.httpBidderRequester = Objects.requireNonNull(httpBidderRequester);
        this.responseBidValidator = Objects.requireNonNull(responseBidValidator);
        this.currencyService = Objects.requireNonNull(currencyService);
        this.bidResponseCreator = Objects.requireNonNull(bidResponseCreator);
        this.bidResponsePostProcessor = Objects.requireNonNull(bidResponsePostProcessor);
        this.hookStageExecutor = Objects.requireNonNull(hookStageExecutor);
        this.applicationEventService = applicationEventService;
        this.httpInteractionLogger = Objects.requireNonNull(httpInteractionLogger);
        this.priceFloorAdjuster = Objects.requireNonNull(priceFloorAdjuster);
        this.priceFloorEnforcer = Objects.requireNonNull(priceFloorEnforcer);
        this.bidAdjustmentFactorResolver = Objects.requireNonNull(bidAdjustmentFactorResolver);
        this.metrics = Objects.requireNonNull(metrics);
        this.clock = Objects.requireNonNull(clock);
        this.mapper = Objects.requireNonNull(mapper);
        this.criteriaLogManager = Objects.requireNonNull(criteriaLogManager);
    }

    public Future<AuctionContext> holdAuction(AuctionContext context) {
        return this.processAuctionRequest(context).compose(this::invokeResponseHooks).map(this::enrichWithHooksDebugInfo).map(this::updateHooksMetrics);
    }

    private Future<AuctionContext> processAuctionRequest(AuctionContext context) {
        return context.isRequestRejected() ? Future.succeededFuture((Object)context.with(ExchangeService.emptyResponse())) : this.runAuction(context);
    }

    private static BidResponse emptyResponse() {
        return BidResponse.builder().seatbid(Collections.emptyList()).build();
    }

    private Future<AuctionContext> runAuction(AuctionContext receivedContext) {
        UidsCookie uidsCookie = receivedContext.getUidsCookie();
        BidRequest bidRequest = receivedContext.getBidRequest();
        Timeout timeout = receivedContext.getTimeout();
        Account account = receivedContext.getAccount();
        List<String> debugWarnings = receivedContext.getDebugWarnings();
        MetricName requestTypeMetric = receivedContext.getRequestTypeMetric();
        ArrayList storedAuctionResponses = new ArrayList();
        BidderAliases aliases = this.aliases(bidRequest);
        BidRequestCacheInfo cacheInfo = ExchangeService.bidRequestCacheInfo(bidRequest);
        Map<String, MultiBidConfig> bidderToMultiBid = ExchangeService.bidderToMultiBids(bidRequest, debugWarnings);
        receivedContext.getBidRejectionTrackers().putAll(this.makeBidRejectionTrackers(bidRequest, aliases));
        return this.storedResponseProcessor.getStoredResponseResult(bidRequest.getImp(), timeout).map(storedResponseResult -> ExchangeService.populateStoredResponse(storedResponseResult, storedAuctionResponses)).compose(storedResponseResult -> this.extractAuctionParticipations(receivedContext, (StoredResponseResult)storedResponseResult, aliases, bidderToMultiBid)).map(auctionParticipations -> this.matchAndPopulateDeals((List<AuctionParticipation>)auctionParticipations, aliases, receivedContext)).map(auctionParticipations -> ExchangeService.postProcessDeals(auctionParticipations, receivedContext)).map(auctionParticipations -> ExchangeService.fillContext(receivedContext, auctionParticipations)).map(context -> this.updateRequestMetric((AuctionContext)context, uidsCookie, aliases, account, requestTypeMetric)).compose(context -> CompositeFuture.join((List)context.getAuctionParticipations().stream().map(auctionParticipation -> this.processAndRequestBids((AuctionContext)context, auctionParticipation.getBidderRequest(), timeout, aliases).map(auctionParticipation::with)).collect(Collectors.toCollection(ArrayList::new))).map(CompositeFuture::list).map(this.storedResponseProcessor::updateStoredBidResponse).map(auctionParticipations -> this.storedResponseProcessor.mergeWithBidderResponses((List<AuctionParticipation>)auctionParticipations, storedAuctionResponses, bidRequest.getImp())).map(auctionParticipations -> this.dropZeroNonDealBids((List<AuctionParticipation>)auctionParticipations, debugWarnings)).map(auctionParticipations -> this.validateAndAdjustBids((List<AuctionParticipation>)auctionParticipations, (AuctionContext)context, aliases)).map(auctionParticipations -> this.updateResponsesMetrics((List<AuctionParticipation>)auctionParticipations, account, aliases)).map(context::with)).compose(context -> this.bidResponseCreator.create((AuctionContext)context, cacheInfo, bidderToMultiBid).map(bidResponse -> this.publishAuctionEvent((BidResponse)bidResponse, (AuctionContext)context)).map(bidResponse -> this.criteriaLogManager.traceResponse(logger, (BidResponse)bidResponse, context.getBidRequest(), context.getDebugContext().isDebugEnabled())).compose(bidResponse -> this.bidResponsePostProcessor.postProcess(context.getHttpRequest(), uidsCookie, bidRequest, (BidResponse)bidResponse, account)).map(context::with));
    }

    private BidderAliases aliases(BidRequest bidRequest) {
        ExtRequestPrebid prebid = ExchangeService.extRequestPrebid(bidRequest);
        Map<String, String> aliases = prebid != null ? prebid.getAliases() : null;
        Map<String, Integer> aliasgvlids = prebid != null ? prebid.getAliasgvlids() : null;
        return BidderAliases.of(aliases, aliasgvlids, this.bidderCatalog);
    }

    private static ExtRequestTargeting targeting(BidRequest bidRequest) {
        ExtRequestPrebid prebid = ExchangeService.extRequestPrebid(bidRequest);
        return prebid != null ? prebid.getTargeting() : null;
    }

    private static BidRequestCacheInfo bidRequestCacheInfo(BidRequest bidRequest) {
        ExtRequestPrebidCache cache;
        ExtRequestTargeting targeting = ExchangeService.targeting(bidRequest);
        ExtRequestPrebid prebid = ExchangeService.extRequestPrebid(bidRequest);
        ExtRequestPrebidCache extRequestPrebidCache = cache = prebid != null ? prebid.getCache() : null;
        if (targeting != null && cache != null) {
            boolean shouldCacheWinningBidsOnly;
            boolean shouldCacheBids = cache.getBids() != null;
            boolean shouldCacheVideoBids = cache.getVastxml() != null;
            boolean bl = shouldCacheWinningBidsOnly = targeting.getIncludebidderkeys() == false && (Boolean)ObjectUtils.defaultIfNull((Object)cache.getWinningonly(), (Object)false) != false;
            if (shouldCacheBids || shouldCacheVideoBids || shouldCacheWinningBidsOnly) {
                Integer cacheBidsTtl = shouldCacheBids ? cache.getBids().getTtlseconds() : null;
                Integer cacheVideoBidsTtl = shouldCacheVideoBids ? cache.getVastxml().getTtlseconds() : null;
                boolean returnCreativeBid = shouldCacheBids ? (Boolean)ObjectUtils.defaultIfNull((Object)cache.getBids().getReturnCreative(), (Object)true) : false;
                boolean returnCreativeVideoBid = shouldCacheVideoBids ? (Boolean)ObjectUtils.defaultIfNull((Object)cache.getVastxml().getReturnCreative(), (Object)true) : false;
                return BidRequestCacheInfo.builder().doCaching(true).shouldCacheBids(shouldCacheBids).cacheBidsTtl(cacheBidsTtl).shouldCacheVideoBids(shouldCacheVideoBids).cacheVideoBidsTtl(cacheVideoBidsTtl).returnCreativeBids(returnCreativeBid).returnCreativeVideoBids(returnCreativeVideoBid).shouldCacheWinningBidsOnly(shouldCacheWinningBidsOnly).build();
            }
        }
        return BidRequestCacheInfo.noCache();
    }

    private static ExtRequestPrebid extRequestPrebid(BidRequest bidRequest) {
        ExtRequest requestExt = bidRequest.getExt();
        return requestExt != null ? requestExt.getPrebid() : null;
    }

    private static Map<String, MultiBidConfig> bidderToMultiBids(BidRequest bidRequest, List<String> debugWarnings) {
        ExtRequestPrebid extRequestPrebid = ExchangeService.extRequestPrebid(bidRequest);
        List<ExtRequestPrebidMultiBid> multiBids = extRequestPrebid != null ? CollectionUtils.emptyIfNull(extRequestPrebid.getMultibid()) : Collections.emptyList();
        CaseInsensitiveMap bidderToMultiBid = new CaseInsensitiveMap();
        for (ExtRequestPrebidMultiBid prebidMultiBid : multiBids) {
            String bidder = prebidMultiBid.getBidder();
            List<String> bidders = prebidMultiBid.getBidders();
            Integer maxBids = prebidMultiBid.getMaxBids();
            String codePrefix = prebidMultiBid.getTargetBidderCodePrefix();
            if (bidder != null && CollectionUtils.isNotEmpty(bidders)) {
                debugWarnings.add("Invalid MultiBid: bidder %s and bidders %s specified. Only bidder %s will be used.".formatted(bidder, bidders, bidder));
                ExchangeService.tryAddBidderWithMultiBid(bidder, maxBids, codePrefix, (Map<String, MultiBidConfig>)bidderToMultiBid, debugWarnings);
                continue;
            }
            if (bidder != null) {
                ExchangeService.tryAddBidderWithMultiBid(bidder, maxBids, codePrefix, (Map<String, MultiBidConfig>)bidderToMultiBid, debugWarnings);
                continue;
            }
            if (CollectionUtils.isNotEmpty(bidders)) {
                if (codePrefix != null) {
                    debugWarnings.add("Invalid MultiBid: CodePrefix %s that was specified for bidders %s will be skipped.".formatted(codePrefix, bidders));
                }
                bidders.forEach(arg_0 -> ExchangeService.lambda$bidderToMultiBids$16(maxBids, (Map)bidderToMultiBid, debugWarnings, arg_0));
                continue;
            }
            debugWarnings.add("Invalid MultiBid: Bidder and bidders was not specified.");
        }
        return bidderToMultiBid;
    }

    private static void tryAddBidderWithMultiBid(String bidder, Integer maxBids, String codePrefix, Map<String, MultiBidConfig> bidderToMultiBid, List<String> debugWarnings) {
        if (bidderToMultiBid.containsKey(bidder)) {
            debugWarnings.add("Invalid MultiBid: Bidder %s specified multiple times.".formatted(bidder));
            return;
        }
        if (maxBids == null) {
            debugWarnings.add("Invalid MultiBid: MaxBids for bidder %s is not specified and will be skipped.".formatted(bidder));
            return;
        }
        bidderToMultiBid.put(bidder, ExchangeService.toMultiBid(bidder, maxBids, codePrefix));
    }

    private static MultiBidConfig toMultiBid(String bidder, Integer maxBids, String codePrefix) {
        int bidLimit = maxBids < DEFAULT_MULTIBID_LIMIT_MIN ? DEFAULT_MULTIBID_LIMIT_MIN : (maxBids > DEFAULT_MULTIBID_LIMIT_MAX ? DEFAULT_MULTIBID_LIMIT_MAX : maxBids);
        return MultiBidConfig.of(bidder, bidLimit, codePrefix);
    }

    private Map<String, BidRejectionTracker> makeBidRejectionTrackers(BidRequest bidRequest, BidderAliases aliases) {
        Map<String, Set> impIdToBidders = bidRequest.getImp().stream().filter(Objects::nonNull).filter(imp -> StringUtils.isNotEmpty((CharSequence)imp.getId())).collect(Collectors.toMap(Imp::getId, imp -> this.bidderNamesFromImpExt((Imp)imp, aliases)));
        HashMap bidderToImpIds = new HashMap();
        for (Map.Entry<String, Set> entry2 : impIdToBidders.entrySet()) {
            String impId = entry2.getKey();
            Set bidderNames = entry2.getValue();
            bidderNames.forEach(bidder -> bidderToImpIds.computeIfAbsent(bidder, bidderName -> new HashSet()).add(impId));
        }
        return bidderToImpIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new BidRejectionTracker((String)entry.getKey(), (Set)entry.getValue(), this.logSamplingRate)));
    }

    private static StoredResponseResult populateStoredResponse(StoredResponseResult storedResponseResult, List<SeatBid> storedResponse) {
        storedResponse.addAll(storedResponseResult.getAuctionStoredResponse());
        return storedResponseResult;
    }

    private Future<List<AuctionParticipation>> extractAuctionParticipations(AuctionContext context, StoredResponseResult storedResponseResult, BidderAliases aliases, Map<String, MultiBidConfig> bidderToMultiBid) {
        List<Imp> imps = storedResponseResult.getRequiredRequestImps().stream().filter(imp -> ExchangeService.bidderParamsFromImpExt(imp.getExt()) != null).toList();
        List<String> bidders = imps.stream().map(imp -> this.bidderNamesFromImpExt((Imp)imp, aliases)).flatMap(Collection::stream).filter(bidder -> ExchangeService.isBidderCallActivityAllowed(bidder, context)).distinct().toList();
        Map<String, Map<String, String>> impBidderToStoredBidResponse = storedResponseResult.getImpBidderToStoredBidResponse();
        return this.makeAuctionParticipation(bidders, context, aliases, impBidderToStoredBidResponse, imps, bidderToMultiBid);
    }

    private Set<String> bidderNamesFromImpExt(Imp imp, BidderAliases aliases) {
        return Optional.ofNullable(ExchangeService.bidderParamsFromImpExt(imp.getExt())).stream().flatMap(paramsNode -> StreamUtil.asStream(paramsNode.fieldNames())).filter(bidder -> this.isValidBidder((String)bidder, aliases)).collect(Collectors.toSet());
    }

    private static JsonNode bidderParamsFromImpExt(ObjectNode ext) {
        return ext.get(PREBID_EXT).get(BIDDER_EXT);
    }

    private boolean isValidBidder(String bidder, BidderAliases aliases) {
        return this.bidderCatalog.isValidName(bidder) || aliases.isAliasDefined(bidder);
    }

    private static boolean isBidderCallActivityAllowed(String bidder, AuctionContext auctionContext) {
        ActivityInfrastructure activityInfrastructure = auctionContext.getActivityInfrastructure();
        BidRequestActivityInvocationPayload activityInvocationPayload = BidRequestActivityInvocationPayload.of(ActivityInvocationPayloadImpl.of(ComponentType.BIDDER, bidder), auctionContext.getBidRequest());
        return activityInfrastructure.isAllowed(Activity.CALL_BIDDER, activityInvocationPayload);
    }

    private Future<List<AuctionParticipation>> makeAuctionParticipation(List<String> bidders, AuctionContext context, BidderAliases aliases, Map<String, Map<String, String>> impBidderToStoredResponse, List<Imp> imps, Map<String, MultiBidConfig> bidderToMultiBid) {
        BidRequest bidRequest = context.getBidRequest();
        ExtRequest requestExt = bidRequest.getExt();
        ExtRequestPrebid prebid = requestExt == null ? null : requestExt.getPrebid();
        Map<String, ExtBidderConfigOrtb> biddersToConfigs = this.getBiddersToConfigs(prebid);
        Map<String, List<String>> eidPermissions = this.getEidPermissions(prebid);
        Map<String, User> bidderToUser = this.prepareUsers(bidders, context, aliases, biddersToConfigs, eidPermissions);
        return this.privacyEnforcementService.mask(context, bidderToUser, bidders, aliases).map(bidderToPrivacyResult -> this.getAuctionParticipation((List<BidderPrivacyResult>)bidderToPrivacyResult, bidRequest, impBidderToStoredResponse, imps, bidderToMultiBid, biddersToConfigs, aliases, context));
    }

    private Map<String, ExtBidderConfigOrtb> getBiddersToConfigs(ExtRequestPrebid prebid) {
        List<ExtRequestPrebidBidderConfig> bidderConfigs;
        List<ExtRequestPrebidBidderConfig> list = bidderConfigs = prebid == null ? null : prebid.getBidderconfig();
        if (CollectionUtils.isEmpty(bidderConfigs)) {
            return Collections.emptyMap();
        }
        CaseInsensitiveMap bidderToConfig = new CaseInsensitiveMap();
        bidderConfigs.stream().filter(prebidBidderConfig -> prebidBidderConfig.getBidders().contains("*")).map(prebidBidderConfig -> prebidBidderConfig.getConfig().getOrtb2()).findFirst().ifPresent(arg_0 -> ExchangeService.lambda$getBiddersToConfigs$30((Map)bidderToConfig, arg_0));
        for (ExtRequestPrebidBidderConfig config : bidderConfigs) {
            for (String bidder : config.getBidders()) {
                ExtBidderConfigOrtb concreteFpd = config.getConfig().getOrtb2();
                bidderToConfig.putIfAbsent(bidder, concreteFpd);
            }
        }
        return bidderToConfig;
    }

    private Map<String, List<String>> getEidPermissions(ExtRequestPrebid prebid) {
        ExtRequestPrebidData prebidData = prebid != null ? prebid.getData() : null;
        List<ExtRequestPrebidDataEidPermissions> eidPermissions = prebidData != null ? prebidData.getEidPermissions() : null;
        return CollectionUtils.emptyIfNull(eidPermissions).stream().collect(Collectors.toMap(ExtRequestPrebidDataEidPermissions::getSource, ExtRequestPrebidDataEidPermissions::getBidders));
    }

    private static List<String> firstPartyDataBidders(ExtRequest requestExt) {
        ExtRequestPrebid prebid = requestExt == null ? null : requestExt.getPrebid();
        ExtRequestPrebidData data = prebid == null ? null : prebid.getData();
        return data == null ? null : data.getBidders();
    }

    private Map<String, User> prepareUsers(List<String> bidders, AuctionContext context, BidderAliases aliases, Map<String, ExtBidderConfigOrtb> biddersToConfigs, Map<String, List<String>> eidPermissions) {
        BidRequest bidRequest = context.getBidRequest();
        List<String> firstPartyDataBidders = ExchangeService.firstPartyDataBidders(bidRequest.getExt());
        HashMap<String, User> bidderToUser = new HashMap<String, User>();
        for (String bidder : bidders) {
            ExtBidderConfigOrtb fpdConfig = (ExtBidderConfigOrtb)ObjectUtils.defaultIfNull((Object)biddersToConfigs.get(bidder), (Object)biddersToConfigs.get("*"));
            boolean useFirstPartyData = firstPartyDataBidders == null || firstPartyDataBidders.stream().anyMatch(fpdBidder -> StringUtils.equalsIgnoreCase((CharSequence)fpdBidder, (CharSequence)bidder));
            User preparedUser = this.prepareUser(bidder, context, aliases, useFirstPartyData, fpdConfig, eidPermissions);
            bidderToUser.put(bidder, preparedUser);
        }
        return bidderToUser;
    }

    private User prepareUser(String bidder, AuctionContext context, BidderAliases aliases, boolean useFirstPartyData, ExtBidderConfigOrtb fpdConfig, Map<String, List<String>> eidPermissions) {
        User user = context.getBidRequest().getUser();
        ExtUser extUser = user != null ? user.getExt() : null;
        UpdateResult<String> buyerUidUpdateResult = this.uidUpdater.updateUid(bidder, context, aliases);
        List<Eid> userEids = this.extractUserEids(user);
        List<Eid> allowedUserEids = this.resolveAllowedEids(userEids, bidder, eidPermissions);
        boolean shouldUpdateUserEids = allowedUserEids.size() != CollectionUtils.emptyIfNull(userEids).size();
        boolean shouldCleanExtPrebid = extUser != null && extUser.getPrebid() != null;
        boolean shouldCleanExtData = extUser != null && extUser.getData() != null && !useFirstPartyData;
        boolean shouldUpdateUserExt = shouldCleanExtData || shouldCleanExtPrebid;
        boolean shouldCleanData = user != null && user.getData() != null && !useFirstPartyData;
        User maskedUser = user;
        if (buyerUidUpdateResult.isUpdated() || shouldUpdateUserEids || shouldUpdateUserExt || shouldCleanData) {
            User.UserBuilder userBuilder = user == null ? User.builder() : user.toBuilder();
            userBuilder.buyeruid(buyerUidUpdateResult.getValue());
            if (shouldUpdateUserEids) {
                userBuilder.eids(this.nullIfEmpty(allowedUserEids));
            }
            if (shouldUpdateUserExt) {
                ExtUser updatedExtUser = extUser.toBuilder().prebid(null).data(shouldCleanExtData ? null : extUser.getData()).build();
                userBuilder.ext(updatedExtUser.isEmpty() ? null : updatedExtUser);
            }
            if (shouldCleanData) {
                userBuilder.data(null);
            }
            maskedUser = userBuilder.build();
        }
        return useFirstPartyData ? this.fpdResolver.resolveUser(maskedUser, fpdConfig == null ? null : fpdConfig.getUser()) : maskedUser;
    }

    private List<Eid> extractUserEids(User user) {
        return user != null ? user.getEids() : null;
    }

    private List<Eid> resolveAllowedEids(List<Eid> userEids, String bidder, Map<String, List<String>> eidPermissions) {
        return CollectionUtils.emptyIfNull(userEids).stream().filter(userEid -> this.isUserEidAllowed(userEid.getSource(), eidPermissions, bidder)).toList();
    }

    private boolean isUserEidAllowed(String source, Map<String, List<String>> eidPermissions, String bidder) {
        List<String> allowedBidders = eidPermissions.get(source);
        return CollectionUtils.isEmpty(allowedBidders) || allowedBidders.stream().anyMatch(allowedBidder -> StringUtils.equalsIgnoreCase((CharSequence)allowedBidder, (CharSequence)bidder) || "*".equals(allowedBidder));
    }

    private List<AuctionParticipation> getAuctionParticipation(List<BidderPrivacyResult> bidderPrivacyResults, BidRequest bidRequest, Map<String, Map<String, String>> impBidderToStoredBidResponse, List<Imp> imps, Map<String, MultiBidConfig> bidderToMultiBid, Map<String, ExtBidderConfigOrtb> biddersToConfigs, BidderAliases aliases, AuctionContext context) {
        Map<String, JsonNode> bidderToPrebidBidders = ExchangeService.bidderToPrebidBidders(bidRequest);
        List bidderRequests = bidderPrivacyResults.stream().map(bidderPrivacyResult -> this.createAuctionParticipation((BidderPrivacyResult)bidderPrivacyResult, impBidderToStoredBidResponse, imps, bidderToMultiBid, biddersToConfigs, bidderToPrebidBidders, aliases, context)).filter(auctionParticipation -> !auctionParticipation.isRequestBlocked()).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(bidderRequests);
        return bidderRequests;
    }

    private static Map<String, JsonNode> bidderToPrebidBidders(BidRequest bidRequest) {
        ObjectNode bidders;
        ExtRequestPrebid prebid = ExchangeService.extRequestPrebid(bidRequest);
        ObjectNode objectNode = bidders = prebid == null ? null : prebid.getBidders();
        if (bidders == null || bidders.isNull()) {
            return Collections.emptyMap();
        }
        HashMap<String, JsonNode> bidderToPrebidParameters = new HashMap<String, JsonNode>();
        Iterator biddersToParams = bidders.fields();
        while (biddersToParams.hasNext()) {
            Map.Entry bidderToParam = (Map.Entry)biddersToParams.next();
            bidderToPrebidParameters.put((String)bidderToParam.getKey(), (JsonNode)bidderToParam.getValue());
        }
        return bidderToPrebidParameters;
    }

    private AuctionParticipation createAuctionParticipation(BidderPrivacyResult bidderPrivacyResult, Map<String, Map<String, String>> impBidderToStoredBidResponse, List<Imp> imps, Map<String, MultiBidConfig> bidderToMultiBid, Map<String, ExtBidderConfigOrtb> biddersToConfigs, Map<String, JsonNode> bidderToPrebidBidders, BidderAliases bidderAliases, AuctionContext context) {
        boolean blockedRequestByTcf = bidderPrivacyResult.isBlockedRequestByTcf();
        boolean blockedAnalyticsByTcf = bidderPrivacyResult.isBlockedAnalyticsByTcf();
        String bidder = bidderPrivacyResult.getRequestBidder();
        if (blockedRequestByTcf) {
            context.getBidRejectionTrackers().get(bidder).rejectAll(BidRejectionReason.REJECTED_BY_PRIVACY);
            return AuctionParticipation.builder().bidder(bidder).requestBlocked(true).analyticsBlocked(blockedAnalyticsByTcf).build();
        }
        OrtbVersion ortbVersion = this.bidderSupportedOrtbVersion(bidder, bidderAliases);
        String storedBidResponse = impBidderToStoredBidResponse.size() == 1 ? impBidderToStoredBidResponse.get(imps.get(0).getId()).get(bidder) : null;
        BidRequest preparedBidRequest = this.prepareBidRequest(bidderPrivacyResult, imps, bidderToMultiBid, biddersToConfigs, bidderToPrebidBidders, context);
        BidderRequest bidderRequest = BidderRequest.builder().bidder(bidder).ortbVersion(ortbVersion).storedResponse(storedBidResponse).bidRequest(preparedBidRequest).build();
        return AuctionParticipation.builder().bidder(bidder).bidderRequest(bidderRequest).requestBlocked(false).analyticsBlocked(blockedAnalyticsByTcf).build();
    }

    private OrtbVersion bidderSupportedOrtbVersion(String bidder, BidderAliases aliases) {
        return this.bidderCatalog.bidderInfoByName(aliases.resolveBidder(bidder)).getOrtbVersion();
    }

    private BidRequest prepareBidRequest(BidderPrivacyResult bidderPrivacyResult, List<Imp> imps, Map<String, MultiBidConfig> bidderToMultiBid, Map<String, ExtBidderConfigOrtb> biddersToConfigs, Map<String, JsonNode> bidderToPrebidBidders, AuctionContext context) {
        BidRequest bidRequest = context.getBidRequest();
        String bidder = bidderPrivacyResult.getRequestBidder();
        boolean transmitTid = ExchangeService.transmitTransactionId(bidder, context);
        List<String> firstPartyDataBidders = ExchangeService.firstPartyDataBidders(bidRequest.getExt());
        boolean useFirstPartyData = firstPartyDataBidders == null || firstPartyDataBidders.stream().anyMatch(fpdBidder -> StringUtils.equalsIgnoreCase((CharSequence)fpdBidder, (CharSequence)bidder));
        ExtBidderConfigOrtb fpdConfig = (ExtBidderConfigOrtb)ObjectUtils.defaultIfNull((Object)biddersToConfigs.get(bidder), (Object)biddersToConfigs.get("*"));
        App app = bidRequest.getApp();
        Site site = bidRequest.getSite();
        Dooh dooh = bidRequest.getDooh();
        ObjectNode fpdSite = fpdConfig != null ? fpdConfig.getSite() : null;
        ObjectNode fpdApp = fpdConfig != null ? fpdConfig.getApp() : null;
        ObjectNode fpdDooh = fpdConfig != null ? fpdConfig.getDooh() : null;
        App preparedApp = this.prepareApp(app, fpdApp, useFirstPartyData);
        Site preparedSite = this.prepareSite(site, fpdSite, useFirstPartyData);
        Dooh preparedDooh = this.prepareDooh(dooh, fpdDooh, useFirstPartyData);
        ArrayList distributionChannels = new ArrayList();
        Optional.ofNullable(preparedApp).ifPresent(ignored -> distributionChannels.add("app"));
        Optional.ofNullable(preparedDooh).ifPresent(ignored -> distributionChannels.add("dooh"));
        Optional.ofNullable(preparedSite).ifPresent(ignored -> distributionChannels.add("site"));
        if (distributionChannels.size() > 1) {
            context.getDebugWarnings().add("BidRequest contains " + String.join((CharSequence)" and ", distributionChannels) + ". Only the first one is applicable, the others are ignored");
            this.metrics.updateAlertsMetrics(MetricName.general);
            String logMessage = String.join((CharSequence)" and ", distributionChannels) + " are present. Referer: " + context.getHttpRequest().getHeaders().get(HttpUtil.REFERER_HEADER) + ". Account: " + context.getAccount().getId();
            conditionalLogger.warn(logMessage, this.logSamplingRate);
        }
        boolean isApp = preparedApp != null;
        boolean isDooh = !isApp && preparedDooh != null;
        boolean isSite = !isApp && !isDooh && preparedSite != null;
        return bidRequest.toBuilder().user(bidderPrivacyResult.getUser()).device(bidderPrivacyResult.getDevice()).imp(this.prepareImps(bidder, imps, bidRequest, transmitTid, useFirstPartyData, context.getAccount())).app(isApp ? preparedApp : null).dooh(isDooh ? preparedDooh : null).site(isSite ? preparedSite : null).source(this.prepareSource(bidder, bidRequest, transmitTid)).ext(this.prepareExt(bidder, bidderToPrebidBidders, bidderToMultiBid, bidRequest.getExt())).build();
    }

    private static boolean transmitTransactionId(String bidder, AuctionContext context) {
        BidRequest bidRequest = context.getBidRequest();
        Boolean createTids = Optional.ofNullable(bidRequest.getExt()).map(ExtRequest::getPrebid).map(ExtRequestPrebid::getCreateTids).orElse(null);
        if (createTids == null) {
            BidRequestActivityInvocationPayload payload = BidRequestActivityInvocationPayload.of(ActivityInvocationPayloadImpl.of(ComponentType.BIDDER, bidder), bidRequest);
            return context.getActivityInfrastructure().isAllowed(Activity.TRANSMIT_TID, payload);
        }
        return createTids;
    }

    private List<Imp> prepareImps(String bidder, List<Imp> imps, BidRequest bidRequest, boolean transmitTid, boolean useFirstPartyData, Account account) {
        return imps.stream().filter(imp -> ExchangeService.bidderParamsFromImpExt(imp.getExt()).hasNonNull(bidder)).map(imp -> this.prepareImp((Imp)imp, bidder, bidRequest, transmitTid, useFirstPartyData, account)).toList();
    }

    private Imp prepareImp(Imp imp, String bidder, BidRequest bidRequest, boolean transmitTid, boolean useFirstPartyData, Account account) {
        BigDecimal adjustedFloor = this.resolveBidFloor(imp, bidder, bidRequest, account);
        return imp.toBuilder().bidfloor(adjustedFloor).ext(this.prepareImpExt(bidder, imp.getExt(), adjustedFloor, transmitTid, useFirstPartyData)).build();
    }

    private BigDecimal resolveBidFloor(Imp imp, String bidder, BidRequest bidRequest, Account account) {
        return this.priceFloorAdjuster.adjustForImp(imp, bidder, bidRequest, account);
    }

    private ObjectNode prepareImpExt(String bidder, ObjectNode impExt, BigDecimal adjustedFloor, boolean transmitTid, boolean useFirstPartyData) {
        ObjectNode modifiedImpExt = impExt.deepCopy();
        JsonNode impExtPrebid = this.prepareImpExt(impExt.get(PREBID_EXT), adjustedFloor);
        Optional.ofNullable(impExtPrebid).ifPresentOrElse(ext -> modifiedImpExt.set(PREBID_EXT, ext), () -> modifiedImpExt.remove(PREBID_EXT));
        modifiedImpExt.set(BIDDER_EXT, ExchangeService.bidderParamsFromImpExt(impExt).get(bidder));
        if (!transmitTid) {
            modifiedImpExt.remove(TID_EXT);
        }
        return this.fpdResolver.resolveImpExt(modifiedImpExt, useFirstPartyData);
    }

    private JsonNode prepareImpExt(JsonNode extImpPrebidNode, BigDecimal adjustedFloor) {
        if (extImpPrebidNode.size() <= 1) {
            return null;
        }
        ExtImpPrebid extImpPrebid = this.extImpPrebid(extImpPrebidNode);
        ExtImpPrebidFloors floors = extImpPrebid.getFloors();
        ExtImpPrebidFloors updatedFloors = floors != null ? ExtImpPrebidFloors.of(floors.getFloorRule(), floors.getFloorRuleValue(), adjustedFloor, floors.getFloorMin(), floors.getFloorMinCur()) : null;
        return this.mapper.mapper().valueToTree((Object)this.extImpPrebid(extImpPrebidNode).toBuilder().floors(updatedFloors).bidder(null).build());
    }

    private ExtImpPrebid extImpPrebid(JsonNode extImpPrebid) {
        try {
            return (ExtImpPrebid)this.mapper.mapper().treeToValue((TreeNode)extImpPrebid, ExtImpPrebid.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Error decoding imp.ext.prebid: " + e.getMessage(), e);
        }
    }

    private App prepareApp(App app, ObjectNode fpdApp, boolean useFirstPartyData) {
        boolean shouldCleanContentData;
        ExtApp appExt = app != null ? app.getExt() : null;
        Content content = app != null ? app.getContent() : null;
        boolean shouldCleanExtData = appExt != null && appExt.getData() != null && !useFirstPartyData;
        boolean bl = shouldCleanContentData = content != null && content.getData() != null && !useFirstPartyData;
        App maskedApp = shouldCleanExtData || shouldCleanContentData ? app.toBuilder().ext(shouldCleanExtData ? ExchangeService.maskExtApp(appExt) : appExt).content(shouldCleanContentData ? ExchangeService.prepareContent(content) : content).build() : app;
        return useFirstPartyData ? this.fpdResolver.resolveApp(maskedApp, fpdApp) : maskedApp;
    }

    private static ExtApp maskExtApp(ExtApp appExt) {
        ExtApp maskedExtApp = ExtApp.of(appExt.getPrebid(), null);
        return maskedExtApp.isEmpty() ? null : maskedExtApp;
    }

    private Site prepareSite(Site site, ObjectNode fpdSite, boolean useFirstPartyData) {
        boolean shouldCleanContentData;
        ExtSite siteExt = site != null ? site.getExt() : null;
        Content content = site != null ? site.getContent() : null;
        boolean shouldCleanExtData = siteExt != null && siteExt.getData() != null && !useFirstPartyData;
        boolean bl = shouldCleanContentData = content != null && content.getData() != null && !useFirstPartyData;
        Site maskedSite = shouldCleanExtData || shouldCleanContentData ? site.toBuilder().ext(shouldCleanExtData ? ExchangeService.maskExtSite(siteExt) : siteExt).content(shouldCleanContentData ? ExchangeService.prepareContent(content) : content).build() : site;
        return useFirstPartyData ? this.fpdResolver.resolveSite(maskedSite, fpdSite) : maskedSite;
    }

    private static ExtSite maskExtSite(ExtSite siteExt) {
        ExtSite maskedExtSite = ExtSite.of(siteExt.getAmp(), null);
        return maskedExtSite.isEmpty() ? null : maskedExtSite;
    }

    private Dooh prepareDooh(Dooh dooh, ObjectNode fpdDooh, boolean useFirstPartyData) {
        boolean shouldCleanContentData;
        ExtDooh doohExt = dooh != null ? dooh.getExt() : null;
        Content content = dooh != null ? dooh.getContent() : null;
        boolean shouldCleanExtData = doohExt != null && doohExt.getData() != null && !useFirstPartyData;
        boolean bl = shouldCleanContentData = content != null && content.getData() != null && !useFirstPartyData;
        Dooh maskedDooh = shouldCleanExtData || shouldCleanContentData ? dooh.toBuilder().ext(shouldCleanExtData ? null : doohExt).content(shouldCleanContentData ? ExchangeService.prepareContent(content) : content).build() : dooh;
        return useFirstPartyData ? this.fpdResolver.resolveDooh(maskedDooh, fpdDooh) : maskedDooh;
    }

    private static Content prepareContent(Content content) {
        Content updatedContent = content.toBuilder().data(null).build();
        return updatedContent.isEmpty() ? null : updatedContent;
    }

    private Source prepareSource(String bidder, BidRequest bidRequest, boolean transmitTid) {
        Source receivedSource = bidRequest.getSource();
        SupplyChain bidderSchain = this.supplyChainResolver.resolveForBidder(bidder, bidRequest);
        if (bidderSchain == null && transmitTid) {
            return receivedSource;
        }
        return receivedSource == null ? Source.builder().schain(bidderSchain).build() : receivedSource.toBuilder().schain(bidderSchain).tid(transmitTid ? receivedSource.getTid() : null).build();
    }

    private ExtRequest prepareExt(String bidder, Map<String, JsonNode> bidderToPrebidBidders, Map<String, MultiBidConfig> bidderToMultiBid, ExtRequest requestExt) {
        boolean suppressAliases;
        ExtRequestPrebid extPrebid = requestExt != null ? requestExt.getPrebid() : null;
        List<ExtRequestPrebidSchain> extPrebidSchains = extPrebid != null ? extPrebid.getSchains() : null;
        ExtRequestPrebidData extPrebidData = extPrebid != null ? extPrebid.getData() : null;
        List<ExtRequestPrebidBidderConfig> extPrebidBidderconfig = extPrebid != null ? extPrebid.getBidderconfig() : null;
        boolean suppressSchains = extPrebidSchains != null;
        boolean suppressBidderConfig = extPrebidBidderconfig != null;
        boolean suppressPrebidData = extPrebidData != null;
        boolean suppressBidderParameters = extPrebid != null && extPrebid.getBidderparams() != null;
        boolean bl = suppressAliases = extPrebid != null && extPrebid.getAliases() != null;
        if (!(!bidderToPrebidBidders.isEmpty() || !bidderToMultiBid.isEmpty() || suppressSchains || suppressBidderConfig || suppressPrebidData || suppressBidderParameters || suppressAliases)) {
            return requestExt;
        }
        JsonNode prebidParameters = bidderToPrebidBidders.get(bidder);
        ObjectNode bidders = prebidParameters != null ? (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtPrebidBidders.of(prebidParameters)) : null;
        ExtRequestPrebid.ExtRequestPrebidBuilder extPrebidBuilder = Optional.ofNullable(extPrebid).map(ExtRequestPrebid::toBuilder).orElse(ExtRequestPrebid.builder());
        return ExtRequest.of(extPrebidBuilder.multibid(this.resolveExtRequestMultiBids(bidderToMultiBid.get(bidder), bidder)).bidders(bidders).bidderparams(this.prepareBidderParameters(extPrebid, bidder)).schains(null).data(null).bidderconfig(null).aliases(null).build());
    }

    private List<ExtRequestPrebidMultiBid> resolveExtRequestMultiBids(MultiBidConfig multiBidConfig, String bidder) {
        return multiBidConfig != null ? Collections.singletonList(ExtRequestPrebidMultiBid.of(bidder, null, multiBidConfig.getMaxBids(), multiBidConfig.getTargetBidderCodePrefix())) : null;
    }

    private ObjectNode prepareBidderParameters(ExtRequestPrebid prebid, String bidder) {
        ObjectNode bidderParams = prebid != null ? prebid.getBidderparams() : null;
        JsonNode params = bidderParams != null ? bidderParams.get(bidder) : null;
        return params != null ? (ObjectNode)this.mapper.mapper().createObjectNode().set(bidder, params) : null;
    }

    private List<AuctionParticipation> matchAndPopulateDeals(List<AuctionParticipation> auctionParticipants, BidderAliases aliases, AuctionContext context) {
        if (this.dealsService == null) {
            return auctionParticipants;
        }
        List<BidderRequest> updatedBidderRequests = auctionParticipants.stream().map(auctionParticipation -> !auctionParticipation.isRequestBlocked() ? this.dealsService.matchAndPopulateDeals(auctionParticipation.getBidderRequest(), aliases, context) : null).toList();
        return IntStream.range(0, auctionParticipants.size()).mapToObj(i -> ((AuctionParticipation)auctionParticipants.get(i)).toBuilder().bidderRequest((BidderRequest)updatedBidderRequests.get(i)).build()).toList();
    }

    private static List<AuctionParticipation> postProcessDeals(List<AuctionParticipation> auctionParticipations, AuctionContext context) {
        return DealsService.removePgDealsOnlyImpsWithoutDeals(auctionParticipations, context);
    }

    private AuctionContext updateRequestMetric(AuctionContext context, UidsCookie uidsCookie, BidderAliases aliases, Account account, MetricName requestTypeMetric) {
        List<AuctionParticipation> auctionParticipations = context.getAuctionParticipations();
        this.metrics.updateRequestBidderCardinalityMetric(auctionParticipations.size());
        this.metrics.updateAccountRequestMetrics(account, requestTypeMetric);
        for (AuctionParticipation auctionParticipation : auctionParticipations) {
            if (auctionParticipation.isRequestBlocked()) continue;
            BidderRequest bidderRequest = auctionParticipation.getBidderRequest();
            String bidder = aliases.resolveBidder(bidderRequest.getBidder());
            boolean isApp = bidderRequest.getBidRequest().getApp() != null;
            boolean noBuyerId = this.bidderCatalog.usersyncerByName(bidder).map(Usersyncer::getCookieFamilyName).map(cookieFamily -> StringUtils.isBlank((CharSequence)uidsCookie.uidFrom((String)cookieFamily))).orElse(false);
            this.metrics.updateAdapterRequestTypeAndNoCookieMetrics(bidder, requestTypeMetric, !isApp && noBuyerId);
        }
        return context;
    }

    private static AuctionContext fillContext(AuctionContext context, List<AuctionParticipation> auctionParticipations) {
        HashMap<String, List<Deal>> impIdToDeals = new HashMap<String, List<Deal>>();
        auctionParticipations.stream().map(AuctionParticipation::getBidderRequest).map(BidderRequest::getImpIdToDeals).filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).forEach(entry -> impIdToDeals.computeIfAbsent((String)entry.getKey(), key -> new ArrayList()).addAll((Collection)entry.getValue()));
        return context.toBuilder().bidRequest(DealsService.populateDeals(context.getBidRequest(), impIdToDeals)).auctionParticipations(auctionParticipations).build();
    }

    private Future<BidderResponse> processAndRequestBids(AuctionContext auctionContext, BidderRequest bidderRequest, Timeout timeout, BidderAliases aliases) {
        String bidderName = bidderRequest.getBidder();
        MediaTypeProcessingResult mediaTypeProcessingResult = this.mediaTypeProcessor.process(bidderRequest.getBidRequest(), aliases.resolveBidder(bidderName));
        List<BidderError> mediaTypeProcessingErrors = mediaTypeProcessingResult.getErrors();
        if (mediaTypeProcessingResult.isRejected()) {
            auctionContext.getBidRejectionTrackers().get(bidderName).rejectAll(BidRejectionReason.REJECTED_BY_MEDIA_TYPE);
            BidderSeatBid bidderSeatBid = BidderSeatBid.builder().warnings(mediaTypeProcessingErrors).build();
            return Future.succeededFuture((Object)BidderResponse.of(bidderName, bidderSeatBid, 0));
        }
        return Future.succeededFuture((Object)mediaTypeProcessingResult.getBidRequest()).map(bidderRequest::with).compose(modifiedBidderRequest -> this.invokeHooksAndRequestBids(auctionContext, (BidderRequest)modifiedBidderRequest, timeout, aliases)).map(bidderResponse -> bidderResponse.with(ExchangeService.addWarnings(bidderResponse.getSeatBid(), mediaTypeProcessingErrors)));
    }

    private static BidderSeatBid addWarnings(BidderSeatBid seatBid, List<BidderError> warnings) {
        return CollectionUtils.isNotEmpty(warnings) ? seatBid.toBuilder().warnings(ListUtils.union(warnings, seatBid.getWarnings())).build() : seatBid;
    }

    private Future<BidderResponse> invokeHooksAndRequestBids(AuctionContext auctionContext, BidderRequest bidderRequest, Timeout timeout, BidderAliases aliases) {
        return this.hookStageExecutor.executeBidderRequestStage(bidderRequest, auctionContext).compose(stageResult -> this.requestBidsOrRejectBidder((HookStageExecutionResult<BidderRequestPayload>)stageResult, bidderRequest, auctionContext, timeout, aliases)).compose(bidderResponse -> this.hookStageExecutor.executeRawBidderResponseStage((BidderResponse)bidderResponse, auctionContext).map(stageResult -> this.rejectBidderResponseOrProceed((HookStageExecutionResult<BidderResponsePayload>)stageResult, (BidderResponse)bidderResponse)));
    }

    private Future<BidderResponse> requestBidsOrRejectBidder(HookStageExecutionResult<BidderRequestPayload> hookStageResult, BidderRequest bidderRequest, AuctionContext auctionContext, Timeout timeout, BidderAliases aliases) {
        this.httpInteractionLogger.maybeLogBidderRequest(auctionContext, bidderRequest);
        if (hookStageResult.isShouldReject()) {
            auctionContext.getBidRejectionTrackers().get(bidderRequest.getBidder()).rejectAll(BidRejectionReason.REJECTED_BY_HOOK);
            return Future.succeededFuture((Object)BidderResponse.of(bidderRequest.getBidder(), BidderSeatBid.empty(), 0));
        }
        BidderRequest enrichedBidderRequest = bidderRequest.toBuilder().bidRequest(hookStageResult.getPayload().bidRequest()).build();
        return this.requestBids(enrichedBidderRequest, auctionContext, timeout, aliases);
    }

    private Future<BidderResponse> requestBids(BidderRequest bidderRequest, AuctionContext auctionContext, Timeout timeout, BidderAliases aliases) {
        CaseInsensitiveMultiMap requestHeaders = auctionContext.getHttpRequest().getHeaders();
        String bidderName = bidderRequest.getBidder();
        String resolvedBidderName = aliases.resolveBidder(bidderName);
        Bidder<?> bidder = this.bidderCatalog.bidderByName(resolvedBidderName);
        BidRejectionTracker bidRejectionTracker = auctionContext.getBidRejectionTrackers().get(bidderName);
        long auctionStartTime = auctionContext.getStartTime();
        long bidderRequestStartTime = this.clock.millis();
        return Future.succeededFuture((Object)bidderRequest.getBidRequest()).map(bidRequest -> this.adjustTmax((BidRequest)bidRequest, auctionStartTime, bidderRequestStartTime)).map(bidRequest -> this.ortbVersionConversionManager.convertFromAuctionSupportedVersion((BidRequest)bidRequest, bidderRequest.getOrtbVersion())).map(bidderRequest::with).compose(convertedBidderRequest -> this.httpBidderRequester.requestBids(bidder, (BidderRequest)convertedBidderRequest, bidRejectionTracker, this.adjustTimeout(timeout, auctionStartTime, bidderRequestStartTime), requestHeaders, aliases, this.debugResolver.resolveDebugForBidder(auctionContext, resolvedBidderName))).map(seatBid -> BidderResponse.of(bidderName, seatBid, this.responseTime(bidderRequestStartTime)));
    }

    private BidRequest adjustTmax(BidRequest bidRequest, long startTime, long currentTime) {
        long adjustedTmax;
        long tmax = this.timeoutResolver.limitToMax(bidRequest.getTmax());
        return tmax != (adjustedTmax = this.timeoutResolver.adjustForBidder(tmax, this.timeoutAdjustmentFactor, currentTime - startTime)) ? bidRequest.toBuilder().tmax(adjustedTmax).build() : bidRequest;
    }

    private Timeout adjustTimeout(Timeout timeout, long startTime, long currentTime) {
        long adjustedTmax = this.timeoutResolver.adjustForRequest(timeout.getDeadline() - startTime, currentTime - startTime);
        return this.timeoutFactory.create(currentTime, adjustedTmax);
    }

    private BidderResponse rejectBidderResponseOrProceed(HookStageExecutionResult<BidderResponsePayload> stageResult, BidderResponse bidderResponse) {
        List<BidderBid> bids = stageResult.isShouldReject() ? Collections.emptyList() : stageResult.getPayload().bids();
        return bidderResponse.with(bidderResponse.getSeatBid().with(bids));
    }

    private List<AuctionParticipation> dropZeroNonDealBids(List<AuctionParticipation> auctionParticipations, List<String> debugWarnings) {
        return auctionParticipations.stream().map(auctionParticipation -> this.dropZeroNonDealBids((AuctionParticipation)auctionParticipation, debugWarnings)).toList();
    }

    private AuctionParticipation dropZeroNonDealBids(AuctionParticipation auctionParticipation, List<String> debugWarnings) {
        BidderResponse bidderResponse = auctionParticipation.getBidderResponse();
        BidderSeatBid seatBid = bidderResponse.getSeatBid();
        List<BidderBid> bidderBids = seatBid.getBids();
        ArrayList<BidderBid> validBids = new ArrayList<BidderBid>();
        for (BidderBid bidderBid : bidderBids) {
            Bid bid = bidderBid.getBid();
            if (this.isZeroNonDealBids(bid.getPrice(), bid.getDealid())) {
                this.metrics.updateAdapterRequestErrorMetric(bidderResponse.getBidder(), MetricName.unknown_error);
                debugWarnings.add("Dropped bid '%s'. Does not contain a positive (or zero if there is a deal) 'price'".formatted(bid.getId()));
                continue;
            }
            validBids.add(bidderBid);
        }
        return validBids.size() != bidderBids.size() ? auctionParticipation.with(bidderResponse.with(seatBid.with(validBids))) : auctionParticipation;
    }

    private boolean isZeroNonDealBids(BigDecimal price, String dealId) {
        return price == null || price.compareTo(BigDecimal.ZERO) < 0 || price.compareTo(BigDecimal.ZERO) == 0 && StringUtils.isBlank((CharSequence)dealId);
    }

    private List<AuctionParticipation> validateAndAdjustBids(List<AuctionParticipation> auctionParticipations, AuctionContext auctionContext, BidderAliases aliases) {
        return auctionParticipations.stream().map(auctionParticipation -> this.validBidderResponse((AuctionParticipation)auctionParticipation, auctionContext, aliases)).map(auctionParticipation -> this.applyBidPriceChanges((AuctionParticipation)auctionParticipation, auctionContext.getBidRequest())).map(auctionParticipation -> this.priceFloorEnforcer.enforce(auctionContext.getBidRequest(), (AuctionParticipation)auctionParticipation, auctionContext.getAccount(), auctionContext.getBidRejectionTrackers().get(auctionParticipation.getBidder()))).toList();
    }

    private AuctionParticipation validBidderResponse(AuctionParticipation auctionParticipation, AuctionContext auctionContext, BidderAliases aliases) {
        if (auctionParticipation.isRequestBlocked()) {
            return auctionParticipation;
        }
        BidRequest bidRequest = auctionContext.getBidRequest();
        BidderResponse bidderResponse = auctionParticipation.getBidderResponse();
        BidderSeatBid seatBid = bidderResponse.getSeatBid();
        ArrayList<BidderError> errors = new ArrayList<BidderError>(seatBid.getErrors());
        ArrayList<BidderError> warnings = new ArrayList<BidderError>(seatBid.getWarnings());
        List<String> requestCurrencies = bidRequest.getCur();
        if (requestCurrencies.size() > 1) {
            errors.add(BidderError.badInput("Cur parameter contains more than one currency. %s will be used".formatted(requestCurrencies.get(0))));
        }
        List<BidderBid> bids = seatBid.getBids();
        ArrayList<BidderBid> validBids = new ArrayList<BidderBid>(bids.size());
        TxnLog txnLog = auctionContext.getTxnLog();
        String bidder = bidderResponse.getBidder();
        for (BidderBid bid : bids) {
            String lineItemId = LineItemUtil.lineItemIdFrom(bid.getBid(), bidRequest.getImp(), this.mapper);
            ExchangeService.maybeRecordInTxnLog(lineItemId, () -> txnLog.lineItemsReceivedFromBidder().get(bidder));
            ValidationResult validationResult = this.responseBidValidator.validate(bid, bidderResponse.getBidder(), auctionContext, aliases);
            if (validationResult.hasWarnings() || validationResult.hasErrors()) {
                errors.add(this.makeValidationBidderError(bid.getBid(), validationResult));
            }
            if (validationResult.hasErrors()) {
                ExchangeService.maybeRecordInTxnLog(lineItemId, txnLog::lineItemsResponseInvalidated);
                continue;
            }
            if (validationResult.hasErrors()) continue;
            validBids.add(bid);
        }
        BidderResponse resultBidderResponse = errors.size() == seatBid.getErrors().size() ? bidderResponse : bidderResponse.with(seatBid.toBuilder().bids(validBids).errors(errors).warnings(warnings).build());
        return auctionParticipation.with(resultBidderResponse);
    }

    private BidderError makeValidationBidderError(Bid bid, ValidationResult validationResult) {
        String validationErrors = Stream.concat(validationResult.getErrors().stream().map(message -> "Error: " + message), validationResult.getWarnings().stream().map(message -> "Warning: " + message)).collect(Collectors.joining(". "));
        String bidId = ObjectUtil.getIfNotNullOrDefault(bid, Bid::getId, () -> "unknown");
        return BidderError.invalidBid("BidId `" + bidId + "` validation messages: " + validationErrors);
    }

    private static void maybeRecordInTxnLog(String lineItemId, Supplier<Set<String>> metricSupplier) {
        if (lineItemId != null) {
            metricSupplier.get().add(lineItemId);
        }
    }

    private BidResponse publishAuctionEvent(BidResponse bidResponse, AuctionContext auctionContext) {
        if (this.applicationEventService != null) {
            this.applicationEventService.publishAuctionEvent(auctionContext);
        }
        return bidResponse;
    }

    private AuctionParticipation applyBidPriceChanges(AuctionParticipation auctionParticipation, BidRequest bidRequest) {
        if (auctionParticipation.isRequestBlocked()) {
            return auctionParticipation;
        }
        BidderResponse bidderResponse = auctionParticipation.getBidderResponse();
        BidderSeatBid seatBid = bidderResponse.getSeatBid();
        List<BidderBid> bidderBids = seatBid.getBids();
        if (bidderBids.isEmpty()) {
            return auctionParticipation;
        }
        ArrayList<BidderBid> updatedBidderBids = new ArrayList<BidderBid>(bidderBids.size());
        ArrayList<BidderError> errors = new ArrayList<BidderError>(seatBid.getErrors());
        String adServerCurrency = bidRequest.getCur().get(0);
        for (BidderBid bidderBid : bidderBids) {
            try {
                BidderBid updatedBidderBid = this.updateBidderBidWithBidPriceChanges(bidderBid, bidderResponse, bidRequest, adServerCurrency);
                updatedBidderBids.add(updatedBidderBid);
            }
            catch (PreBidException e) {
                errors.add(BidderError.generic(e.getMessage()));
            }
        }
        BidderResponse resultBidderResponse = bidderResponse.with(seatBid.toBuilder().bids(updatedBidderBids).errors(errors).build());
        return auctionParticipation.with(resultBidderResponse);
    }

    private BidderBid updateBidderBidWithBidPriceChanges(BidderBid bidderBid, BidderResponse bidderResponse, BidRequest bidRequest, String adServerCurrency) {
        Bid bid = bidderBid.getBid();
        String bidCurrency = bidderBid.getBidCurrency();
        BigDecimal price = bid.getPrice();
        BigDecimal priceInAdServerCurrency = this.currencyService.convertCurrency(price, bidRequest, StringUtils.stripToNull((String)bidCurrency), adServerCurrency);
        BigDecimal priceAdjustmentFactor = this.bidAdjustmentForBidder(bidderResponse.getBidder(), bidRequest, bidderBid);
        BigDecimal adjustedPrice = ExchangeService.adjustPrice(priceAdjustmentFactor, priceInAdServerCurrency);
        ObjectNode bidExt = bid.getExt();
        ObjectNode updatedBidExt = bidExt != null ? bidExt : this.mapper.mapper().createObjectNode();
        ExchangeService.updateExtWithOrigPriceValues(updatedBidExt, price, bidCurrency);
        Bid.BidBuilder bidBuilder = bid.toBuilder();
        if (adjustedPrice.compareTo(price) != 0) {
            bidBuilder.price(adjustedPrice);
        }
        if (!updatedBidExt.isEmpty()) {
            bidBuilder.ext(updatedBidExt);
        }
        return bidderBid.toBuilder().bid(bidBuilder.build()).build();
    }

    private BigDecimal bidAdjustmentForBidder(String bidder, BidRequest bidRequest, BidderBid bidderBid) {
        ExtRequestBidAdjustmentFactors adjustmentFactors = ExchangeService.extBidAdjustmentFactors(bidRequest);
        if (adjustmentFactors == null) {
            return null;
        }
        ImpMediaType mediaType = ImpMediaTypeResolver.resolve(bidderBid.getBid().getImpid(), bidRequest.getImp(), bidderBid.getType());
        return this.bidAdjustmentFactorResolver.resolve(mediaType, adjustmentFactors, bidder);
    }

    private static ExtRequestBidAdjustmentFactors extBidAdjustmentFactors(BidRequest bidRequest) {
        ExtRequestPrebid prebid = ExchangeService.extRequestPrebid(bidRequest);
        return prebid != null ? prebid.getBidadjustmentfactors() : null;
    }

    private static BigDecimal adjustPrice(BigDecimal priceAdjustmentFactor, BigDecimal price) {
        return priceAdjustmentFactor != null && priceAdjustmentFactor.compareTo(BigDecimal.ONE) != 0 ? price.multiply(priceAdjustmentFactor) : price;
    }

    private static void updateExtWithOrigPriceValues(ObjectNode updatedBidExt, BigDecimal price, String bidCurrency) {
        ExchangeService.addPropertyToNode(updatedBidExt, ORIGINAL_BID_CPM, (JsonNode)new DecimalNode(price));
        if (StringUtils.isNotBlank((CharSequence)bidCurrency)) {
            ExchangeService.addPropertyToNode(updatedBidExt, ORIGINAL_BID_CURRENCY, (JsonNode)new TextNode(bidCurrency));
        }
    }

    private static void addPropertyToNode(ObjectNode node, String propertyName, JsonNode propertyValue) {
        node.set(propertyName, propertyValue);
    }

    private int responseTime(long startTime) {
        return Math.toIntExact(this.clock.millis() - startTime);
    }

    private List<AuctionParticipation> updateResponsesMetrics(List<AuctionParticipation> auctionParticipations, Account account, BidderAliases aliases) {
        List<BidderResponse> bidderResponses = auctionParticipations.stream().filter(auctionParticipation -> !auctionParticipation.isRequestBlocked()).map(AuctionParticipation::getBidderResponse).toList();
        for (BidderResponse bidderResponse : bidderResponses) {
            List<BidderError> errors;
            String bidder = aliases.resolveBidder(bidderResponse.getBidder());
            this.metrics.updateAdapterResponseTime(bidder, account, bidderResponse.getResponseTime());
            List<BidderBid> bidderBids = bidderResponse.getSeatBid().getBids();
            if (CollectionUtils.isEmpty(bidderBids)) {
                this.metrics.updateAdapterRequestNobidMetrics(bidder, account);
            } else {
                this.metrics.updateAdapterRequestGotbidsMetrics(bidder, account);
                for (BidderBid bidderBid : bidderBids) {
                    Bid bid = bidderBid.getBid();
                    long cpm = bid.getPrice().multiply(THOUSAND).longValue();
                    this.metrics.updateAdapterBidMetrics(bidder, account, cpm, bid.getAdm() != null, bidderBid.getType().toString());
                }
            }
            if (!CollectionUtils.isNotEmpty(errors = bidderResponse.getSeatBid().getErrors())) continue;
            errors.stream().map(BidderError::getType).distinct().map(ExchangeService::bidderErrorTypeToMetric).forEach(errorMetric -> this.metrics.updateAdapterRequestErrorMetric(bidder, (MetricName)((Object)errorMetric)));
        }
        return auctionParticipations;
    }

    private Future<AuctionContext> invokeResponseHooks(AuctionContext auctionContext) {
        BidResponse bidResponse = auctionContext.getBidResponse();
        return this.hookStageExecutor.executeAuctionResponseStage(bidResponse, auctionContext).map(stageResult -> ((AuctionResponsePayload)stageResult.getPayload()).bidResponse()).map(auctionContext::with);
    }

    private static MetricName bidderErrorTypeToMetric(BidderError.Type errorType) {
        return switch (errorType) {
            default -> throw new IncompatibleClassChangeError();
            case BidderError.Type.bad_input -> MetricName.badinput;
            case BidderError.Type.bad_server_response -> MetricName.badserverresponse;
            case BidderError.Type.failed_to_request_bids -> MetricName.failedtorequestbids;
            case BidderError.Type.timeout -> MetricName.timeout;
            case BidderError.Type.invalid_bid -> MetricName.bid_validation;
            case BidderError.Type.rejected_ipf, BidderError.Type.generic -> MetricName.unknown_error;
        };
    }

    private AuctionContext enrichWithHooksDebugInfo(AuctionContext context) {
        ExtModules extModules = ExchangeService.toExtModules(context);
        if (extModules == null) {
            return context;
        }
        BidResponse bidResponse = context.getBidResponse();
        Optional<ExtBidResponse> ext = Optional.ofNullable(bidResponse.getExt());
        Optional<ExtBidResponsePrebid> extPrebid = ext.map(ExtBidResponse::getPrebid);
        ExtBidResponsePrebid updatedExtPrebid = extPrebid.map(ExtBidResponsePrebid::toBuilder).orElse(ExtBidResponsePrebid.builder()).modules(extModules).build();
        ExtBidResponse updatedExt = ext.map(ExtBidResponse::toBuilder).orElse(ExtBidResponse.builder()).prebid(updatedExtPrebid).build();
        BidResponse updatedBidResponse = bidResponse.toBuilder().ext(updatedExt).build();
        return context.with(updatedBidResponse);
    }

    private static ExtModules toExtModules(AuctionContext context) {
        Map<String, Map<String, List<String>>> errors = ExchangeService.toHookMessages(context, HookExecutionOutcome::getErrors);
        Map<String, Map<String, List<String>>> warnings = ExchangeService.toHookMessages(context, HookExecutionOutcome::getWarnings);
        ExtModulesTrace trace = ExchangeService.toHookTrace(context);
        return ObjectUtils.anyNotNull((Object[])new Object[]{errors, warnings, trace}) ? ExtModules.of(errors, warnings, trace) : null;
    }

    private static Map<String, Map<String, List<String>>> toHookMessages(AuctionContext context, Function<HookExecutionOutcome, List<String>> messagesGetter) {
        if (!context.getDebugContext().isDebugEnabled()) {
            return null;
        }
        Map<String, List<HookExecutionOutcome>> hookOutcomesByModule = context.getHookExecutionContext().getStageOutcomes().values().stream().flatMap(Collection::stream).flatMap(stageOutcome -> stageOutcome.getGroups().stream()).flatMap(groupOutcome -> groupOutcome.getHooks().stream()).filter(hookOutcome -> CollectionUtils.isNotEmpty((Collection)((Collection)messagesGetter.apply((HookExecutionOutcome)hookOutcome)))).collect(Collectors.groupingBy(hookOutcome -> hookOutcome.getHookId().getModuleCode()));
        Map<String, Map<String, List<String>>> messagesByModule = hookOutcomesByModule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, outcomes -> ((List)outcomes.getValue()).stream().collect(Collectors.groupingBy(hookOutcome -> hookOutcome.getHookId().getHookImplCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, messagesLists -> ((List)messagesLists.getValue()).stream().map(messagesGetter).flatMap(Collection::stream).toList()))));
        return !messagesByModule.isEmpty() ? messagesByModule : null;
    }

    private static ExtModulesTrace toHookTrace(AuctionContext context) {
        TraceLevel traceLevel = context.getDebugContext().getTraceLevel();
        if (traceLevel == null) {
            return null;
        }
        List<ExtModulesTraceStage> stages = context.getHookExecutionContext().getStageOutcomes().entrySet().stream().map(stageOutcome -> ExchangeService.toTraceStage((Stage)((Object)((Object)stageOutcome.getKey())), (List)stageOutcome.getValue(), traceLevel)).filter(Objects::nonNull).toList();
        if (stages.isEmpty()) {
            return null;
        }
        long executionTime = stages.stream().mapToLong(ExtModulesTraceStage::getExecutionTime).sum();
        return ExtModulesTrace.of(executionTime, stages);
    }

    private static ExtModulesTraceStage toTraceStage(Stage stage, List<StageExecutionOutcome> stageOutcomes, TraceLevel level) {
        List<ExtModulesTraceStageOutcome> extStageOutcomes = stageOutcomes.stream().map(stageOutcome -> ExchangeService.toTraceStageOutcome(stageOutcome, level)).filter(Objects::nonNull).toList();
        if (extStageOutcomes.isEmpty()) {
            return null;
        }
        long executionTime = extStageOutcomes.stream().mapToLong(ExtModulesTraceStageOutcome::getExecutionTime).max().orElse(0L);
        return ExtModulesTraceStage.of(stage, executionTime, extStageOutcomes);
    }

    private static ExtModulesTraceStageOutcome toTraceStageOutcome(StageExecutionOutcome stageOutcome, TraceLevel level) {
        List<ExtModulesTraceGroup> groups = stageOutcome.getGroups().stream().map(group -> ExchangeService.toTraceGroup(group, level)).toList();
        if (groups.isEmpty()) {
            return null;
        }
        long executionTime = groups.stream().mapToLong(ExtModulesTraceGroup::getExecutionTime).sum();
        return ExtModulesTraceStageOutcome.of(stageOutcome.getEntity(), executionTime, groups);
    }

    private static ExtModulesTraceGroup toTraceGroup(GroupExecutionOutcome group, TraceLevel level) {
        List<ExtModulesTraceInvocationResult> invocationResults = group.getHooks().stream().map(hook -> ExchangeService.toTraceInvocationResult(hook, level)).toList();
        long executionTime = invocationResults.stream().mapToLong(ExtModulesTraceInvocationResult::getExecutionTime).max().orElse(0L);
        return ExtModulesTraceGroup.of(executionTime, invocationResults);
    }

    private static ExtModulesTraceInvocationResult toTraceInvocationResult(HookExecutionOutcome hook, TraceLevel level) {
        return ExtModulesTraceInvocationResult.builder().hookId(hook.getHookId()).executionTime(hook.getExecutionTime()).status(hook.getStatus()).message(hook.getMessage()).action(hook.getAction()).debugMessages(level == TraceLevel.verbose ? hook.getDebugMessages() : null).analyticsTags(level == TraceLevel.verbose ? ExchangeService.toTraceAnalyticsTags(hook.getAnalyticsTags()) : null).build();
    }

    private static ExtModulesTraceAnalyticsTags toTraceAnalyticsTags(Tags analyticsTags) {
        if (analyticsTags == null) {
            return null;
        }
        return ExtModulesTraceAnalyticsTags.of(CollectionUtils.emptyIfNull(analyticsTags.activities()).stream().filter(Objects::nonNull).map(ExchangeService::toTraceAnalyticsActivity).toList());
    }

    private static ExtModulesTraceAnalyticsActivity toTraceAnalyticsActivity(org.prebid.server.hooks.v1.analytics.Activity activity) {
        return ExtModulesTraceAnalyticsActivity.of(activity.name(), activity.status(), CollectionUtils.emptyIfNull(activity.results()).stream().filter(Objects::nonNull).map(ExchangeService::toTraceAnalyticsResult).toList());
    }

    private static ExtModulesTraceAnalyticsResult toTraceAnalyticsResult(Result result) {
        AppliedTo appliedTo = result.appliedTo();
        ExtModulesTraceAnalyticsAppliedTo extAppliedTo = appliedTo != null ? ExtModulesTraceAnalyticsAppliedTo.builder().impIds(appliedTo.impIds()).bidders(appliedTo.bidders()).request(appliedTo.request() ? Boolean.TRUE : null).response(appliedTo.response() ? Boolean.TRUE : null).bidIds(appliedTo.bidIds()).build() : null;
        return ExtModulesTraceAnalyticsResult.of(result.status(), result.values(), extAppliedTo);
    }

    private AuctionContext updateHooksMetrics(AuctionContext context) {
        EnumMap<Stage, List<StageExecutionOutcome>> stageOutcomes = context.getHookExecutionContext().getStageOutcomes();
        Account account = context.getAccount();
        stageOutcomes.forEach((stage, outcomes) -> this.updateHooksStageMetrics(account, (Stage)((Object)stage), (List<StageExecutionOutcome>)outcomes));
        if (account != null) {
            stageOutcomes.values().stream().flatMap(Collection::stream).map(StageExecutionOutcome::getGroups).flatMap(Collection::stream).map(GroupExecutionOutcome::getHooks).flatMap(Collection::stream).collect(Collectors.groupingBy(outcome -> outcome.getHookId().getModuleCode(), Collectors.summingLong(HookExecutionOutcome::getExecutionTime))).forEach((moduleCode, executionTime) -> this.metrics.updateAccountModuleDurationMetric(account, (String)moduleCode, (Long)executionTime));
        }
        return context;
    }

    private void updateHooksStageMetrics(Account account, Stage stage, List<StageExecutionOutcome> stageOutcomes) {
        stageOutcomes.stream().flatMap(stageOutcome -> stageOutcome.getGroups().stream()).flatMap(groupOutcome -> groupOutcome.getHooks().stream()).forEach(hookOutcome -> this.updateHookInvocationMetrics(account, stage, (HookExecutionOutcome)hookOutcome));
    }

    private void updateHookInvocationMetrics(Account account, Stage stage, HookExecutionOutcome hookOutcome) {
        HookId hookId = hookOutcome.getHookId();
        ExecutionStatus status = hookOutcome.getStatus();
        ExecutionAction action = hookOutcome.getAction();
        String moduleCode = hookId.getModuleCode();
        this.metrics.updateHooksMetrics(moduleCode, stage, hookId.getHookImplCode(), status, hookOutcome.getExecutionTime(), action);
        if (account != null) {
            this.metrics.updateAccountHooksMetrics(account, moduleCode, status, action);
        }
    }

    private <T> List<T> nullIfEmpty(List<T> value) {
        return CollectionUtils.isEmpty(value) ? null : value;
    }

    private static /* synthetic */ void lambda$getBiddersToConfigs$30(Map bidderToConfig, ExtBidderConfigOrtb extBidderConfigFpd) {
        bidderToConfig.put("*", extBidderConfigFpd);
    }

    private static /* synthetic */ void lambda$bidderToMultiBids$16(Integer maxBids, Map bidderToMultiBid, List debugWarnings, String currentBidder) {
        ExchangeService.tryAddBidderWithMultiBid(currentBidder, maxBids, null, bidderToMultiBid, debugWarnings);
    }
}

