/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.iab.openrtb.request.BidRequest;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.debug.DebugContext;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.TraceLevel;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.util.ObjectUtil;

public class DebugResolver {
    private static final String DEBUG_OVERRIDE_HEADER = "x-pbs-debug-override";
    private static final Boolean DEFAULT_DEBUG_ALLOWED_BY_ACCOUNT = true;
    private final BidderCatalog bidderCatalog;
    private final String debugOverrideToken;

    public DebugResolver(BidderCatalog bidderCatalog, String debugOverrideToken) {
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.debugOverrideToken = debugOverrideToken;
    }

    public DebugContext debugContextFrom(AuctionContext auctionContext) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        boolean debugEnabled = this.isDebugEnabled(auctionContext);
        boolean returnAllBidStatus = DebugResolver.shouldReturnAllBidStatus(bidRequest);
        TraceLevel traceLevel = DebugResolver.getTraceLevel(bidRequest);
        return DebugContext.of(debugEnabled, returnAllBidStatus, traceLevel);
    }

    private boolean isDebugEnabled(AuctionContext auctionContext) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        boolean debugOverride = this.isDebugOverridden(auctionContext.getHttpRequest());
        boolean debugEnabledForRequest = this.isDebugEnabledForRequest(bidRequest);
        boolean debugAllowedByAccount = this.isDebugAllowedByAccount(auctionContext.getAccount());
        if (debugEnabledForRequest && !debugOverride && !debugAllowedByAccount) {
            auctionContext.getDebugWarnings().add("Debug turned off for account");
        }
        return debugOverride || debugEnabledForRequest && debugAllowedByAccount;
    }

    private boolean isDebugOverridden(HttpRequestContext httpRequest) {
        return StringUtils.isNotEmpty((CharSequence)this.debugOverrideToken) && StringUtils.equals((CharSequence)httpRequest.getHeaders().get(DEBUG_OVERRIDE_HEADER), (CharSequence)this.debugOverrideToken);
    }

    private boolean isDebugEnabledForRequest(BidRequest bidRequest) {
        return Objects.equals(bidRequest.getTest(), 1) || Objects.equals(ObjectUtil.getIfNotNull(DebugResolver.getExtRequestPrebid(bidRequest), ExtRequestPrebid::getDebug), 1);
    }

    private boolean isDebugAllowedByAccount(Account account) {
        AccountAuctionConfig auctionConfig = ObjectUtil.getIfNotNull(account, Account::getAuction);
        Boolean debugAllowed = ObjectUtil.getIfNotNull(auctionConfig, AccountAuctionConfig::getDebugAllow);
        return (Boolean)ObjectUtils.defaultIfNull((Object)debugAllowed, (Object)DEFAULT_DEBUG_ALLOWED_BY_ACCOUNT);
    }

    private static boolean shouldReturnAllBidStatus(BidRequest bidRequest) {
        return Optional.ofNullable(bidRequest.getExt()).map(ExtRequest::getPrebid).map(ExtRequestPrebid::getReturnallbidstatus).orElse(false);
    }

    private static TraceLevel getTraceLevel(BidRequest bidRequest) {
        return ObjectUtil.getIfNotNull(DebugResolver.getExtRequestPrebid(bidRequest), ExtRequestPrebid::getTrace);
    }

    private static ExtRequestPrebid getExtRequestPrebid(BidRequest bidRequest) {
        return ObjectUtil.getIfNotNull(ObjectUtil.getIfNotNull(bidRequest, BidRequest::getExt), ExtRequest::getPrebid);
    }

    public boolean resolveDebugForBidder(AuctionContext auctionContext, String bidder) {
        DebugContext debugContext = auctionContext.getDebugContext();
        boolean debugEnabled = debugContext.isDebugEnabled();
        boolean debugOverride = this.isDebugOverridden(auctionContext.getHttpRequest());
        boolean debugAllowedByBidder = this.bidderCatalog.isDebugAllowed(bidder);
        if (debugEnabled && !debugOverride && !debugAllowedByBidder) {
            auctionContext.getDebugWarnings().add("Debug turned off for bidder: " + bidder);
        }
        return debugOverride || debugEnabled && debugAllowedByBidder;
    }
}

