/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.auction.PriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtGranularityRange;

public class CpmRange {
    private static final Locale LOCALE = Locale.US;

    private CpmRange() {
    }

    public static String fromCpm(BigDecimal cpm, PriceGranularity priceGranularity) {
        BigDecimal value = CpmRange.fromCpmAsNumber(cpm, priceGranularity);
        return value != null ? CpmRange.format(value, (Integer)ObjectUtils.defaultIfNull((Object)priceGranularity.getPrecision(), (Object)2)) : "";
    }

    public static String format(BigDecimal value, Integer precision) {
        String format = "%%.%sf".formatted(precision);
        return String.format(LOCALE, format, value);
    }

    public static BigDecimal fromCpmAsNumber(BigDecimal cpm, PriceGranularity priceGranularity) {
        BigDecimal rangeMax = priceGranularity.getRangesMax();
        if (cpm.compareTo(rangeMax) > 0) {
            return rangeMax;
        }
        ExtGranularityRange range = CpmRange.findRangeFor(cpm, priceGranularity.getRanges());
        BigDecimal increment = range != null ? range.getIncrement() : null;
        return increment != null ? cpm.divide(increment, 0, RoundingMode.FLOOR).multiply(increment) : null;
    }

    private static ExtGranularityRange findRangeFor(BigDecimal cpm, List<ExtGranularityRange> ranges) {
        BigDecimal min = BigDecimal.ZERO;
        for (ExtGranularityRange range : ranges) {
            if (CpmRange.includes(cpm, min, range.getMax())) {
                return range;
            }
            min = range.getMax();
        }
        return null;
    }

    private static boolean includes(BigDecimal cpm, BigDecimal min, BigDecimal max) {
        return cpm.compareTo(min) >= 0 && cpm.compareTo(max) <= 0;
    }
}

