/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.analytics.reporter.pubstack;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.prebid.server.analytics.AnalyticsReporter;
import org.prebid.server.analytics.model.AmpEvent;
import org.prebid.server.analytics.model.AuctionEvent;
import org.prebid.server.analytics.model.CookieSyncEvent;
import org.prebid.server.analytics.model.NotificationEvent;
import org.prebid.server.analytics.model.SetuidEvent;
import org.prebid.server.analytics.model.VideoEvent;
import org.prebid.server.analytics.reporter.pubstack.PubstackEventHandler;
import org.prebid.server.analytics.reporter.pubstack.model.EventType;
import org.prebid.server.analytics.reporter.pubstack.model.PubstackAnalyticsProperties;
import org.prebid.server.analytics.reporter.pubstack.model.PubstackConfig;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.Initializable;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

public class PubstackAnalyticsReporter
implements AnalyticsReporter,
Initializable {
    private static final Logger logger = LoggerFactory.getLogger(PubstackAnalyticsReporter.class);
    private static final String EVENT_REPORT_ENDPOINT_PATH = "/intake";
    private static final String CONFIG_URL_SUFFIX = "/bootstrap?scopeId=";
    private final long configurationRefreshDelay;
    private final long timeout;
    private final HttpClient httpClient;
    private final JacksonMapper jacksonMapper;
    private final Vertx vertx;
    private final Map<EventType, PubstackEventHandler> eventHandlers;
    private PubstackConfig pubstackConfig;

    public PubstackAnalyticsReporter(PubstackAnalyticsProperties pubstackAnalyticsProperties, HttpClient httpClient, JacksonMapper jacksonMapper, Vertx vertx) {
        this.configurationRefreshDelay = Objects.requireNonNull(pubstackAnalyticsProperties.getConfigurationRefreshDelayMs());
        this.timeout = Objects.requireNonNull(pubstackAnalyticsProperties.getTimeoutMs());
        this.httpClient = Objects.requireNonNull(httpClient);
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
        this.vertx = Objects.requireNonNull(vertx);
        this.eventHandlers = PubstackAnalyticsReporter.createEventHandlers(pubstackAnalyticsProperties, httpClient, jacksonMapper, vertx);
        this.pubstackConfig = PubstackConfig.of(pubstackAnalyticsProperties.getScopeId(), pubstackAnalyticsProperties.getEndpoint(), Collections.emptyMap());
    }

    private static Map<EventType, PubstackEventHandler> createEventHandlers(PubstackAnalyticsProperties pubstackAnalyticsProperties, HttpClient httpClient, JacksonMapper jacksonMapper, Vertx vertx) {
        return Arrays.stream(EventType.values()).collect(Collectors.toMap(Function.identity(), eventType -> new PubstackEventHandler(pubstackAnalyticsProperties, false, PubstackAnalyticsReporter.buildEventEndpointUrl(pubstackAnalyticsProperties.getEndpoint(), eventType), jacksonMapper, httpClient, vertx)));
    }

    private static String buildEventEndpointUrl(String endpoint, EventType eventType) {
        return HttpUtil.validateUrl(endpoint + EVENT_REPORT_ENDPOINT_PATH + eventType.name());
    }

    @Override
    public <T> Future<Void> processEvent(T event) {
        EventType eventType = event instanceof AmpEvent ? EventType.amp : (event instanceof AuctionEvent ? EventType.auction : (event instanceof CookieSyncEvent ? EventType.cookiesync : (event instanceof NotificationEvent ? EventType.notification : (event instanceof SetuidEvent ? EventType.setuid : (event instanceof VideoEvent ? EventType.video : null)))));
        if (eventType != null) {
            this.eventHandlers.get((Object)eventType).handle(event);
        }
        return Future.succeededFuture();
    }

    @Override
    public int vendorId() {
        return 0;
    }

    @Override
    public String name() {
        return "pubstack";
    }

    @Override
    public void initialize() {
        this.vertx.setPeriodic(this.configurationRefreshDelay, id -> this.fetchRemoteConfig());
        this.fetchRemoteConfig();
    }

    void shutdown() {
        this.eventHandlers.values().forEach(PubstackEventHandler::reportEvents);
    }

    private void fetchRemoteConfig() {
        logger.info((Object)"[pubstack] Updating config: {0}", new Object[]{this.pubstackConfig});
        this.httpClient.get(PubstackAnalyticsReporter.makeEventEndpointUrl(this.pubstackConfig.getEndpoint(), this.pubstackConfig.getScopeId()), this.timeout).map(this::processRemoteConfigurationResponse).onComplete(this::updateConfigsOnChange);
    }

    private PubstackConfig processRemoteConfigurationResponse(HttpClientResponse response) {
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new PreBidException("[pubstack] Failed to fetch config, reason: HTTP status code " + statusCode);
        }
        String body = response.getBody();
        try {
            return this.jacksonMapper.decodeValue(body, PubstackConfig.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("[pubstack] Failed to fetch config, reason: failed to parse response: " + body, e);
        }
    }

    private void updateConfigsOnChange(AsyncResult<PubstackConfig> asyncConfigResult) {
        if (asyncConfigResult.failed()) {
            logger.error((Object)"[pubstask] Fail to fetch remote configuration: {0}", new Object[]{asyncConfigResult.cause().getMessage()});
        } else if (!Objects.equals(this.pubstackConfig, asyncConfigResult.result())) {
            PubstackConfig pubstackConfig = (PubstackConfig)asyncConfigResult.result();
            this.eventHandlers.values().forEach(PubstackEventHandler::reportEvents);
            this.pubstackConfig = pubstackConfig;
            this.updateHandlers(pubstackConfig);
        }
    }

    private void updateHandlers(PubstackConfig pubstackConfig) {
        Map handlersEnabled = MapUtils.emptyIfNull(pubstackConfig.getFeatures());
        this.eventHandlers.forEach((eventType, eventHandler) -> eventHandler.updateConfig(BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)handlersEnabled.get(eventType)), (boolean)false), this.makeEventHandlerEndpoint(pubstackConfig.getEndpoint(), (EventType)((Object)eventType)), pubstackConfig.getScopeId()));
    }

    private static String makeEventEndpointUrl(String endpoint, String scopeId) {
        try {
            return HttpUtil.validateUrl(endpoint + CONFIG_URL_SUFFIX + scopeId);
        }
        catch (IllegalArgumentException e) {
            String message = "[pubstack] Failed to create remote config server url for endpoint: " + endpoint;
            logger.error((Object)message);
            throw new PreBidException(message);
        }
    }

    private String makeEventHandlerEndpoint(String endpoint, EventType eventType) {
        try {
            return HttpUtil.validateUrl(endpoint + "/intake/" + eventType.name());
        }
        catch (IllegalArgumentException e) {
            String message = "[pubstack] Failed to create event report url for endpoint: " + endpoint;
            logger.error((Object)message);
            throw new PreBidException(message);
        }
    }
}

