/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.rule;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import org.prebid.server.activity.infrastructure.debug.ActivityDebugUtils;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.rule.Rule;

public class AndRule
implements Rule,
Loggable {
    private final List<? extends Rule> rules;

    public AndRule(List<? extends Rule> rules) {
        this.rules = Objects.requireNonNull(rules);
    }

    @Override
    public Rule.Result proceed(ActivityInvocationPayload activityInvocationPayload) {
        Rule.Result result = Rule.Result.ABSTAIN;
        for (Rule rule : this.rules) {
            Rule.Result ruleResult = rule.proceed(activityInvocationPayload);
            if (ruleResult != Rule.Result.ABSTAIN) {
                result = ruleResult;
            }
            if (result != Rule.Result.DISALLOW) continue;
            break;
        }
        return result;
    }

    @Override
    public JsonNode asLogEntry(ObjectMapper mapper) {
        ObjectNode andNode = mapper.createObjectNode();
        ArrayNode arrayNode = andNode.putArray("and");
        arrayNode.addAll(ActivityDebugUtils.asLogEntry(this.rules, mapper));
        return andNode;
    }
}

