/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.creator.rule;

import java.util.Objects;
import org.prebid.server.activity.infrastructure.creator.ActivityControllerCreationContext;
import org.prebid.server.activity.infrastructure.creator.rule.RuleCreator;
import org.prebid.server.activity.infrastructure.rule.Rule;

public abstract class AbstractRuleCreator<T>
implements RuleCreator<T> {
    private final Class<T> relatedConfigurationClass;

    protected AbstractRuleCreator(Class<T> relatedConfigurationClass) {
        this.relatedConfigurationClass = Objects.requireNonNull(relatedConfigurationClass);
    }

    @Override
    public Class<T> relatedConfigurationClass() {
        return this.relatedConfigurationClass;
    }

    @Override
    public Rule from(Object ruleConfiguration, ActivityControllerCreationContext creationContext) {
        if (!this.relatedConfigurationClass.isInstance(ruleConfiguration)) {
            throw new AssertionError();
        }
        return this.fromConfiguration(this.relatedConfigurationClass.cast(ruleConfiguration), creationContext);
    }

    protected abstract Rule fromConfiguration(T var1, ActivityControllerCreationContext var2);
}

