/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.metrics;

import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Configuration
@ConditionalOnProperty(value={"metrics.prometheus.custom-labels-enabled"}, havingValue="true")
@PropertySource(value={"classpath:/metrics-config/prometheus-labels.yaml"}, factory=YamlPropertySourceFactory.class)
public class PrometheusMapperConfiguration {
    @Bean
    public List<MapperConfig> mapperConfigs(PrometheusMappersProperties prometheusMappersProperties) {
        return prometheusMappersProperties.getMappers().stream().map(mapperProperties -> new MapperConfig(mapperProperties.getMatch(), mapperProperties.getName(), mapperProperties.getLabels())).toList();
    }

    @Component
    @Validated
    @ConditionalOnProperty(value={"metrics.prometheus.custom-labels-enabled"}, havingValue="true")
    @ConfigurationProperties
    public static class PrometheusMappersProperties {
        @NotNull
        List<PrometheusLabelsMapperProperties> mappers;

        @NotNull
        public List<PrometheusLabelsMapperProperties> getMappers() {
            return this.mappers;
        }

        public void setMappers(@NotNull List<PrometheusLabelsMapperProperties> mappers) {
            this.mappers = mappers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrometheusMappersProperties)) {
                return false;
            }
            PrometheusMappersProperties other = (PrometheusMappersProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<PrometheusLabelsMapperProperties> this$mappers = this.getMappers();
            List<PrometheusLabelsMapperProperties> other$mappers = other.getMappers();
            return !(this$mappers == null ? other$mappers != null : !((Object)this$mappers).equals(other$mappers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PrometheusMappersProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<PrometheusLabelsMapperProperties> $mappers = this.getMappers();
            result = result * 59 + ($mappers == null ? 43 : ((Object)$mappers).hashCode());
            return result;
        }

        public String toString() {
            return "PrometheusMapperConfiguration.PrometheusMappersProperties(mappers=" + this.getMappers() + ")";
        }
    }

    @Validated
    public static class PrometheusLabelsMapperProperties {
        @NotNull
        String match;
        @NotNull
        String name;
        Map<String, String> labels;

        @NotNull
        public String getMatch() {
            return this.match;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public Map<String, String> getLabels() {
            return this.labels;
        }

        public void setMatch(@NotNull String match) {
            this.match = match;
        }

        public void setName(@NotNull String name) {
            this.name = name;
        }

        public void setLabels(Map<String, String> labels) {
            this.labels = labels;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrometheusLabelsMapperProperties)) {
                return false;
            }
            PrometheusLabelsMapperProperties other = (PrometheusLabelsMapperProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$match = this.getMatch();
            String other$match = other.getMatch();
            if (this$match == null ? other$match != null : !this$match.equals(other$match)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, String> this$labels = this.getLabels();
            Map<String, String> other$labels = other.getLabels();
            return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PrometheusLabelsMapperProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $match = this.getMatch();
            result = result * 59 + ($match == null ? 43 : $match.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, String> $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
            return result;
        }

        public String toString() {
            return "PrometheusMapperConfiguration.PrometheusLabelsMapperProperties(match=" + this.getMatch() + ", name=" + this.getName() + ", labels=" + this.getLabels() + ")";
        }
    }
}

