/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.metrics;

import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import io.prometheus.client.vertx.MetricsHandler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.Metrics;
import org.prebid.server.metric.prometheus.NamespaceSubsystemSampleBuilder;
import org.prebid.server.vertx.ContextRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Configuration
public class PrometheusConfiguration {
    @Bean
    @ConditionalOnBean(value={PrometheusConfigurationProperties.class})
    public SampleBuilder sampleBuilder(PrometheusConfigurationProperties prometheusConfigurationProperties, List<MapperConfig> mapperConfigs) {
        return new NamespaceSubsystemSampleBuilder(prometheusConfigurationProperties.getNamespace(), prometheusConfigurationProperties.getSubsystem(), mapperConfigs);
    }

    @Validated
    @Component
    @ConfigurationProperties(prefix="metrics.prometheus")
    @ConditionalOnProperty(prefix="metrics.prometheus", name={"enabled"}, havingValue="true")
    public static class PrometheusConfigurationProperties {
        @NotNull
        Integer port;
        String namespace;
        String subsystem;

        @NotNull
        public Integer getPort() {
            return this.port;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getSubsystem() {
            return this.subsystem;
        }

        public void setPort(@NotNull Integer port) {
            this.port = port;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setSubsystem(String subsystem) {
            this.subsystem = subsystem;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrometheusConfigurationProperties)) {
                return false;
            }
            PrometheusConfigurationProperties other = (PrometheusConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$subsystem = this.getSubsystem();
            String other$subsystem = other.getSubsystem();
            return !(this$subsystem == null ? other$subsystem != null : !this$subsystem.equals(other$subsystem));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PrometheusConfigurationProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $subsystem = this.getSubsystem();
            result = result * 59 + ($subsystem == null ? 43 : $subsystem.hashCode());
            return result;
        }

        public String toString() {
            return "PrometheusConfiguration.PrometheusConfigurationProperties(port=" + this.getPort() + ", namespace=" + this.getNamespace() + ", subsystem=" + this.getSubsystem() + ")";
        }
    }

    @Configuration
    @ConditionalOnBean(value={PrometheusConfigurationProperties.class})
    public static class PrometheusServerConfiguration {
        private static final Logger logger = LoggerFactory.getLogger(PrometheusServerConfiguration.class);
        @Autowired
        private ContextRunner contextRunner;
        @Autowired
        private Vertx vertx;
        @Autowired
        private MetricRegistry metricRegistry;
        @Autowired
        private Metrics metrics;
        @Autowired
        private PrometheusConfigurationProperties prometheusConfigurationProperties;
        @Autowired
        private SampleBuilder sampleBuilder;

        @PostConstruct
        public void startPrometheusServer() {
            logger.info((Object)"Starting Prometheus Server on port {0,number,#}", new Object[]{this.prometheusConfigurationProperties.getPort()});
            if (this.metrics.getCounterType() == CounterType.flushingCounter) {
                logger.warn((Object)"Prometheus metric system: Metric type is flushingCounter.");
            }
            Router router = Router.router((Vertx)this.vertx);
            router.route("/metrics").handler((Handler)new MetricsHandler());
            CollectorRegistry.defaultRegistry.register((Collector)new DropwizardExports(this.metricRegistry, this.sampleBuilder));
            this.contextRunner.runOnServiceContext(promise -> this.vertx.createHttpServer().requestHandler((Handler)router).listen(this.prometheusConfigurationProperties.getPort().intValue(), (Handler)promise));
            logger.info((Object)"Successfully started Prometheus Server");
        }
    }
}

