/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.BidderInfo;
import org.prebid.server.bidder.BidderInstanceDeps;
import org.prebid.server.bidder.DisabledBidder;
import org.prebid.server.bidder.Usersyncer;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.model.MediaType;
import org.prebid.server.spring.config.bidder.model.MetaInfo;
import org.prebid.server.spring.config.bidder.model.usersync.CookieFamilySource;
import org.prebid.server.spring.config.bidder.model.usersync.UsersyncConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderInfoCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.Yaml;

public class BidderDepsAssembler<CFG extends BidderConfigurationProperties> {
    private static final String ERROR_MESSAGE_TEMPLATE_FOR_DISABLED = "%s is not configured properly on this Prebid Server deploy.\nIf you believe this should work, contact the company hosting the service and tell them to check their configuration.";
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private String bidderName;
    private CFG configProperties;
    private BiFunction<UsersyncConfigurationProperties, CookieFamilySource, Usersyncer> usersyncerCreator;
    private Function<CFG, Bidder<?>> bidderCreator;

    private BidderDepsAssembler() {
    }

    public static <CFG extends BidderConfigurationProperties> BidderDepsAssembler<CFG> forBidder(String bidderName) {
        BidderDepsAssembler<CFG> assembler = new BidderDepsAssembler<CFG>();
        assembler.bidderName = bidderName;
        return assembler;
    }

    public BidderDepsAssembler<CFG> usersyncerCreator(BiFunction<UsersyncConfigurationProperties, CookieFamilySource, Usersyncer> usersyncerCreator) {
        this.usersyncerCreator = usersyncerCreator;
        return this;
    }

    public BidderDepsAssembler<CFG> bidderCreator(Function<CFG, Bidder<?>> bidderCreator) {
        this.bidderCreator = bidderCreator;
        return this;
    }

    public BidderDepsAssembler<CFG> withConfig(CFG configProperties) {
        this.configProperties = configProperties;
        return this;
    }

    public BidderDeps assemble() {
        return BidderDeps.of(this.coreAndAliasesDeps());
    }

    private List<BidderInstanceDeps> coreAndAliasesDeps() {
        ArrayList<BidderInstanceDeps> deps = new ArrayList<BidderInstanceDeps>();
        deps.add(this.coreDeps());
        deps.addAll(this.aliasesDeps());
        return deps;
    }

    private BidderInstanceDeps coreDeps() {
        this.validateCoreCapabilities(this.bidderName, this.configProperties);
        return this.deps(this.bidderName, this.usersyncer(this.configProperties, CookieFamilySource.ROOT), BidderInfoCreator.create(this.configProperties), this.configProperties);
    }

    private List<BidderInstanceDeps> aliasesDeps() {
        return ((BidderConfigurationProperties)this.configProperties).getAliases().entrySet().stream().map(this::aliasDeps).toList();
    }

    private BidderInstanceDeps aliasDeps(Map.Entry<String, Object> entry) {
        String alias = entry.getKey();
        CFG aliasConfigProperties = this.configurationAsPropertiesObject(entry.getValue(), ((BidderConfigurationProperties)this.configProperties).getSelfClass());
        CFG aliasMergedProperties = this.mergeConfigurations(aliasConfigProperties, this.configProperties);
        this.validateCapabilities(alias, aliasMergedProperties, this.bidderName, this.configProperties);
        Usersyncer usersyncer = Optional.ofNullable(((BidderConfigurationProperties)aliasConfigProperties).getUsersync()).map(UsersyncConfigurationProperties::getCookieFamilyName).map(familyName -> this.usersyncer(aliasMergedProperties, CookieFamilySource.ALIAS)).orElseGet(() -> this.usersyncer(aliasMergedProperties, CookieFamilySource.ROOT));
        return this.deps(alias, usersyncer, BidderInfoCreator.create(aliasMergedProperties, this.bidderName), aliasMergedProperties);
    }

    private BidderInstanceDeps deps(String bidderName, Usersyncer usersyncer, BidderInfo bidderInfo, CFG configProperties) {
        return BidderInstanceDeps.builder().name(bidderName).deprecatedNames(((BidderConfigurationProperties)configProperties).getDeprecatedNames()).bidderInfo(bidderInfo).usersyncer(usersyncer).bidder(this.bidder(configProperties)).build();
    }

    private Usersyncer usersyncer(CFG configProperties, CookieFamilySource cookieFamilySource) {
        UsersyncConfigurationProperties usersync = ((BidderConfigurationProperties)configProperties).getUsersync();
        boolean usersyncPresent = usersync != null && ObjectUtils.anyNotNull((Object[])new Object[]{usersync.getRedirect(), usersync.getIframe()});
        return usersyncPresent ? this.usersyncerCreator.apply(usersync, cookieFamilySource) : null;
    }

    private Bidder<?> bidder(CFG configProperties) {
        return ((BidderConfigurationProperties)configProperties).getEnabled() != false ? this.bidderCreator.apply(configProperties) : new DisabledBidder(ERROR_MESSAGE_TEMPLATE_FOR_DISABLED.formatted(this.bidderName));
    }

    private void validateCoreCapabilities(String bidderName, CFG coreConfiguration) {
        MetaInfo coreMetaInfo = ((BidderConfigurationProperties)coreConfiguration).getMetaInfo();
        List<MediaType> coreAppMediaTypes = coreMetaInfo.getAppMediaTypes();
        List<MediaType> coreSiteMediaTypes = coreMetaInfo.getSiteMediaTypes();
        if (CollectionUtils.isEmpty(coreAppMediaTypes) && CollectionUtils.isEmpty(coreSiteMediaTypes)) {
            throw new IllegalArgumentException("Bidder %s has no any capabilities".formatted(bidderName));
        }
    }

    private void validateCapabilities(String alias, CFG aliasConfiguration, String coreBidder, CFG coreConfiguration) {
        MetaInfo coreMetaInfo = ((BidderConfigurationProperties)coreConfiguration).getMetaInfo();
        MetaInfo aliasMetaInfo = ((BidderConfigurationProperties)aliasConfiguration).getMetaInfo();
        HashSet<MediaType> coreAppMediaTypes = new HashSet<MediaType>(coreMetaInfo.getAppMediaTypes());
        HashSet<MediaType> coreSiteMediaTypes = new HashSet<MediaType>(coreMetaInfo.getSiteMediaTypes());
        Set coreDoohMediaTypes = Optional.ofNullable(coreMetaInfo.getDoohMediaTypes()).map(HashSet::new).orElseGet(Collections::emptySet);
        HashSet<MediaType> aliasAppMediaTypes = new HashSet<MediaType>(aliasMetaInfo.getAppMediaTypes());
        HashSet<MediaType> aliasSiteMediaTypes = new HashSet<MediaType>(aliasMetaInfo.getSiteMediaTypes());
        Set aliasDoohMediaTypes = Optional.ofNullable(aliasMetaInfo.getDoohMediaTypes()).map(HashSet::new).orElseGet(Collections::emptySet);
        if (!(coreAppMediaTypes.containsAll(aliasAppMediaTypes) && coreSiteMediaTypes.containsAll(aliasSiteMediaTypes) && coreDoohMediaTypes.containsAll(aliasDoohMediaTypes))) {
            throw new IllegalArgumentException("Alias %s supports more capabilities (app: %s, site: %s, dooh: %s) than the core bidder %s (app: %s, site: %s, dooh: %s)".formatted(alias, aliasAppMediaTypes, aliasSiteMediaTypes, aliasDoohMediaTypes, coreBidder, coreAppMediaTypes, coreSiteMediaTypes, coreDoohMediaTypes));
        }
    }

    private CFG configurationAsPropertiesObject(Object configuration, Class<?> targetClass) {
        String configAsYamlString = new Yaml().dump(configuration);
        Properties configAsProperties = YamlPropertySourceFactory.readPropertiesFromYamlResource((Resource)new InputStreamResource((InputStream)new ByteArrayInputStream(configAsYamlString.getBytes())));
        Binder configurationBinder = new Binder(new ConfigurationPropertySource[]{new MapConfigurationPropertySource((Map)configAsProperties)});
        return (CFG)((BidderConfigurationProperties)configurationBinder.bindOrCreate("", targetClass));
    }

    private CFG mergeConfigurations(CFG aliasConfiguration, CFG coreConfiguration) {
        try {
            JsonNode mergedNode = JsonMergePatch.fromJson((JsonNode)MAPPER.valueToTree(aliasConfiguration)).apply(MAPPER.valueToTree(coreConfiguration));
            return (CFG)((BidderConfigurationProperties)MAPPER.treeToValue((TreeNode)mergedNode, ((BidderConfigurationProperties)coreConfiguration).getSelfClass()));
        }
        catch (JsonProcessingException | JsonPatchException e) {
            throw new IllegalArgumentException("Exception occurred while merging alias configuration", e);
        }
    }
}

