/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.gotthamads.GothamAdsBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/gothamads.yaml"}, factory=YamlPropertySourceFactory.class)
public class GothamAdsConfiguration {
    private static final String BIDDER_NAME = "gothamads";

    @Bean(value={"gothamAdsConfigurationProperties"})
    @ConfigurationProperties(value="adapters.gothamads")
    BidderConfigurationProperties configurationProperties() {
        return new BidderConfigurationProperties();
    }

    @Bean
    BidderDeps gothamadsBidderDeps(BidderConfigurationProperties gothamAdsConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(gothamAdsConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(externalUrl)).bidderCreator(config -> new GothamAdsBidder(config.getEndpoint(), mapper)).assemble();
    }
}

