/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.alkimi.AlkimiBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/alkimi.yaml"}, factory=YamlPropertySourceFactory.class)
public class AlkimiConfiguration {
    private static final String BIDDER_NAME = "alkimi";
    @Value(value="${external-url}")
    @NotBlank
    private String externalUrl;
    @Autowired
    private JacksonMapper mapper;
    @Autowired
    @Qualifier(value="alkimiConfigurationProperties")
    private BidderConfigurationProperties configProperties;

    @Bean(value={"alkimiConfigurationProperties"})
    @ConfigurationProperties(value="adapters.alkimi")
    BidderConfigurationProperties configurationProperties() {
        return new BidderConfigurationProperties();
    }

    @Bean
    BidderDeps alkimiBidderDeps() {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(this.configProperties).usersyncerCreator(UsersyncerCreator.create(this.externalUrl)).bidderCreator(config -> new AlkimiBidder(config.getEndpoint(), this.mapper)).assemble();
    }
}

