/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.MatchType;
import io.vertx.ext.web.handler.BodyHandler;
import org.prebid.server.vertx.ContextRunner;
import org.prebid.server.vertx.LocalMessageCodec;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class VertxConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(VertxConfiguration.class);

    @Bean
    Vertx vertx(@Value(value="${vertx.worker-pool-size}") int workerPoolSize, @Value(value="${vertx.enable-per-client-endpoint-metrics}") boolean enablePerClientEndpointMetrics, @Value(value="${metrics.jmx.enabled}") boolean jmxEnabled) {
        DropwizardMetricsOptions metricsOptions = new DropwizardMetricsOptions().setEnabled(true).setJmxEnabled(jmxEnabled).setRegistryName("metric-registry");
        if (enablePerClientEndpointMetrics) {
            metricsOptions.addMonitoredHttpClientEndpoint(new Match().setValue(".*").setType(MatchType.REGEX));
        }
        VertxOptions vertxOptions = new VertxOptions().setPreferNativeTransport(true).setWorkerPoolSize(workerPoolSize).setMetricsOptions((MetricsOptions)metricsOptions);
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        logger.info((Object)"Native transport enabled: {0}", new Object[]{vertx.isNativeTransportEnabled()});
        return vertx;
    }

    @Bean
    EventBus eventBus(Vertx vertx) {
        EventBus eventBus = vertx.eventBus();
        eventBus.registerCodec(LocalMessageCodec.create());
        return eventBus;
    }

    @Bean
    FileSystem fileSystem(Vertx vertx) {
        return vertx.fileSystem();
    }

    @Bean
    BodyHandler bodyHandler(@Value(value="${vertx.uploads-dir}") String uploadsDir) {
        return BodyHandler.create((String)uploadsDir);
    }

    @Bean
    ContextRunner contextRunner(Vertx vertx, @Value(value="${vertx.init-timeout-ms}") long initTimeoutMs) {
        return new ContextRunner(vertx, initTimeoutMs);
    }
}

