/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.floors.PriceFloorsConfigResolver;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.json.JsonMerger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.CachingApplicationSettings;
import org.prebid.server.settings.CompositeApplicationSettings;
import org.prebid.server.settings.EnrichingApplicationSettings;
import org.prebid.server.settings.FileApplicationSettings;
import org.prebid.server.settings.HttpApplicationSettings;
import org.prebid.server.settings.JdbcApplicationSettings;
import org.prebid.server.settings.SettingsCache;
import org.prebid.server.settings.service.HttpPeriodicRefreshService;
import org.prebid.server.settings.service.JdbcPeriodicRefreshService;
import org.prebid.server.spring.config.database.DatabaseConfiguration;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.jdbc.JdbcClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

public final class SettingsConfiguration {
    private SettingsConfiguration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Component
    @ConfigurationProperties(prefix="settings.in-memory-cache")
    @ConditionalOnProperty(prefix="settings.in-memory-cache", name={"ttl-seconds", "cache-size"})
    @Validated
    private static class ApplicationSettingsCacheProperties {
        @NotNull
        @Min(value=1L)
        private @NotNull @Min(value=1L) Integer ttlSeconds;
        @NotNull
        @Min(value=1L)
        private @NotNull @Min(value=1L) Integer cacheSize;

        @NotNull
        public Integer getTtlSeconds() {
            return this.ttlSeconds;
        }

        @NotNull
        public Integer getCacheSize() {
            return this.cacheSize;
        }

        public void setTtlSeconds(@NotNull Integer ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
        }

        public void setCacheSize(@NotNull Integer cacheSize) {
            this.cacheSize = cacheSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationSettingsCacheProperties)) {
                return false;
            }
            ApplicationSettingsCacheProperties other = (ApplicationSettingsCacheProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$ttlSeconds = this.getTtlSeconds();
            Integer other$ttlSeconds = other.getTtlSeconds();
            if (this$ttlSeconds == null ? other$ttlSeconds != null : !((Object)this$ttlSeconds).equals(other$ttlSeconds)) {
                return false;
            }
            Integer this$cacheSize = this.getCacheSize();
            Integer other$cacheSize = other.getCacheSize();
            return !(this$cacheSize == null ? other$cacheSize != null : !((Object)this$cacheSize).equals(other$cacheSize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApplicationSettingsCacheProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $ttlSeconds = this.getTtlSeconds();
            result = result * 59 + ($ttlSeconds == null ? 43 : ((Object)$ttlSeconds).hashCode());
            Integer $cacheSize = this.getCacheSize();
            result = result * 59 + ($cacheSize == null ? 43 : ((Object)$cacheSize).hashCode());
            return result;
        }

        public String toString() {
            return "SettingsConfiguration.ApplicationSettingsCacheProperties(ttlSeconds=" + this.getTtlSeconds() + ", cacheSize=" + this.getCacheSize() + ")";
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="settings.in-memory-cache", name={"ttl-seconds", "cache-size"})
    static class CacheConfiguration {
        CacheConfiguration() {
        }

        @Bean
        @Qualifier(value="settingsCache")
        SettingsCache settingsCache(ApplicationSettingsCacheProperties cacheProperties) {
            return new SettingsCache(cacheProperties.getTtlSeconds(), cacheProperties.getCacheSize());
        }

        @Bean
        @Qualifier(value="ampSettingsCache")
        SettingsCache ampSettingsCache(ApplicationSettingsCacheProperties cacheProperties) {
            return new SettingsCache(cacheProperties.getTtlSeconds(), cacheProperties.getCacheSize());
        }

        @Bean
        @Qualifier(value="videoSettingCache")
        SettingsCache videoSettingCache(ApplicationSettingsCacheProperties cacheProperties) {
            return new SettingsCache(cacheProperties.getTtlSeconds(), cacheProperties.getCacheSize());
        }
    }

    @Configuration
    static class ApplicationSettingsConfiguration {
        ApplicationSettingsConfiguration() {
        }

        @Bean
        ApplicationSettings applicationSettings(@Autowired(required=false) CachingApplicationSettings cachingApplicationSettings, EnrichingApplicationSettings enrichingApplicationSettings) {
            return (ApplicationSettings)ObjectUtils.defaultIfNull((Object)cachingApplicationSettings, (Object)enrichingApplicationSettings);
        }
    }

    @Configuration
    static class CachingSettingsConfiguration {
        CachingSettingsConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(prefix="settings.in-memory-cache", name={"ttl-seconds", "cache-size"})
        CachingApplicationSettings cachingApplicationSettings(EnrichingApplicationSettings enrichingApplicationSettings, ApplicationSettingsCacheProperties cacheProperties, @Qualifier(value="settingsCache") SettingsCache cache, @Qualifier(value="ampSettingsCache") SettingsCache ampCache, @Qualifier(value="videoSettingCache") SettingsCache videoCache, Metrics metrics) {
            return new CachingApplicationSettings(enrichingApplicationSettings, cache, ampCache, videoCache, metrics, cacheProperties.getTtlSeconds(), cacheProperties.getCacheSize());
        }
    }

    @Configuration
    static class EnrichingSettingsConfiguration {
        EnrichingSettingsConfiguration() {
        }

        @Bean
        EnrichingApplicationSettings enrichingApplicationSettings(@Value(value="${settings.enforce-valid-account}") boolean enforceValidAccount, @Value(value="${logging.sampling-rate:0.01}") double logSamplingRate, @Value(value="${settings.default-account-config:#{null}}") String defaultAccountConfig, CompositeApplicationSettings compositeApplicationSettings, PriceFloorsConfigResolver priceFloorsConfigResolver, JsonMerger jsonMerger, JacksonMapper jacksonMapper) {
            return new EnrichingApplicationSettings(enforceValidAccount, logSamplingRate, defaultAccountConfig, compositeApplicationSettings, priceFloorsConfigResolver, jsonMerger, jacksonMapper);
        }
    }

    @Configuration
    static class CompositeSettingsConfiguration {
        CompositeSettingsConfiguration() {
        }

        @Bean
        CompositeApplicationSettings compositeApplicationSettings(@Autowired(required=false) FileApplicationSettings fileApplicationSettings, @Autowired(required=false) JdbcApplicationSettings jdbcApplicationSettings, @Autowired(required=false) HttpApplicationSettings httpApplicationSettings) {
            List<ApplicationSettings> applicationSettingsList = Stream.of(fileApplicationSettings, jdbcApplicationSettings, httpApplicationSettings).filter(Objects::nonNull).toList();
            return new CompositeApplicationSettings(applicationSettingsList);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="settings.in-memory-cache.jdbc-update", name={"refresh-rate", "timeout", "init-query", "update-query", "amp-init-query", "amp-update-query"})
    static class JdbcPeriodicRefreshServiceConfiguration {
        @Value(value="${settings.in-memory-cache.jdbc-update.refresh-rate}")
        long refreshPeriod;
        @Value(value="${settings.in-memory-cache.jdbc-update.timeout}")
        long timeout;
        @Autowired
        Vertx vertx;
        @Autowired
        JdbcClient jdbcClient;
        @Autowired
        TimeoutFactory timeoutFactory;
        @Autowired
        Metrics metrics;
        @Autowired
        Clock clock;

        JdbcPeriodicRefreshServiceConfiguration() {
        }

        @Bean
        public JdbcPeriodicRefreshService jdbcPeriodicRefreshService(@Qualifier(value="settingsCache") SettingsCache settingsCache, @Value(value="${settings.in-memory-cache.jdbc-update.init-query}") String initQuery, @Value(value="${settings.in-memory-cache.jdbc-update.update-query}") String updateQuery) {
            return new JdbcPeriodicRefreshService(initQuery, updateQuery, this.refreshPeriod, this.timeout, MetricName.stored_request, settingsCache, this.vertx, this.jdbcClient, this.timeoutFactory, this.metrics, this.clock);
        }

        @Bean
        public JdbcPeriodicRefreshService ampJdbcPeriodicRefreshService(@Qualifier(value="ampSettingsCache") SettingsCache ampSettingsCache, @Value(value="${settings.in-memory-cache.jdbc-update.amp-init-query}") String ampInitQuery, @Value(value="${settings.in-memory-cache.jdbc-update.amp-update-query}") String ampUpdateQuery) {
            return new JdbcPeriodicRefreshService(ampInitQuery, ampUpdateQuery, this.refreshPeriod, this.timeout, MetricName.amp_stored_request, ampSettingsCache, this.vertx, this.jdbcClient, this.timeoutFactory, this.metrics, this.clock);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="settings.in-memory-cache.http-update", name={"endpoint", "amp-endpoint", "refresh-rate", "timeout"})
    static class HttpPeriodicRefreshServiceConfiguration {
        @Value(value="${settings.in-memory-cache.http-update.refresh-rate}")
        long refreshPeriod;
        @Value(value="${settings.in-memory-cache.http-update.timeout}")
        long timeout;
        @Autowired
        Vertx vertx;
        @Autowired
        HttpClient httpClient;

        HttpPeriodicRefreshServiceConfiguration() {
        }

        @Bean
        public HttpPeriodicRefreshService httpPeriodicRefreshService(@Value(value="${settings.in-memory-cache.http-update.endpoint}") String endpoint, SettingsCache settingsCache, JacksonMapper mapper) {
            return new HttpPeriodicRefreshService(endpoint, this.refreshPeriod, this.timeout, settingsCache, this.vertx, this.httpClient, mapper);
        }

        @Bean
        public HttpPeriodicRefreshService ampHttpPeriodicRefreshService(@Value(value="${settings.in-memory-cache.http-update.amp-endpoint}") String ampEndpoint, SettingsCache ampSettingsCache, JacksonMapper mapper) {
            return new HttpPeriodicRefreshService(ampEndpoint, this.refreshPeriod, this.timeout, ampSettingsCache, this.vertx, this.httpClient, mapper);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="settings.http", name={"endpoint", "amp-endpoint"})
    static class HttpSettingsConfiguration {
        HttpSettingsConfiguration() {
        }

        @Bean
        HttpApplicationSettings httpApplicationSettings(HttpClient httpClient, JacksonMapper mapper, @Value(value="${settings.http.endpoint}") String endpoint, @Value(value="${settings.http.amp-endpoint}") String ampEndpoint, @Value(value="${settings.http.video-endpoint}") String videoEndpoint, @Value(value="${settings.http.category-endpoint}") String categoryEndpoint) {
            return new HttpApplicationSettings(httpClient, mapper, endpoint, ampEndpoint, videoEndpoint, categoryEndpoint);
        }
    }

    @Configuration
    @ConditionalOnBean(value={DatabaseConfiguration.class})
    static class DatabaseSettingsConfiguration {
        DatabaseSettingsConfiguration() {
        }

        @Bean
        JdbcApplicationSettings jdbcApplicationSettings(@Value(value="${settings.database.account-query}") String accountQuery, @Value(value="${settings.database.stored-requests-query}") String storedRequestsQuery, @Value(value="${settings.database.amp-stored-requests-query}") String ampStoredRequestsQuery, @Value(value="${settings.database.stored-responses-query}") String storedResponsesQuery, JdbcClient jdbcClient, JacksonMapper jacksonMapper) {
            return new JdbcApplicationSettings(jdbcClient, jacksonMapper, accountQuery, storedRequestsQuery, ampStoredRequestsQuery, storedResponsesQuery);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="settings.filesystem", name={"settings-filename", "stored-requests-dir", "stored-imps-dir"})
    static class FileSettingsConfiguration {
        FileSettingsConfiguration() {
        }

        @Bean
        FileApplicationSettings fileApplicationSettings(@Value(value="${settings.filesystem.settings-filename}") String settingsFileName, @Value(value="${settings.filesystem.stored-requests-dir}") String storedRequestsDir, @Value(value="${settings.filesystem.stored-imps-dir}") String storedImpsDir, @Value(value="${settings.filesystem.stored-responses-dir}") String storedResponsesDir, @Value(value="${settings.filesystem.categories-dir}") String categoriesDir, FileSystem fileSystem, JacksonMapper jacksonMapper) {
            return new FileApplicationSettings(fileSystem, settingsFileName, storedRequestsDir, storedImpsDir, storedResponsesDir, categoriesDir, jacksonMapper);
        }
    }
}

