/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Vertx;
import java.time.Clock;
import java.util.Collection;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.hooks.execution.HookCatalog;
import org.prebid.server.hooks.execution.HookStageExecutor;
import org.prebid.server.hooks.v1.Module;
import org.prebid.server.json.JacksonMapper;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

@Configuration
public class HooksConfiguration {
    @Bean
    HookCatalog hookCatalog(Collection<Module> modules) {
        return new HookCatalog(modules);
    }

    @Bean
    HookStageExecutor hookStageExecutor(HooksConfigurationProperties hooksConfiguration, HookCatalog hookCatalog, TimeoutFactory timeoutFactory, Vertx vertx, Clock clock, JacksonMapper mapper) {
        return HookStageExecutor.create(hooksConfiguration.getHostExecutionPlan(), hooksConfiguration.getDefaultAccountExecutionPlan(), hookCatalog, timeoutFactory, vertx, clock, mapper);
    }

    @Bean
    @ConfigurationProperties(value="hooks")
    HooksConfigurationProperties hooksConfigurationProperties() {
        return new HooksConfigurationProperties();
    }

    @Validated
    private static class HooksConfigurationProperties {
        String hostExecutionPlan;
        String defaultAccountExecutionPlan;

        public String getHostExecutionPlan() {
            return this.hostExecutionPlan;
        }

        public String getDefaultAccountExecutionPlan() {
            return this.defaultAccountExecutionPlan;
        }

        public void setHostExecutionPlan(String hostExecutionPlan) {
            this.hostExecutionPlan = hostExecutionPlan;
        }

        public void setDefaultAccountExecutionPlan(String defaultAccountExecutionPlan) {
            this.defaultAccountExecutionPlan = defaultAccountExecutionPlan;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HooksConfigurationProperties)) {
                return false;
            }
            HooksConfigurationProperties other = (HooksConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hostExecutionPlan = this.getHostExecutionPlan();
            String other$hostExecutionPlan = other.getHostExecutionPlan();
            if (this$hostExecutionPlan == null ? other$hostExecutionPlan != null : !this$hostExecutionPlan.equals(other$hostExecutionPlan)) {
                return false;
            }
            String this$defaultAccountExecutionPlan = this.getDefaultAccountExecutionPlan();
            String other$defaultAccountExecutionPlan = other.getDefaultAccountExecutionPlan();
            return !(this$defaultAccountExecutionPlan == null ? other$defaultAccountExecutionPlan != null : !this$defaultAccountExecutionPlan.equals(other$defaultAccountExecutionPlan));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HooksConfigurationProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostExecutionPlan = this.getHostExecutionPlan();
            result = result * 59 + ($hostExecutionPlan == null ? 43 : $hostExecutionPlan.hashCode());
            String $defaultAccountExecutionPlan = this.getDefaultAccountExecutionPlan();
            result = result * 59 + ($defaultAccountExecutionPlan == null ? 43 : $defaultAccountExecutionPlan.hashCode());
            return result;
        }

        public String toString() {
            return "HooksConfiguration.HooksConfigurationProperties(hostExecutionPlan=" + this.getHostExecutionPlan() + ", defaultAccountExecutionPlan=" + this.getDefaultAccountExecutionPlan() + ")";
        }
    }
}

