/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.BidderErrorNotifier;
import org.prebid.server.bidder.BidderRequestCompletionTrackerFactory;
import org.prebid.server.bidder.DealsBidderRequestCompletionTrackerFactory;
import org.prebid.server.bidder.HttpBidderRequestEnricher;
import org.prebid.server.bidder.HttpBidderRequester;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.deals.AdminCentralService;
import org.prebid.server.deals.AlertHttpService;
import org.prebid.server.deals.DealsService;
import org.prebid.server.deals.DeliveryProgressReportFactory;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.DeliveryStatsService;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.PlannerService;
import org.prebid.server.deals.RegisterService;
import org.prebid.server.deals.Suspendable;
import org.prebid.server.deals.TargetingService;
import org.prebid.server.deals.UserAdditionalInfoService;
import org.prebid.server.deals.UserService;
import org.prebid.server.deals.deviceinfo.DeviceInfoService;
import org.prebid.server.deals.events.AdminEventProcessor;
import org.prebid.server.deals.events.AdminEventService;
import org.prebid.server.deals.events.ApplicationEventProcessor;
import org.prebid.server.deals.events.ApplicationEventService;
import org.prebid.server.deals.events.EventServiceInitializer;
import org.prebid.server.deals.simulation.DealsSimulationAdminHandler;
import org.prebid.server.deals.simulation.SimulationAwareDeliveryProgressService;
import org.prebid.server.deals.simulation.SimulationAwareDeliveryStatsService;
import org.prebid.server.deals.simulation.SimulationAwareHttpBidderRequester;
import org.prebid.server.deals.simulation.SimulationAwareLineItemService;
import org.prebid.server.deals.simulation.SimulationAwarePlannerService;
import org.prebid.server.deals.simulation.SimulationAwareRegisterService;
import org.prebid.server.deals.simulation.SimulationAwareUserService;
import org.prebid.server.geolocation.GeoLocationService;
import org.prebid.server.health.HealthMonitor;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.CriteriaLogManager;
import org.prebid.server.log.CriteriaManager;
import org.prebid.server.metric.Metrics;
import org.prebid.server.settings.CachingApplicationSettings;
import org.prebid.server.settings.SettingsCache;
import org.prebid.server.vertx.ContextRunner;
import org.prebid.server.vertx.http.HttpClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.validation.annotation.Validated;

@Configuration
public class DealsConfiguration {

    @Validated
    private static class SimulationProperties {
        @NotNull
        boolean enabled;
        Boolean winEventsEnabled;
        Boolean userDetailsEnabled;

        org.prebid.server.deals.model.SimulationProperties toComponentProperties() {
            return org.prebid.server.deals.model.SimulationProperties.builder().enabled(this.isEnabled()).winEventsEnabled(this.getWinEventsEnabled() != null ? this.getWinEventsEnabled() : false).userDetailsEnabled(this.getUserDetailsEnabled() != null ? this.getUserDetailsEnabled() : false).build();
        }

        @NotNull
        public boolean isEnabled() {
            return this.enabled;
        }

        public Boolean getWinEventsEnabled() {
            return this.winEventsEnabled;
        }

        public Boolean getUserDetailsEnabled() {
            return this.userDetailsEnabled;
        }

        public void setEnabled(@NotNull boolean enabled) {
            this.enabled = enabled;
        }

        public void setWinEventsEnabled(Boolean winEventsEnabled) {
            this.winEventsEnabled = winEventsEnabled;
        }

        public void setUserDetailsEnabled(Boolean userDetailsEnabled) {
            this.userDetailsEnabled = userDetailsEnabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimulationProperties)) {
                return false;
            }
            SimulationProperties other = (SimulationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Boolean this$winEventsEnabled = this.getWinEventsEnabled();
            Boolean other$winEventsEnabled = other.getWinEventsEnabled();
            if (this$winEventsEnabled == null ? other$winEventsEnabled != null : !((Object)this$winEventsEnabled).equals(other$winEventsEnabled)) {
                return false;
            }
            Boolean this$userDetailsEnabled = this.getUserDetailsEnabled();
            Boolean other$userDetailsEnabled = other.getUserDetailsEnabled();
            return !(this$userDetailsEnabled == null ? other$userDetailsEnabled != null : !((Object)this$userDetailsEnabled).equals(other$userDetailsEnabled));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SimulationProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Boolean $winEventsEnabled = this.getWinEventsEnabled();
            result = result * 59 + ($winEventsEnabled == null ? 43 : ((Object)$winEventsEnabled).hashCode());
            Boolean $userDetailsEnabled = this.getUserDetailsEnabled();
            result = result * 59 + ($userDetailsEnabled == null ? 43 : ((Object)$userDetailsEnabled).hashCode());
            return result;
        }

        public String toString() {
            return "DealsConfiguration.SimulationProperties(enabled=" + this.isEnabled() + ", winEventsEnabled=" + this.getWinEventsEnabled() + ", userDetailsEnabled=" + this.getUserDetailsEnabled() + ")";
        }
    }

    @Validated
    private static class UserIdRule {
        @NotBlank
        private String type;
        @NotBlank
        private String source;
        @NotBlank
        private String location;

        org.prebid.server.deals.model.UserIdRule toComponentProperties() {
            return org.prebid.server.deals.model.UserIdRule.of(this.getType(), this.getSource(), this.getLocation());
        }

        public String getType() {
            return this.type;
        }

        public String getSource() {
            return this.source;
        }

        public String getLocation() {
            return this.location;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserIdRule)) {
                return false;
            }
            UserIdRule other = (UserIdRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$location = this.getLocation();
            String other$location = other.getLocation();
            return !(this$location == null ? other$location != null : !this$location.equals(other$location));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserIdRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            return result;
        }

        public String toString() {
            return "DealsConfiguration.UserIdRule(type=" + this.getType() + ", source=" + this.getSource() + ", location=" + this.getLocation() + ")";
        }
    }

    @Validated
    private static class AlertProxyProperties {
        @NotNull
        private boolean enabled;
        @NotBlank
        private String url;
        @NotNull
        private Integer timeoutSec;
        Map<String, Long> alertTypes;
        @NotBlank
        private String username;
        @NotBlank
        private String password;

        public org.prebid.server.deals.model.AlertProxyProperties toComponentProperties() {
            return org.prebid.server.deals.model.AlertProxyProperties.builder().enabled(this.isEnabled()).url(this.getUrl()).timeoutSec(this.getTimeoutSec()).alertTypes((Map)ObjectUtils.defaultIfNull(this.getAlertTypes(), new HashMap())).username(this.getUsername()).password(this.getPassword()).build();
        }

        @NotNull
        public boolean isEnabled() {
            return this.enabled;
        }

        public String getUrl() {
            return this.url;
        }

        @NotNull
        public Integer getTimeoutSec() {
            return this.timeoutSec;
        }

        public Map<String, Long> getAlertTypes() {
            return this.alertTypes;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnabled(@NotNull boolean enabled) {
            this.enabled = enabled;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setTimeoutSec(@NotNull Integer timeoutSec) {
            this.timeoutSec = timeoutSec;
        }

        public void setAlertTypes(Map<String, Long> alertTypes) {
            this.alertTypes = alertTypes;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlertProxyProperties)) {
                return false;
            }
            AlertProxyProperties other = (AlertProxyProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Integer this$timeoutSec = this.getTimeoutSec();
            Integer other$timeoutSec = other.getTimeoutSec();
            if (this$timeoutSec == null ? other$timeoutSec != null : !((Object)this$timeoutSec).equals(other$timeoutSec)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            Map<String, Long> this$alertTypes = this.getAlertTypes();
            Map<String, Long> other$alertTypes = other.getAlertTypes();
            if (this$alertTypes == null ? other$alertTypes != null : !((Object)this$alertTypes).equals(other$alertTypes)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlertProxyProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Integer $timeoutSec = this.getTimeoutSec();
            result = result * 59 + ($timeoutSec == null ? 43 : ((Object)$timeoutSec).hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            Map<String, Long> $alertTypes = this.getAlertTypes();
            result = result * 59 + ($alertTypes == null ? 43 : ((Object)$alertTypes).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "DealsConfiguration.AlertProxyProperties(enabled=" + this.isEnabled() + ", url=" + this.getUrl() + ", timeoutSec=" + this.getTimeoutSec() + ", alertTypes=" + this.getAlertTypes() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }

    @Validated
    private static class UserDetailsProperties {
        @NotBlank
        private String userDetailsEndpoint;
        @NotBlank
        private String winEventEndpoint;
        @NotNull
        private Long timeout;
        @NotNull
        private List<UserIdRule> userIds;

        public org.prebid.server.deals.model.UserDetailsProperties toComponentProperties() {
            List<org.prebid.server.deals.model.UserIdRule> componentUserIds = this.getUserIds().stream().map(UserIdRule::toComponentProperties).toList();
            return org.prebid.server.deals.model.UserDetailsProperties.of(this.getUserDetailsEndpoint(), this.getWinEventEndpoint(), this.getTimeout(), componentUserIds);
        }

        public String getUserDetailsEndpoint() {
            return this.userDetailsEndpoint;
        }

        public String getWinEventEndpoint() {
            return this.winEventEndpoint;
        }

        @NotNull
        public Long getTimeout() {
            return this.timeout;
        }

        @NotNull
        public List<UserIdRule> getUserIds() {
            return this.userIds;
        }

        public void setUserDetailsEndpoint(String userDetailsEndpoint) {
            this.userDetailsEndpoint = userDetailsEndpoint;
        }

        public void setWinEventEndpoint(String winEventEndpoint) {
            this.winEventEndpoint = winEventEndpoint;
        }

        public void setTimeout(@NotNull Long timeout) {
            this.timeout = timeout;
        }

        public void setUserIds(@NotNull List<UserIdRule> userIds) {
            this.userIds = userIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserDetailsProperties)) {
                return false;
            }
            UserDetailsProperties other = (UserDetailsProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$timeout = this.getTimeout();
            Long other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            String this$userDetailsEndpoint = this.getUserDetailsEndpoint();
            String other$userDetailsEndpoint = other.getUserDetailsEndpoint();
            if (this$userDetailsEndpoint == null ? other$userDetailsEndpoint != null : !this$userDetailsEndpoint.equals(other$userDetailsEndpoint)) {
                return false;
            }
            String this$winEventEndpoint = this.getWinEventEndpoint();
            String other$winEventEndpoint = other.getWinEventEndpoint();
            if (this$winEventEndpoint == null ? other$winEventEndpoint != null : !this$winEventEndpoint.equals(other$winEventEndpoint)) {
                return false;
            }
            List<UserIdRule> this$userIds = this.getUserIds();
            List<UserIdRule> other$userIds = other.getUserIds();
            return !(this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserDetailsProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            String $userDetailsEndpoint = this.getUserDetailsEndpoint();
            result = result * 59 + ($userDetailsEndpoint == null ? 43 : $userDetailsEndpoint.hashCode());
            String $winEventEndpoint = this.getWinEventEndpoint();
            result = result * 59 + ($winEventEndpoint == null ? 43 : $winEventEndpoint.hashCode());
            List<UserIdRule> $userIds = this.getUserIds();
            result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
            return result;
        }

        public String toString() {
            return "DealsConfiguration.UserDetailsProperties(userDetailsEndpoint=" + this.getUserDetailsEndpoint() + ", winEventEndpoint=" + this.getWinEventEndpoint() + ", timeout=" + this.getTimeout() + ", userIds=" + this.getUserIds() + ")";
        }
    }

    @Validated
    private static class DeliveryProgressProperties {
        @NotNull
        private Long lineItemStatusTtlSec;
        @NotNull
        private Integer cachedPlansNumber;

        public org.prebid.server.deals.model.DeliveryProgressProperties toComponentProperties() {
            return org.prebid.server.deals.model.DeliveryProgressProperties.of(this.getLineItemStatusTtlSec(), this.getCachedPlansNumber());
        }

        @NotNull
        public Long getLineItemStatusTtlSec() {
            return this.lineItemStatusTtlSec;
        }

        @NotNull
        public Integer getCachedPlansNumber() {
            return this.cachedPlansNumber;
        }

        public void setLineItemStatusTtlSec(@NotNull Long lineItemStatusTtlSec) {
            this.lineItemStatusTtlSec = lineItemStatusTtlSec;
        }

        public void setCachedPlansNumber(@NotNull Integer cachedPlansNumber) {
            this.cachedPlansNumber = cachedPlansNumber;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeliveryProgressProperties)) {
                return false;
            }
            DeliveryProgressProperties other = (DeliveryProgressProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lineItemStatusTtlSec = this.getLineItemStatusTtlSec();
            Long other$lineItemStatusTtlSec = other.getLineItemStatusTtlSec();
            if (this$lineItemStatusTtlSec == null ? other$lineItemStatusTtlSec != null : !((Object)this$lineItemStatusTtlSec).equals(other$lineItemStatusTtlSec)) {
                return false;
            }
            Integer this$cachedPlansNumber = this.getCachedPlansNumber();
            Integer other$cachedPlansNumber = other.getCachedPlansNumber();
            return !(this$cachedPlansNumber == null ? other$cachedPlansNumber != null : !((Object)this$cachedPlansNumber).equals(other$cachedPlansNumber));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeliveryProgressProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lineItemStatusTtlSec = this.getLineItemStatusTtlSec();
            result = result * 59 + ($lineItemStatusTtlSec == null ? 43 : ((Object)$lineItemStatusTtlSec).hashCode());
            Integer $cachedPlansNumber = this.getCachedPlansNumber();
            result = result * 59 + ($cachedPlansNumber == null ? 43 : ((Object)$cachedPlansNumber).hashCode());
            return result;
        }

        public String toString() {
            return "DealsConfiguration.DeliveryProgressProperties(lineItemStatusTtlSec=" + this.getLineItemStatusTtlSec() + ", cachedPlansNumber=" + this.getCachedPlansNumber() + ")";
        }
    }

    @Validated
    private static class DeliveryStatsProperties {
        @NotBlank
        private String endpoint;
        @NotNull
        private Integer cachedReportsNumber;
        @NotNull
        private Long timeoutMs;
        @NotNull
        private Integer lineItemsPerReport;
        @NotNull
        private Integer reportsIntervalMs;
        @NotNull
        private Integer batchesIntervalMs;
        @NotNull
        private Boolean requestCompressionEnabled;
        @NotBlank
        private String username;
        @NotBlank
        private String password;

        public org.prebid.server.deals.model.DeliveryStatsProperties toComponentProperties() {
            return org.prebid.server.deals.model.DeliveryStatsProperties.builder().endpoint(this.getEndpoint()).cachedReportsNumber(this.getCachedReportsNumber()).timeoutMs(this.getTimeoutMs()).lineItemsPerReport(this.getLineItemsPerReport()).reportsIntervalMs(this.getReportsIntervalMs()).batchesIntervalMs(this.getBatchesIntervalMs()).requestCompressionEnabled(this.getRequestCompressionEnabled()).username(this.getUsername()).password(this.getPassword()).build();
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        @NotNull
        public Integer getCachedReportsNumber() {
            return this.cachedReportsNumber;
        }

        @NotNull
        public Long getTimeoutMs() {
            return this.timeoutMs;
        }

        @NotNull
        public Integer getLineItemsPerReport() {
            return this.lineItemsPerReport;
        }

        @NotNull
        public Integer getReportsIntervalMs() {
            return this.reportsIntervalMs;
        }

        @NotNull
        public Integer getBatchesIntervalMs() {
            return this.batchesIntervalMs;
        }

        @NotNull
        public Boolean getRequestCompressionEnabled() {
            return this.requestCompressionEnabled;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setCachedReportsNumber(@NotNull Integer cachedReportsNumber) {
            this.cachedReportsNumber = cachedReportsNumber;
        }

        public void setTimeoutMs(@NotNull Long timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public void setLineItemsPerReport(@NotNull Integer lineItemsPerReport) {
            this.lineItemsPerReport = lineItemsPerReport;
        }

        public void setReportsIntervalMs(@NotNull Integer reportsIntervalMs) {
            this.reportsIntervalMs = reportsIntervalMs;
        }

        public void setBatchesIntervalMs(@NotNull Integer batchesIntervalMs) {
            this.batchesIntervalMs = batchesIntervalMs;
        }

        public void setRequestCompressionEnabled(@NotNull Boolean requestCompressionEnabled) {
            this.requestCompressionEnabled = requestCompressionEnabled;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeliveryStatsProperties)) {
                return false;
            }
            DeliveryStatsProperties other = (DeliveryStatsProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$cachedReportsNumber = this.getCachedReportsNumber();
            Integer other$cachedReportsNumber = other.getCachedReportsNumber();
            if (this$cachedReportsNumber == null ? other$cachedReportsNumber != null : !((Object)this$cachedReportsNumber).equals(other$cachedReportsNumber)) {
                return false;
            }
            Long this$timeoutMs = this.getTimeoutMs();
            Long other$timeoutMs = other.getTimeoutMs();
            if (this$timeoutMs == null ? other$timeoutMs != null : !((Object)this$timeoutMs).equals(other$timeoutMs)) {
                return false;
            }
            Integer this$lineItemsPerReport = this.getLineItemsPerReport();
            Integer other$lineItemsPerReport = other.getLineItemsPerReport();
            if (this$lineItemsPerReport == null ? other$lineItemsPerReport != null : !((Object)this$lineItemsPerReport).equals(other$lineItemsPerReport)) {
                return false;
            }
            Integer this$reportsIntervalMs = this.getReportsIntervalMs();
            Integer other$reportsIntervalMs = other.getReportsIntervalMs();
            if (this$reportsIntervalMs == null ? other$reportsIntervalMs != null : !((Object)this$reportsIntervalMs).equals(other$reportsIntervalMs)) {
                return false;
            }
            Integer this$batchesIntervalMs = this.getBatchesIntervalMs();
            Integer other$batchesIntervalMs = other.getBatchesIntervalMs();
            if (this$batchesIntervalMs == null ? other$batchesIntervalMs != null : !((Object)this$batchesIntervalMs).equals(other$batchesIntervalMs)) {
                return false;
            }
            Boolean this$requestCompressionEnabled = this.getRequestCompressionEnabled();
            Boolean other$requestCompressionEnabled = other.getRequestCompressionEnabled();
            if (this$requestCompressionEnabled == null ? other$requestCompressionEnabled != null : !((Object)this$requestCompressionEnabled).equals(other$requestCompressionEnabled)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeliveryStatsProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $cachedReportsNumber = this.getCachedReportsNumber();
            result = result * 59 + ($cachedReportsNumber == null ? 43 : ((Object)$cachedReportsNumber).hashCode());
            Long $timeoutMs = this.getTimeoutMs();
            result = result * 59 + ($timeoutMs == null ? 43 : ((Object)$timeoutMs).hashCode());
            Integer $lineItemsPerReport = this.getLineItemsPerReport();
            result = result * 59 + ($lineItemsPerReport == null ? 43 : ((Object)$lineItemsPerReport).hashCode());
            Integer $reportsIntervalMs = this.getReportsIntervalMs();
            result = result * 59 + ($reportsIntervalMs == null ? 43 : ((Object)$reportsIntervalMs).hashCode());
            Integer $batchesIntervalMs = this.getBatchesIntervalMs();
            result = result * 59 + ($batchesIntervalMs == null ? 43 : ((Object)$batchesIntervalMs).hashCode());
            Boolean $requestCompressionEnabled = this.getRequestCompressionEnabled();
            result = result * 59 + ($requestCompressionEnabled == null ? 43 : ((Object)$requestCompressionEnabled).hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "DealsConfiguration.DeliveryStatsProperties(endpoint=" + this.getEndpoint() + ", cachedReportsNumber=" + this.getCachedReportsNumber() + ", timeoutMs=" + this.getTimeoutMs() + ", lineItemsPerReport=" + this.getLineItemsPerReport() + ", reportsIntervalMs=" + this.getReportsIntervalMs() + ", batchesIntervalMs=" + this.getBatchesIntervalMs() + ", requestCompressionEnabled=" + this.getRequestCompressionEnabled() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }

    @Validated
    private static class PlannerProperties {
        @NotBlank
        private String planEndpoint;
        @NotBlank
        private String registerEndpoint;
        @NotNull
        private Long timeoutMs;
        @NotNull
        private Long registerPeriodSec;
        @NotBlank
        private String username;
        @NotBlank
        private String password;

        public org.prebid.server.deals.model.PlannerProperties toComponentProperties() {
            return org.prebid.server.deals.model.PlannerProperties.builder().planEndpoint(this.getPlanEndpoint()).registerEndpoint(this.getRegisterEndpoint()).timeoutMs(this.getTimeoutMs()).registerPeriodSeconds(this.getRegisterPeriodSec()).username(this.getUsername()).password(this.getPassword()).build();
        }

        public String getPlanEndpoint() {
            return this.planEndpoint;
        }

        public String getRegisterEndpoint() {
            return this.registerEndpoint;
        }

        @NotNull
        public Long getTimeoutMs() {
            return this.timeoutMs;
        }

        @NotNull
        public Long getRegisterPeriodSec() {
            return this.registerPeriodSec;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPlanEndpoint(String planEndpoint) {
            this.planEndpoint = planEndpoint;
        }

        public void setRegisterEndpoint(String registerEndpoint) {
            this.registerEndpoint = registerEndpoint;
        }

        public void setTimeoutMs(@NotNull Long timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public void setRegisterPeriodSec(@NotNull Long registerPeriodSec) {
            this.registerPeriodSec = registerPeriodSec;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlannerProperties)) {
                return false;
            }
            PlannerProperties other = (PlannerProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$timeoutMs = this.getTimeoutMs();
            Long other$timeoutMs = other.getTimeoutMs();
            if (this$timeoutMs == null ? other$timeoutMs != null : !((Object)this$timeoutMs).equals(other$timeoutMs)) {
                return false;
            }
            Long this$registerPeriodSec = this.getRegisterPeriodSec();
            Long other$registerPeriodSec = other.getRegisterPeriodSec();
            if (this$registerPeriodSec == null ? other$registerPeriodSec != null : !((Object)this$registerPeriodSec).equals(other$registerPeriodSec)) {
                return false;
            }
            String this$planEndpoint = this.getPlanEndpoint();
            String other$planEndpoint = other.getPlanEndpoint();
            if (this$planEndpoint == null ? other$planEndpoint != null : !this$planEndpoint.equals(other$planEndpoint)) {
                return false;
            }
            String this$registerEndpoint = this.getRegisterEndpoint();
            String other$registerEndpoint = other.getRegisterEndpoint();
            if (this$registerEndpoint == null ? other$registerEndpoint != null : !this$registerEndpoint.equals(other$registerEndpoint)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlannerProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timeoutMs = this.getTimeoutMs();
            result = result * 59 + ($timeoutMs == null ? 43 : ((Object)$timeoutMs).hashCode());
            Long $registerPeriodSec = this.getRegisterPeriodSec();
            result = result * 59 + ($registerPeriodSec == null ? 43 : ((Object)$registerPeriodSec).hashCode());
            String $planEndpoint = this.getPlanEndpoint();
            result = result * 59 + ($planEndpoint == null ? 43 : $planEndpoint.hashCode());
            String $registerEndpoint = this.getRegisterEndpoint();
            result = result * 59 + ($registerEndpoint == null ? 43 : $registerEndpoint.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "DealsConfiguration.PlannerProperties(planEndpoint=" + this.getPlanEndpoint() + ", registerEndpoint=" + this.getRegisterEndpoint() + ", timeoutMs=" + this.getTimeoutMs() + ", registerPeriodSec=" + this.getRegisterPeriodSec() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }

    @Validated
    private static class DeploymentProperties {
        @NotBlank
        private String hostId;
        @NotBlank
        private String datacenterRegion;
        @NotBlank
        private String vendor;
        @NotBlank
        private String profile;
        @NotBlank
        private String infra;
        @NotBlank
        private String dataCenter;
        @NotBlank
        private String system;
        @NotBlank
        private String subSystem;

        public org.prebid.server.deals.model.DeploymentProperties toComponentProperties() {
            return org.prebid.server.deals.model.DeploymentProperties.builder().pbsHostId(this.getHostId()).pbsRegion(this.getDatacenterRegion()).pbsVendor(this.getVendor()).profile(this.getProfile()).infra(this.getInfra()).dataCenter(this.getDataCenter()).system(this.getSystem()).subSystem(this.getSubSystem()).build();
        }

        public String getHostId() {
            return this.hostId;
        }

        public String getDatacenterRegion() {
            return this.datacenterRegion;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getInfra() {
            return this.infra;
        }

        public String getDataCenter() {
            return this.dataCenter;
        }

        public String getSystem() {
            return this.system;
        }

        public String getSubSystem() {
            return this.subSystem;
        }

        public void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public void setDatacenterRegion(String datacenterRegion) {
            this.datacenterRegion = datacenterRegion;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public void setProfile(String profile) {
            this.profile = profile;
        }

        public void setInfra(String infra) {
            this.infra = infra;
        }

        public void setDataCenter(String dataCenter) {
            this.dataCenter = dataCenter;
        }

        public void setSystem(String system) {
            this.system = system;
        }

        public void setSubSystem(String subSystem) {
            this.subSystem = subSystem;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeploymentProperties)) {
                return false;
            }
            DeploymentProperties other = (DeploymentProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hostId = this.getHostId();
            String other$hostId = other.getHostId();
            if (this$hostId == null ? other$hostId != null : !this$hostId.equals(other$hostId)) {
                return false;
            }
            String this$datacenterRegion = this.getDatacenterRegion();
            String other$datacenterRegion = other.getDatacenterRegion();
            if (this$datacenterRegion == null ? other$datacenterRegion != null : !this$datacenterRegion.equals(other$datacenterRegion)) {
                return false;
            }
            String this$vendor = this.getVendor();
            String other$vendor = other.getVendor();
            if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
                return false;
            }
            String this$profile = this.getProfile();
            String other$profile = other.getProfile();
            if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
                return false;
            }
            String this$infra = this.getInfra();
            String other$infra = other.getInfra();
            if (this$infra == null ? other$infra != null : !this$infra.equals(other$infra)) {
                return false;
            }
            String this$dataCenter = this.getDataCenter();
            String other$dataCenter = other.getDataCenter();
            if (this$dataCenter == null ? other$dataCenter != null : !this$dataCenter.equals(other$dataCenter)) {
                return false;
            }
            String this$system = this.getSystem();
            String other$system = other.getSystem();
            if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
                return false;
            }
            String this$subSystem = this.getSubSystem();
            String other$subSystem = other.getSubSystem();
            return !(this$subSystem == null ? other$subSystem != null : !this$subSystem.equals(other$subSystem));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeploymentProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostId = this.getHostId();
            result = result * 59 + ($hostId == null ? 43 : $hostId.hashCode());
            String $datacenterRegion = this.getDatacenterRegion();
            result = result * 59 + ($datacenterRegion == null ? 43 : $datacenterRegion.hashCode());
            String $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            String $profile = this.getProfile();
            result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
            String $infra = this.getInfra();
            result = result * 59 + ($infra == null ? 43 : $infra.hashCode());
            String $dataCenter = this.getDataCenter();
            result = result * 59 + ($dataCenter == null ? 43 : $dataCenter.hashCode());
            String $system = this.getSystem();
            result = result * 59 + ($system == null ? 43 : $system.hashCode());
            String $subSystem = this.getSubSystem();
            result = result * 59 + ($subSystem == null ? 43 : $subSystem.hashCode());
            return result;
        }

        public String toString() {
            return "DealsConfiguration.DeploymentProperties(hostId=" + this.getHostId() + ", datacenterRegion=" + this.getDatacenterRegion() + ", vendor=" + this.getVendor() + ", profile=" + this.getProfile() + ", infra=" + this.getInfra() + ", dataCenter=" + this.getDataCenter() + ", system=" + this.getSystem() + ", subSystem=" + this.getSubSystem() + ")";
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${deals.enabled} == true")
    public static class DealsMainConfiguration {
        @Bean
        @ConfigurationProperties
        DeploymentProperties deploymentProperties() {
            return new DeploymentProperties();
        }

        @Bean
        @ConfigurationProperties(prefix="deals.planner")
        PlannerProperties plannerProperties() {
            return new PlannerProperties();
        }

        @Bean
        @ConfigurationProperties(prefix="deals.delivery-stats")
        DeliveryStatsProperties deliveryStatsProperties() {
            return new DeliveryStatsProperties();
        }

        @Bean
        @ConfigurationProperties(prefix="deals.delivery-progress")
        DeliveryProgressProperties deliveryProgressProperties() {
            return new DeliveryProgressProperties();
        }

        @Bean
        @ConfigurationProperties(prefix="deals.user-data")
        UserDetailsProperties userDetailsProperties() {
            return new UserDetailsProperties();
        }

        @Bean
        @ConfigurationProperties(prefix="deals.alert-proxy")
        AlertProxyProperties alertProxyProperties() {
            return new AlertProxyProperties();
        }

        @Bean
        @ConfigurationProperties(prefix="deals.simulation")
        SimulationProperties simulationProperties() {
            return new SimulationProperties();
        }

        @Bean
        BidderRequestCompletionTrackerFactory bidderRequestCompletionTrackerFactory() {
            return new DealsBidderRequestCompletionTrackerFactory();
        }

        @Bean
        UserAdditionalInfoService userAdditionalInfoService(LineItemService lineItemService, @Autowired(required=false) DeviceInfoService deviceInfoService, @Autowired(required=false) GeoLocationService geoLocationService, UserService userService, Clock clock, JacksonMapper mapper, CriteriaLogManager criteriaLogManager) {
            return new UserAdditionalInfoService(lineItemService, deviceInfoService, geoLocationService, userService, clock, mapper, criteriaLogManager);
        }

        @Bean
        DealsService dealsService(LineItemService lineItemService, JacksonMapper mapper, CriteriaLogManager criteriaLogManager) {
            return new DealsService(lineItemService, mapper, criteriaLogManager);
        }

        @Bean
        DeliveryProgressReportFactory deliveryProgressReportFactory(DeploymentProperties deploymentProperties, @Value(value="${deals.delivery-progress-report.competitors-number}") int competitorsNumber, LineItemService lineItemService) {
            return new DeliveryProgressReportFactory(deploymentProperties.toComponentProperties(), competitorsNumber, lineItemService);
        }

        @Bean
        AlertHttpService alertHttpService(JacksonMapper mapper, HttpClient httpClient, Clock clock, DeploymentProperties deploymentProperties, AlertProxyProperties alertProxyProperties) {
            return new AlertHttpService(mapper, httpClient, clock, deploymentProperties.toComponentProperties(), alertProxyProperties.toComponentProperties());
        }

        @Bean
        TargetingService targetingService(JacksonMapper mapper) {
            return new TargetingService(mapper);
        }

        @Bean
        AdminCentralService adminCentralService(CriteriaManager criteriaManager, LineItemService lineItemService, DeliveryProgressService deliveryProgressService, @Autowired(required=false) @Qualifier(value="settingsCache") SettingsCache settingsCache, @Autowired(required=false) @Qualifier(value="ampSettingsCache") SettingsCache ampSettingsCache, @Autowired(required=false) CachingApplicationSettings cachingApplicationSettings, JacksonMapper mapper, List<Suspendable> suspendables) {
            return new AdminCentralService(criteriaManager, lineItemService, deliveryProgressService, settingsCache, ampSettingsCache, cachingApplicationSettings, mapper, suspendables);
        }

        @Bean
        ApplicationEventService applicationEventService(EventBus eventBus) {
            return new ApplicationEventService(eventBus);
        }

        @Bean
        AdminEventService adminEventService(EventBus eventBus) {
            return new AdminEventService(eventBus);
        }

        @Bean
        EventServiceInitializer eventServiceInitializer(List<ApplicationEventProcessor> applicationEventProcessors, List<AdminEventProcessor> adminEventProcessors, EventBus eventBus) {
            return new EventServiceInitializer(applicationEventProcessors, adminEventProcessors, eventBus);
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${deals.enabled} == true and ${deals.simulation.enabled} == true")
    public static class SimulationConfiguration {
        @Bean
        @ConditionalOnProperty(prefix="deals", name={"call-real-bidders-in-simulation"}, havingValue="false", matchIfMissing=true)
        SimulationAwareHttpBidderRequester simulationAwareHttpBidderRequester(HttpClient httpClient, BidderRequestCompletionTrackerFactory completionTrackerFactory, BidderErrorNotifier bidderErrorNotifier, HttpBidderRequestEnricher requestEnricher, LineItemService lineItemService, JacksonMapper mapper) {
            return new SimulationAwareHttpBidderRequester(httpClient, completionTrackerFactory, bidderErrorNotifier, requestEnricher, lineItemService, mapper);
        }

        @Bean
        SimulationAwarePlannerService plannerService(PlannerProperties plannerProperties, DeploymentProperties deploymentProperties, DeliveryProgressService deliveryProgressService, SimulationAwareLineItemService lineItemService, AlertHttpService alertHttpService, HttpClient httpClient, Metrics metrics, Clock clock, JacksonMapper mapper) {
            return new SimulationAwarePlannerService(plannerProperties.toComponentProperties(), deploymentProperties.toComponentProperties(), lineItemService, deliveryProgressService, alertHttpService, httpClient, metrics, clock, mapper);
        }

        @Bean
        SimulationAwareRegisterService registerService(PlannerProperties plannerProperties, DeploymentProperties deploymentProperties, AdminEventService adminEventService, DeliveryProgressService deliveryProgressService, AlertHttpService alertHttpService, HealthMonitor healthMonitor, CurrencyConversionService currencyConversionService, HttpClient httpClient, Vertx vertx, JacksonMapper mapper) {
            return new SimulationAwareRegisterService(plannerProperties.toComponentProperties(), deploymentProperties.toComponentProperties(), adminEventService, deliveryProgressService, alertHttpService, healthMonitor, currencyConversionService, httpClient, vertx, mapper);
        }

        @Bean
        SimulationAwareDeliveryStatsService deliveryStatsService(DeliveryStatsProperties deliveryStatsProperties, DeliveryProgressReportFactory deliveryProgressReportFactory, AlertHttpService alertHttpService, HttpClient httpClient, Metrics metrics, Clock clock, Vertx vertx, JacksonMapper mapper) {
            return new SimulationAwareDeliveryStatsService(deliveryStatsProperties.toComponentProperties(), deliveryProgressReportFactory, alertHttpService, httpClient, metrics, clock, vertx, mapper);
        }

        @Bean
        SimulationAwareLineItemService lineItemService(@Value(value="${deals.max-deals-per-bidder}") int maxDealsPerBidder, TargetingService targetingService, CurrencyConversionService conversionService, ApplicationEventService applicationEventService, @Value(value="${auction.ad-server-currency}") String adServerCurrency, Clock clock, CriteriaLogManager criteriaLogManager) {
            return new SimulationAwareLineItemService(maxDealsPerBidder, targetingService, conversionService, applicationEventService, adServerCurrency, clock, criteriaLogManager);
        }

        @Bean
        SimulationAwareDeliveryProgressService deliveryProgressService(DeliveryProgressProperties deliveryProgressProperties, LineItemService lineItemService, DeliveryStatsService deliveryStatsService, DeliveryProgressReportFactory deliveryProgressReportFactory, @Value(value="${deals.simulation.ready-at-adjustment-ms}") long readyAtAdjustment, Clock clock, CriteriaLogManager criteriaLogManager) {
            return new SimulationAwareDeliveryProgressService(deliveryProgressProperties.toComponentProperties(), lineItemService, deliveryStatsService, deliveryProgressReportFactory, readyAtAdjustment, clock, criteriaLogManager);
        }

        @Bean
        SimulationAwareUserService userService(UserDetailsProperties userDetailsProperties, SimulationProperties simulationProperties, @Value(value="${datacenter-region}") String dataCenterRegion, LineItemService lineItemService, HttpClient httpClient, Clock clock, Metrics metrics, JacksonMapper mapper) {
            return new SimulationAwareUserService(userDetailsProperties.toComponentProperties(), simulationProperties.toComponentProperties(), dataCenterRegion, lineItemService, httpClient, clock, metrics, mapper);
        }

        @Bean
        DealsSimulationAdminHandler dealsSimulationAdminHandler(SimulationAwareRegisterService registerService, SimulationAwarePlannerService plannerService, SimulationAwareDeliveryProgressService deliveryProgressService, SimulationAwareDeliveryStatsService deliveryStatsService, @Autowired(required=false) SimulationAwareHttpBidderRequester httpBidderRequester, JacksonMapper mapper, @Value(value="${admin-endpoints.e2eadmin.path}") String path) {
            return new DealsSimulationAdminHandler(registerService, plannerService, deliveryProgressService, deliveryStatsService, httpBidderRequester, mapper, path);
        }

        @Bean
        BeanPostProcessor simulationCustomizationBeanPostProcessor(final @Autowired(required=false) SimulationAwareHttpBidderRequester httpBidderRequester) {
            return new BeanPostProcessor(){

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    if (httpBidderRequester != null && bean.getClass().isAssignableFrom(HttpBidderRequester.class) && !(bean instanceof SimulationAwareHttpBidderRequester)) {
                        return httpBidderRequester;
                    }
                    return bean;
                }
            };
        }
    }

    private static class DeliveryScheduler {
        private final DeliveryProgressService deliveryProgressService;
        private final DeliveryStatsService deliveryStatsService;
        private final Clock clock;
        private final ContextRunner contextRunner;

        DeliveryScheduler(DeliveryProgressService deliveryProgressService, DeliveryStatsService deliveryStatsService, Clock clock, ContextRunner contextRunner) {
            this.deliveryProgressService = deliveryProgressService;
            this.deliveryStatsService = deliveryStatsService;
            this.clock = clock;
            this.contextRunner = contextRunner;
        }

        @Scheduled(cron="${deals.delivery-progress.report-reset-period}")
        public void createDeliveryReport() {
            this.contextRunner.runOnServiceContext(future -> {
                this.deliveryProgressService.createDeliveryProgressReports(ZonedDateTime.now(this.clock));
                future.complete();
            });
        }

        @Scheduled(cron="${deals.delivery-stats.delivery-period}")
        public void sendDeliveryReport() {
            this.contextRunner.runOnServiceContext(future -> {
                this.deliveryStatsService.sendDeliveryProgressReports(ZonedDateTime.now(this.clock));
                future.complete();
            });
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${deals.enabled} == true and ${deals.simulation.enabled} == false")
    @EnableScheduling
    public static class SchedulerConfiguration {
        @Bean
        GeneralPlannerScheduler generalPlannerScheduler(PlannerService plannerService, ContextRunner contextRunner) {
            return new GeneralPlannerScheduler(plannerService, contextRunner);
        }

        @Bean
        @ConditionalOnExpression(value="'${deals.delivery-stats.delivery-period}'.equals('${deals.delivery-progress.report-reset-period}')")
        ImmediateDeliveryScheduler immediateDeliveryScheduler(DeliveryProgressService deliveryProgressService, DeliveryStatsService deliveryStatsService, Clock clock, ContextRunner contextRunner) {
            return new ImmediateDeliveryScheduler(deliveryProgressService, deliveryStatsService, clock, contextRunner);
        }

        @Bean
        @ConditionalOnExpression(value="not '${deals.delivery-stats.delivery-period}'.equals('${deals.delivery-progress.report-reset-period}')")
        DeliveryScheduler deliveryScheduler(DeliveryProgressService deliveryProgressService, DeliveryStatsService deliveryStatsService, Clock clock, ContextRunner contextRunner) {
            return new DeliveryScheduler(deliveryProgressService, deliveryStatsService, clock, contextRunner);
        }

        @Bean
        AdvancePlansScheduler advancePlansScheduler(LineItemService lineItemService, ContextRunner contextRunner, Clock clock) {
            return new AdvancePlansScheduler(lineItemService, contextRunner, clock);
        }

        private static class GeneralPlannerScheduler {
            private final PlannerService plannerService;
            private final ContextRunner contextRunner;

            GeneralPlannerScheduler(PlannerService plannerService, ContextRunner contextRunner) {
                this.plannerService = plannerService;
                this.contextRunner = contextRunner;
            }

            @Scheduled(cron="${deals.planner.update-period}")
            public void fetchPlansFromGeneralPlanner() {
                this.contextRunner.runOnServiceContext(future -> {
                    this.plannerService.updateLineItemMetaData();
                    future.complete();
                });
            }
        }

        private static class ImmediateDeliveryScheduler {
            private final DeliveryProgressService deliveryProgressService;
            private final DeliveryStatsService deliveryStatsService;
            private final Clock clock;
            private final ContextRunner contextRunner;

            ImmediateDeliveryScheduler(DeliveryProgressService deliveryProgressService, DeliveryStatsService deliveryStatsService, Clock clock, ContextRunner contextRunner) {
                this.deliveryProgressService = deliveryProgressService;
                this.deliveryStatsService = deliveryStatsService;
                this.clock = clock;
                this.contextRunner = contextRunner;
            }

            @Scheduled(cron="${deals.delivery-stats.delivery-period}")
            public void createAndSendDeliveryReport() {
                this.contextRunner.runOnServiceContext(future -> {
                    ZonedDateTime now = ZonedDateTime.now(this.clock);
                    this.deliveryProgressService.createDeliveryProgressReports(now);
                    this.deliveryStatsService.sendDeliveryProgressReports(now);
                    future.complete();
                });
            }
        }

        private static class AdvancePlansScheduler {
            private final LineItemService lineItemService;
            private final ContextRunner contextRunner;
            private final Clock clock;

            AdvancePlansScheduler(LineItemService lineItemService, ContextRunner contextRunner, Clock clock) {
                this.lineItemService = lineItemService;
                this.contextRunner = contextRunner;
                this.clock = clock;
            }

            @Scheduled(cron="${deals.planner.plan-advance-period}")
            public void advancePlans() {
                this.contextRunner.runOnServiceContext(future -> {
                    this.lineItemService.advanceToNextPlan(ZonedDateTime.now(this.clock));
                    future.complete();
                });
            }
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${deals.enabled} == true and ${deals.simulation.enabled} == false")
    public static class ProductionConfiguration {
        @Bean
        PlannerService plannerService(PlannerProperties plannerProperties, DeploymentProperties deploymentProperties, DeliveryProgressService deliveryProgressService, LineItemService lineItemService, AlertHttpService alertHttpService, HttpClient httpClient, Metrics metrics, Clock clock, JacksonMapper mapper) {
            return new PlannerService(plannerProperties.toComponentProperties(), deploymentProperties.toComponentProperties(), lineItemService, deliveryProgressService, alertHttpService, httpClient, metrics, clock, mapper);
        }

        @Bean
        RegisterService registerService(PlannerProperties plannerProperties, DeploymentProperties deploymentProperties, AdminEventService adminEventService, DeliveryProgressService deliveryProgressService, AlertHttpService alertHttpService, HealthMonitor healthMonitor, CurrencyConversionService currencyConversionService, HttpClient httpClient, Vertx vertx, JacksonMapper mapper) {
            return new RegisterService(plannerProperties.toComponentProperties(), deploymentProperties.toComponentProperties(), adminEventService, deliveryProgressService, alertHttpService, healthMonitor, currencyConversionService, httpClient, vertx, mapper);
        }

        @Bean
        DeliveryStatsService deliveryStatsService(DeliveryStatsProperties deliveryStatsProperties, DeliveryProgressReportFactory deliveryProgressReportFactory, AlertHttpService alertHttpService, HttpClient httpClient, Metrics metrics, Clock clock, Vertx vertx, JacksonMapper mapper) {
            return new DeliveryStatsService(deliveryStatsProperties.toComponentProperties(), deliveryProgressReportFactory, alertHttpService, httpClient, metrics, clock, vertx, mapper);
        }

        @Bean
        LineItemService lineItemService(@Value(value="${deals.max-deals-per-bidder}") int maxDealsPerBidder, TargetingService targetingService, CurrencyConversionService conversionService, ApplicationEventService applicationEventService, @Value(value="${auction.ad-server-currency}") String adServerCurrency, Clock clock, CriteriaLogManager criteriaLogManager) {
            return new LineItemService(maxDealsPerBidder, targetingService, conversionService, applicationEventService, adServerCurrency, clock, criteriaLogManager);
        }

        @Bean
        DeliveryProgressService deliveryProgressService(DeliveryProgressProperties deliveryProgressProperties, LineItemService lineItemService, DeliveryStatsService deliveryStatsService, DeliveryProgressReportFactory deliveryProgressReportFactory, Clock clock, CriteriaLogManager criteriaLogManager) {
            return new DeliveryProgressService(deliveryProgressProperties.toComponentProperties(), lineItemService, deliveryStatsService, deliveryProgressReportFactory, clock, criteriaLogManager);
        }

        @Bean
        UserService userService(UserDetailsProperties userDetailsProperties, @Value(value="${datacenter-region}") String dataCenterRegion, LineItemService lineItemService, HttpClient httpClient, Clock clock, Metrics metrics, JacksonMapper mapper) {
            return new UserService(userDetailsProperties.toComponentProperties(), dataCenterRegion, lineItemService, httpClient, clock, metrics, mapper);
        }
    }
}

