/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import java.util.List;
import org.prebid.server.activity.infrastructure.creator.ActivityInfrastructureCreator;
import org.prebid.server.activity.infrastructure.creator.ActivityRuleFactory;
import org.prebid.server.activity.infrastructure.creator.privacy.PrivacyModuleCreator;
import org.prebid.server.activity.infrastructure.creator.privacy.uscustomlogic.USCustomLogicGppReaderFactory;
import org.prebid.server.activity.infrastructure.creator.privacy.uscustomlogic.USCustomLogicModuleCreator;
import org.prebid.server.activity.infrastructure.creator.privacy.usnat.USNatGppReaderFactory;
import org.prebid.server.activity.infrastructure.creator.privacy.usnat.USNatModuleCreator;
import org.prebid.server.activity.infrastructure.creator.rule.ComponentRuleCreator;
import org.prebid.server.activity.infrastructure.creator.rule.GeoRuleCreator;
import org.prebid.server.activity.infrastructure.creator.rule.PrivacyModulesRuleCreator;
import org.prebid.server.activity.infrastructure.creator.rule.RuleCreator;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.json.JsonLogic;
import org.prebid.server.metric.Metrics;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ActivityInfrastructureConfiguration {
    @Bean
    ActivityRuleFactory activityRuleFactory(List<RuleCreator<?>> ruleCreators) {
        return new ActivityRuleFactory(ruleCreators);
    }

    @Bean
    ActivityInfrastructureCreator activityInfrastructureCreator(ActivityRuleFactory activityRuleFactory, Metrics metrics, JacksonMapper jacksonMapper) {
        return new ActivityInfrastructureCreator(activityRuleFactory, metrics, jacksonMapper);
    }

    @Configuration
    static class RuleCreatorConfiguration {
        RuleCreatorConfiguration() {
        }

        @Bean
        ComponentRuleCreator componentRuleCreator() {
            return new ComponentRuleCreator();
        }

        @Bean
        GeoRuleCreator geoRuleCreator() {
            return new GeoRuleCreator();
        }

        @Bean
        PrivacyModulesRuleCreator privacyModulesRuleCreator(List<PrivacyModuleCreator> privacyModuleCreators) {
            return new PrivacyModulesRuleCreator(privacyModuleCreators);
        }
    }

    @Configuration
    static class PrivacyModuleCreatorConfiguration {
        PrivacyModuleCreatorConfiguration() {
        }

        @Configuration
        static class USCustomLogicModuleCreatorConfiguration {
            USCustomLogicModuleCreatorConfiguration() {
            }

            @Bean
            USCustomLogicGppReaderFactory usCustomLogicGppReaderFactory() {
                return new USCustomLogicGppReaderFactory();
            }

            @Bean
            USCustomLogicModuleCreator usCustomLogicModuleCreator(USCustomLogicGppReaderFactory gppReaderFactory, JsonLogic jsonLogic, @Value(value="${settings.in-memory-cache.ttl-seconds:#{null}}") Integer ttlSeconds, @Value(value="${settings.in-memory-cache.cache-size:#{null}}") Integer cacheSize, Metrics metrics) {
                return new USCustomLogicModuleCreator(gppReaderFactory, jsonLogic, ttlSeconds, cacheSize, metrics);
            }
        }

        @Configuration
        static class USNatModuleCreatorConfiguration {
            USNatModuleCreatorConfiguration() {
            }

            @Bean
            USNatGppReaderFactory usNatGppReaderFactory() {
                return new USNatGppReaderFactory();
            }

            @Bean
            USNatModuleCreator usNatModuleCreator(USNatGppReaderFactory gppReaderFactory) {
                return new USNatModuleCreator(gppReaderFactory);
            }
        }
    }
}

