/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.prebid.server.settings.model.AccountAuctionEventConfig;

public final class AccountAnalyticsConfig {
    private static final Map<String, Boolean> FALLBACK_AUCTION_EVENTS = Map.of("web", false, "amp", true, "app", true);
    @JsonProperty(value="auction-events")
    private final AccountAuctionEventConfig auctionEvents;
    private final Map<String, ObjectNode> modules;

    public static Map<String, Boolean> fallbackAuctionEvents() {
        return FALLBACK_AUCTION_EVENTS;
    }

    @ConstructorProperties(value={"auctionEvents", "modules"})
    private AccountAnalyticsConfig(AccountAuctionEventConfig auctionEvents, Map<String, ObjectNode> modules) {
        this.auctionEvents = auctionEvents;
        this.modules = modules;
    }

    public static AccountAnalyticsConfig of(AccountAuctionEventConfig auctionEvents, Map<String, ObjectNode> modules) {
        return new AccountAnalyticsConfig(auctionEvents, modules);
    }

    public AccountAuctionEventConfig getAuctionEvents() {
        return this.auctionEvents;
    }

    public Map<String, ObjectNode> getModules() {
        return this.modules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAnalyticsConfig)) {
            return false;
        }
        AccountAnalyticsConfig other = (AccountAnalyticsConfig)o;
        AccountAuctionEventConfig this$auctionEvents = this.getAuctionEvents();
        AccountAuctionEventConfig other$auctionEvents = other.getAuctionEvents();
        if (this$auctionEvents == null ? other$auctionEvents != null : !((Object)this$auctionEvents).equals(other$auctionEvents)) {
            return false;
        }
        Map<String, ObjectNode> this$modules = this.getModules();
        Map<String, ObjectNode> other$modules = other.getModules();
        return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountAuctionEventConfig $auctionEvents = this.getAuctionEvents();
        result = result * 59 + ($auctionEvents == null ? 43 : ((Object)$auctionEvents).hashCode());
        Map<String, ObjectNode> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        return result;
    }

    public String toString() {
        return "AccountAnalyticsConfig(auctionEvents=" + this.getAuctionEvents() + ", modules=" + this.getModules() + ")";
    }
}

