/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import org.prebid.server.settings.model.AccountAnalyticsConfig;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountCookieSyncConfig;
import org.prebid.server.settings.model.AccountHooksConfiguration;
import org.prebid.server.settings.model.AccountMetricsConfig;
import org.prebid.server.settings.model.AccountPrivacyConfig;
import org.prebid.server.settings.model.AccountStatus;

public final class Account {
    private final String id;
    private final AccountStatus status;
    private final AccountAuctionConfig auction;
    private final AccountPrivacyConfig privacy;
    private final AccountAnalyticsConfig analytics;
    private final AccountMetricsConfig metrics;
    @JsonProperty(value="cookie-sync")
    private final AccountCookieSyncConfig cookieSync;
    private final AccountHooksConfiguration hooks;

    public static Account empty(String id) {
        return Account.builder().id(id).build();
    }

    @ConstructorProperties(value={"id", "status", "auction", "privacy", "analytics", "metrics", "cookieSync", "hooks"})
    Account(String id, AccountStatus status, AccountAuctionConfig auction, AccountPrivacyConfig privacy, AccountAnalyticsConfig analytics, AccountMetricsConfig metrics, AccountCookieSyncConfig cookieSync, AccountHooksConfiguration hooks) {
        this.id = id;
        this.status = status;
        this.auction = auction;
        this.privacy = privacy;
        this.analytics = analytics;
        this.metrics = metrics;
        this.cookieSync = cookieSync;
        this.hooks = hooks;
    }

    public static AccountBuilder builder() {
        return new AccountBuilder();
    }

    public AccountBuilder toBuilder() {
        return new AccountBuilder().id(this.id).status(this.status).auction(this.auction).privacy(this.privacy).analytics(this.analytics).metrics(this.metrics).cookieSync(this.cookieSync).hooks(this.hooks);
    }

    public String getId() {
        return this.id;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public AccountAuctionConfig getAuction() {
        return this.auction;
    }

    public AccountPrivacyConfig getPrivacy() {
        return this.privacy;
    }

    public AccountAnalyticsConfig getAnalytics() {
        return this.analytics;
    }

    public AccountMetricsConfig getMetrics() {
        return this.metrics;
    }

    public AccountCookieSyncConfig getCookieSync() {
        return this.cookieSync;
    }

    public AccountHooksConfiguration getHooks() {
        return this.hooks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        AccountStatus this$status = this.getStatus();
        AccountStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        AccountAuctionConfig this$auction = this.getAuction();
        AccountAuctionConfig other$auction = other.getAuction();
        if (this$auction == null ? other$auction != null : !((Object)this$auction).equals(other$auction)) {
            return false;
        }
        AccountPrivacyConfig this$privacy = this.getPrivacy();
        AccountPrivacyConfig other$privacy = other.getPrivacy();
        if (this$privacy == null ? other$privacy != null : !((Object)this$privacy).equals(other$privacy)) {
            return false;
        }
        AccountAnalyticsConfig this$analytics = this.getAnalytics();
        AccountAnalyticsConfig other$analytics = other.getAnalytics();
        if (this$analytics == null ? other$analytics != null : !((Object)this$analytics).equals(other$analytics)) {
            return false;
        }
        AccountMetricsConfig this$metrics = this.getMetrics();
        AccountMetricsConfig other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        AccountCookieSyncConfig this$cookieSync = this.getCookieSync();
        AccountCookieSyncConfig other$cookieSync = other.getCookieSync();
        if (this$cookieSync == null ? other$cookieSync != null : !((Object)this$cookieSync).equals(other$cookieSync)) {
            return false;
        }
        AccountHooksConfiguration this$hooks = this.getHooks();
        AccountHooksConfiguration other$hooks = other.getHooks();
        return !(this$hooks == null ? other$hooks != null : !((Object)this$hooks).equals(other$hooks));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        AccountStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        AccountAuctionConfig $auction = this.getAuction();
        result = result * 59 + ($auction == null ? 43 : ((Object)$auction).hashCode());
        AccountPrivacyConfig $privacy = this.getPrivacy();
        result = result * 59 + ($privacy == null ? 43 : ((Object)$privacy).hashCode());
        AccountAnalyticsConfig $analytics = this.getAnalytics();
        result = result * 59 + ($analytics == null ? 43 : ((Object)$analytics).hashCode());
        AccountMetricsConfig $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        AccountCookieSyncConfig $cookieSync = this.getCookieSync();
        result = result * 59 + ($cookieSync == null ? 43 : ((Object)$cookieSync).hashCode());
        AccountHooksConfiguration $hooks = this.getHooks();
        result = result * 59 + ($hooks == null ? 43 : ((Object)$hooks).hashCode());
        return result;
    }

    public String toString() {
        return "Account(id=" + this.getId() + ", status=" + this.getStatus() + ", auction=" + this.getAuction() + ", privacy=" + this.getPrivacy() + ", analytics=" + this.getAnalytics() + ", metrics=" + this.getMetrics() + ", cookieSync=" + this.getCookieSync() + ", hooks=" + this.getHooks() + ")";
    }

    public static class AccountBuilder {
        private String id;
        private AccountStatus status;
        private AccountAuctionConfig auction;
        private AccountPrivacyConfig privacy;
        private AccountAnalyticsConfig analytics;
        private AccountMetricsConfig metrics;
        private AccountCookieSyncConfig cookieSync;
        private AccountHooksConfiguration hooks;

        AccountBuilder() {
        }

        public AccountBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AccountBuilder status(AccountStatus status) {
            this.status = status;
            return this;
        }

        public AccountBuilder auction(AccountAuctionConfig auction) {
            this.auction = auction;
            return this;
        }

        public AccountBuilder privacy(AccountPrivacyConfig privacy) {
            this.privacy = privacy;
            return this;
        }

        public AccountBuilder analytics(AccountAnalyticsConfig analytics) {
            this.analytics = analytics;
            return this;
        }

        public AccountBuilder metrics(AccountMetricsConfig metrics) {
            this.metrics = metrics;
            return this;
        }

        @JsonProperty(value="cookie-sync")
        public AccountBuilder cookieSync(AccountCookieSyncConfig cookieSync) {
            this.cookieSync = cookieSync;
            return this;
        }

        public AccountBuilder hooks(AccountHooksConfiguration hooks) {
            this.hooks = hooks;
            return this;
        }

        public Account build() {
            return new Account(this.id, this.status, this.auction, this.privacy, this.analytics, this.metrics, this.cookieSync, this.hooks);
        }

        public String toString() {
            return "Account.AccountBuilder(id=" + this.id + ", status=" + this.status + ", auction=" + this.auction + ", privacy=" + this.privacy + ", analytics=" + this.analytics + ", metrics=" + this.metrics + ", cookieSync=" + this.cookieSync + ", hooks=" + this.hooks + ")";
        }
    }
}

