/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings;

import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.SettingsCache;
import org.prebid.server.settings.helper.StoredDataFetcher;
import org.prebid.server.settings.helper.StoredItemResolver;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.settings.model.StoredItem;
import org.prebid.server.settings.model.StoredResponseDataResult;

public class CachingApplicationSettings
implements ApplicationSettings {
    private static final Logger logger = LoggerFactory.getLogger(CachingApplicationSettings.class);
    private final ApplicationSettings delegate;
    private final Map<String, Account> accountCache;
    private final Map<String, String> accountToErrorCache;
    private final Map<String, String> adServerPublisherToErrorCache;
    private final Map<String, Map<String, String>> categoryConfigCache;
    private final SettingsCache cache;
    private final SettingsCache ampCache;
    private final SettingsCache videoCache;
    private final Metrics metrics;

    public CachingApplicationSettings(ApplicationSettings delegate, SettingsCache cache, SettingsCache ampCache, SettingsCache videoCache, Metrics metrics, int ttl, int size) {
        if (ttl <= 0 || size <= 0) {
            throw new IllegalArgumentException("ttl and size must be positive");
        }
        this.delegate = Objects.requireNonNull(delegate);
        this.accountCache = SettingsCache.createCache(ttl, size);
        this.accountToErrorCache = SettingsCache.createCache(ttl, size);
        this.adServerPublisherToErrorCache = SettingsCache.createCache(ttl, size);
        this.categoryConfigCache = SettingsCache.createCache(ttl, size);
        this.cache = Objects.requireNonNull(cache);
        this.ampCache = Objects.requireNonNull(ampCache);
        this.videoCache = Objects.requireNonNull(videoCache);
        this.metrics = Objects.requireNonNull(metrics);
    }

    @Override
    public Future<Account> getAccountById(String accountId, Timeout timeout) {
        return CachingApplicationSettings.getFromCacheOrDelegate(this.accountCache, this.accountToErrorCache, accountId, timeout, this.delegate::getAccountById, (MetricName event) -> this.metrics.updateSettingsCacheEventMetric(MetricName.account, (MetricName)((Object)event)));
    }

    @Override
    public Future<StoredDataResult> getStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return CachingApplicationSettings.getFromCacheOrDelegate(this.cache, accountId, requestIds, impIds, timeout, this.delegate::getStoredData);
    }

    @Override
    public Future<StoredDataResult> getAmpStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return CachingApplicationSettings.getFromCacheOrDelegate(this.ampCache, accountId, requestIds, impIds, timeout, this.delegate::getAmpStoredData);
    }

    @Override
    public Future<StoredDataResult> getVideoStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return CachingApplicationSettings.getFromCacheOrDelegate(this.videoCache, accountId, requestIds, impIds, timeout, this.delegate::getVideoStoredData);
    }

    @Override
    public Future<StoredResponseDataResult> getStoredResponses(Set<String> responseIds, Timeout timeout) {
        return this.delegate.getStoredResponses(responseIds, timeout);
    }

    @Override
    public Future<Map<String, String>> getCategories(String primaryAdServer, String publisher, Timeout timeout) {
        String compoundKey = StringUtils.isNotBlank((CharSequence)publisher) ? "%s_%s".formatted(primaryAdServer, publisher) : primaryAdServer;
        return CachingApplicationSettings.getFromCacheOrDelegate(this.categoryConfigCache, this.adServerPublisherToErrorCache, compoundKey, timeout, (String key, Timeout timeoutParam) -> this.delegate.getCategories(primaryAdServer, publisher, timeout), CachingApplicationSettings::noOp);
    }

    private static <T> Future<T> getFromCacheOrDelegate(Map<String, T> cache, Map<String, String> accountToErrorCache, String key, Timeout timeout, BiFunction<String, Timeout, Future<T>> retriever, Consumer<MetricName> metricUpdater) {
        T cachedValue = cache.get(key);
        if (cachedValue != null) {
            metricUpdater.accept(MetricName.hit);
            return Future.succeededFuture(cachedValue);
        }
        metricUpdater.accept(MetricName.miss);
        String preBidExceptionMessage = accountToErrorCache.get(key);
        if (preBidExceptionMessage != null) {
            return Future.failedFuture((Throwable)new PreBidException(preBidExceptionMessage));
        }
        return retriever.apply(key, timeout).map(value -> {
            cache.put(key, value);
            return value;
        }).recover(throwable -> CachingApplicationSettings.cacheAndReturnFailedFuture(throwable, key, accountToErrorCache));
    }

    private static Future<StoredDataResult> getFromCacheOrDelegate(SettingsCache cache, String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout, StoredDataFetcher<String, Set<String>, Set<String>, Timeout, Future<StoredDataResult>> retriever) {
        String normalizedAccountId = StringUtils.stripToNull((String)accountId);
        Map<String, Set<StoredItem>> requestCache = cache.getRequestCache();
        Map<String, Set<StoredItem>> impCache = cache.getImpCache();
        HashSet<String> missedRequestIds = new HashSet<String>();
        Map<String, String> storedIdToRequest = CachingApplicationSettings.getFromCacheOrAddMissedIds(normalizedAccountId, requestIds, requestCache, missedRequestIds);
        HashSet<String> missedImpIds = new HashSet<String>();
        Map<String, String> storedIdToImp = CachingApplicationSettings.getFromCacheOrAddMissedIds(normalizedAccountId, impIds, impCache, missedImpIds);
        if (missedRequestIds.isEmpty() && missedImpIds.isEmpty()) {
            return Future.succeededFuture((Object)StoredDataResult.of(storedIdToRequest, storedIdToImp, Collections.emptyList()));
        }
        return retriever.apply(normalizedAccountId, missedRequestIds, missedImpIds, timeout).map(result -> {
            Map<String, String> storedIdToRequestFromDelegate = result.getStoredIdToRequest();
            storedIdToRequest.putAll(storedIdToRequestFromDelegate);
            for (Map.Entry<String, String> entry : storedIdToRequestFromDelegate.entrySet()) {
                cache.saveRequestCache(normalizedAccountId, entry.getKey(), entry.getValue());
            }
            Map<String, String> storedIdToImpFromDelegate = result.getStoredIdToImp();
            storedIdToImp.putAll(storedIdToImpFromDelegate);
            for (Map.Entry<String, String> entry : storedIdToImpFromDelegate.entrySet()) {
                cache.saveImpCache(normalizedAccountId, entry.getKey(), entry.getValue());
            }
            return StoredDataResult.of(storedIdToRequest, storedIdToImp, result.getErrors());
        });
    }

    private static <T> Future<T> cacheAndReturnFailedFuture(Throwable throwable, String key, Map<String, String> cache) {
        if (throwable instanceof PreBidException) {
            cache.put(key, throwable.getMessage());
        }
        return Future.failedFuture((Throwable)throwable);
    }

    private static Map<String, String> getFromCacheOrAddMissedIds(String accountId, Set<String> ids, Map<String, Set<StoredItem>> cache, Set<String> missedIds) {
        HashMap<String, String> idToStoredItem = new HashMap<String, String>(ids.size());
        for (String id : ids) {
            try {
                StoredItem resolvedStoredItem = StoredItemResolver.resolve(null, accountId, id, cache.get(id));
                idToStoredItem.put(id, resolvedStoredItem.getData());
            }
            catch (PreBidException e) {
                missedIds.add(id);
            }
        }
        return idToStoredItem;
    }

    public void invalidateAccountCache(String accountId) {
        this.accountCache.remove(accountId);
        logger.debug((Object)"Account with id {0} was invalidated", new Object[]{accountId});
    }

    public void invalidateAllAccountCache() {
        this.accountCache.clear();
        logger.debug((Object)"All accounts cache were invalidated");
    }

    private static <ANY> void noOp(ANY any) {
    }
}

