/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.proto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import org.prebid.server.json.deserializer.CommaSeparatedStringAsListOfIntegersDeserializer;

public final class CookieSyncRequest {
    private final Set<String> bidders;
    private final Integer gdpr;
    private final String gdprConsent;
    private final String usPrivacy;
    private final String gpp;
    @JsonDeserialize(using=CommaSeparatedStringAsListOfIntegersDeserializer.class)
    private final List<Integer> gppSid;
    @JsonProperty(value="coopSync")
    private final Boolean coopSync;
    private final Boolean debug;
    private final Integer limit;
    private final String account;
    @JsonProperty(value="filterSettings")
    private final FilterSettings filterSettings;

    @ConstructorProperties(value={"bidders", "gdpr", "gdprConsent", "usPrivacy", "gpp", "gppSid", "coopSync", "debug", "limit", "account", "filterSettings"})
    CookieSyncRequest(Set<String> bidders, Integer gdpr, String gdprConsent, String usPrivacy, String gpp, List<Integer> gppSid, Boolean coopSync, Boolean debug, Integer limit, String account, FilterSettings filterSettings) {
        this.bidders = bidders;
        this.gdpr = gdpr;
        this.gdprConsent = gdprConsent;
        this.usPrivacy = usPrivacy;
        this.gpp = gpp;
        this.gppSid = gppSid;
        this.coopSync = coopSync;
        this.debug = debug;
        this.limit = limit;
        this.account = account;
        this.filterSettings = filterSettings;
    }

    public static CookieSyncRequestBuilder builder() {
        return new CookieSyncRequestBuilder();
    }

    public CookieSyncRequestBuilder toBuilder() {
        return new CookieSyncRequestBuilder().bidders(this.bidders).gdpr(this.gdpr).gdprConsent(this.gdprConsent).usPrivacy(this.usPrivacy).gpp(this.gpp).gppSid(this.gppSid).coopSync(this.coopSync).debug(this.debug).limit(this.limit).account(this.account).filterSettings(this.filterSettings);
    }

    public Set<String> getBidders() {
        return this.bidders;
    }

    public Integer getGdpr() {
        return this.gdpr;
    }

    public String getGdprConsent() {
        return this.gdprConsent;
    }

    public String getUsPrivacy() {
        return this.usPrivacy;
    }

    public String getGpp() {
        return this.gpp;
    }

    public List<Integer> getGppSid() {
        return this.gppSid;
    }

    public Boolean getCoopSync() {
        return this.coopSync;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getAccount() {
        return this.account;
    }

    public FilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CookieSyncRequest)) {
            return false;
        }
        CookieSyncRequest other = (CookieSyncRequest)o;
        Integer this$gdpr = this.getGdpr();
        Integer other$gdpr = other.getGdpr();
        if (this$gdpr == null ? other$gdpr != null : !((Object)this$gdpr).equals(other$gdpr)) {
            return false;
        }
        Boolean this$coopSync = this.getCoopSync();
        Boolean other$coopSync = other.getCoopSync();
        if (this$coopSync == null ? other$coopSync != null : !((Object)this$coopSync).equals(other$coopSync)) {
            return false;
        }
        Boolean this$debug = this.getDebug();
        Boolean other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !((Object)this$debug).equals(other$debug)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Set<String> this$bidders = this.getBidders();
        Set<String> other$bidders = other.getBidders();
        if (this$bidders == null ? other$bidders != null : !((Object)this$bidders).equals(other$bidders)) {
            return false;
        }
        String this$gdprConsent = this.getGdprConsent();
        String other$gdprConsent = other.getGdprConsent();
        if (this$gdprConsent == null ? other$gdprConsent != null : !this$gdprConsent.equals(other$gdprConsent)) {
            return false;
        }
        String this$usPrivacy = this.getUsPrivacy();
        String other$usPrivacy = other.getUsPrivacy();
        if (this$usPrivacy == null ? other$usPrivacy != null : !this$usPrivacy.equals(other$usPrivacy)) {
            return false;
        }
        String this$gpp = this.getGpp();
        String other$gpp = other.getGpp();
        if (this$gpp == null ? other$gpp != null : !this$gpp.equals(other$gpp)) {
            return false;
        }
        List<Integer> this$gppSid = this.getGppSid();
        List<Integer> other$gppSid = other.getGppSid();
        if (this$gppSid == null ? other$gppSid != null : !((Object)this$gppSid).equals(other$gppSid)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        FilterSettings this$filterSettings = this.getFilterSettings();
        FilterSettings other$filterSettings = other.getFilterSettings();
        return !(this$filterSettings == null ? other$filterSettings != null : !((Object)this$filterSettings).equals(other$filterSettings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $gdpr = this.getGdpr();
        result = result * 59 + ($gdpr == null ? 43 : ((Object)$gdpr).hashCode());
        Boolean $coopSync = this.getCoopSync();
        result = result * 59 + ($coopSync == null ? 43 : ((Object)$coopSync).hashCode());
        Boolean $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : ((Object)$debug).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Set<String> $bidders = this.getBidders();
        result = result * 59 + ($bidders == null ? 43 : ((Object)$bidders).hashCode());
        String $gdprConsent = this.getGdprConsent();
        result = result * 59 + ($gdprConsent == null ? 43 : $gdprConsent.hashCode());
        String $usPrivacy = this.getUsPrivacy();
        result = result * 59 + ($usPrivacy == null ? 43 : $usPrivacy.hashCode());
        String $gpp = this.getGpp();
        result = result * 59 + ($gpp == null ? 43 : $gpp.hashCode());
        List<Integer> $gppSid = this.getGppSid();
        result = result * 59 + ($gppSid == null ? 43 : ((Object)$gppSid).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        FilterSettings $filterSettings = this.getFilterSettings();
        result = result * 59 + ($filterSettings == null ? 43 : ((Object)$filterSettings).hashCode());
        return result;
    }

    public String toString() {
        return "CookieSyncRequest(bidders=" + this.getBidders() + ", gdpr=" + this.getGdpr() + ", gdprConsent=" + this.getGdprConsent() + ", usPrivacy=" + this.getUsPrivacy() + ", gpp=" + this.getGpp() + ", gppSid=" + this.getGppSid() + ", coopSync=" + this.getCoopSync() + ", debug=" + this.getDebug() + ", limit=" + this.getLimit() + ", account=" + this.getAccount() + ", filterSettings=" + this.getFilterSettings() + ")";
    }

    public static final class FilterSettings {
        private final MethodFilter iframe;
        private final MethodFilter image;

        @ConstructorProperties(value={"iframe", "image"})
        private FilterSettings(MethodFilter iframe, MethodFilter image) {
            this.iframe = iframe;
            this.image = image;
        }

        public static FilterSettings of(MethodFilter iframe, MethodFilter image) {
            return new FilterSettings(iframe, image);
        }

        public MethodFilter getIframe() {
            return this.iframe;
        }

        public MethodFilter getImage() {
            return this.image;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterSettings)) {
                return false;
            }
            FilterSettings other = (FilterSettings)o;
            MethodFilter this$iframe = this.getIframe();
            MethodFilter other$iframe = other.getIframe();
            if (this$iframe == null ? other$iframe != null : !((Object)this$iframe).equals(other$iframe)) {
                return false;
            }
            MethodFilter this$image = this.getImage();
            MethodFilter other$image = other.getImage();
            return !(this$image == null ? other$image != null : !((Object)this$image).equals(other$image));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MethodFilter $iframe = this.getIframe();
            result = result * 59 + ($iframe == null ? 43 : ((Object)$iframe).hashCode());
            MethodFilter $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
            return result;
        }

        public String toString() {
            return "CookieSyncRequest.FilterSettings(iframe=" + this.getIframe() + ", image=" + this.getImage() + ")";
        }
    }

    public static class CookieSyncRequestBuilder {
        private Set<String> bidders;
        private Integer gdpr;
        private String gdprConsent;
        private String usPrivacy;
        private String gpp;
        private List<Integer> gppSid;
        private Boolean coopSync;
        private Boolean debug;
        private Integer limit;
        private String account;
        private FilterSettings filterSettings;

        CookieSyncRequestBuilder() {
        }

        public CookieSyncRequestBuilder bidders(Set<String> bidders) {
            this.bidders = bidders;
            return this;
        }

        public CookieSyncRequestBuilder gdpr(Integer gdpr) {
            this.gdpr = gdpr;
            return this;
        }

        public CookieSyncRequestBuilder gdprConsent(String gdprConsent) {
            this.gdprConsent = gdprConsent;
            return this;
        }

        public CookieSyncRequestBuilder usPrivacy(String usPrivacy) {
            this.usPrivacy = usPrivacy;
            return this;
        }

        public CookieSyncRequestBuilder gpp(String gpp) {
            this.gpp = gpp;
            return this;
        }

        @JsonDeserialize(using=CommaSeparatedStringAsListOfIntegersDeserializer.class)
        public CookieSyncRequestBuilder gppSid(List<Integer> gppSid) {
            this.gppSid = gppSid;
            return this;
        }

        @JsonProperty(value="coopSync")
        public CookieSyncRequestBuilder coopSync(Boolean coopSync) {
            this.coopSync = coopSync;
            return this;
        }

        public CookieSyncRequestBuilder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public CookieSyncRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public CookieSyncRequestBuilder account(String account) {
            this.account = account;
            return this;
        }

        @JsonProperty(value="filterSettings")
        public CookieSyncRequestBuilder filterSettings(FilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public CookieSyncRequest build() {
            return new CookieSyncRequest(this.bidders, this.gdpr, this.gdprConsent, this.usPrivacy, this.gpp, this.gppSid, this.coopSync, this.debug, this.limit, this.account, this.filterSettings);
        }

        public String toString() {
            return "CookieSyncRequest.CookieSyncRequestBuilder(bidders=" + this.bidders + ", gdpr=" + this.gdpr + ", gdprConsent=" + this.gdprConsent + ", usPrivacy=" + this.usPrivacy + ", gpp=" + this.gpp + ", gppSid=" + this.gppSid + ", coopSync=" + this.coopSync + ", debug=" + this.debug + ", limit=" + this.limit + ", account=" + this.account + ", filterSettings=" + this.filterSettings + ")";
        }
    }

    public static enum FilterType {
        include,
        exclude;

    }

    public static final class MethodFilter {
        private final JsonNode bidders;
        private final FilterType filter;

        @ConstructorProperties(value={"bidders", "filter"})
        private MethodFilter(JsonNode bidders, FilterType filter) {
            this.bidders = bidders;
            this.filter = filter;
        }

        public static MethodFilter of(JsonNode bidders, FilterType filter) {
            return new MethodFilter(bidders, filter);
        }

        public JsonNode getBidders() {
            return this.bidders;
        }

        public FilterType getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodFilter)) {
                return false;
            }
            MethodFilter other = (MethodFilter)o;
            JsonNode this$bidders = this.getBidders();
            JsonNode other$bidders = other.getBidders();
            if (this$bidders == null ? other$bidders != null : !this$bidders.equals(other$bidders)) {
                return false;
            }
            FilterType this$filter = this.getFilter();
            FilterType other$filter = other.getFilter();
            return !(this$filter == null ? other$filter != null : !((Object)((Object)this$filter)).equals((Object)other$filter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JsonNode $bidders = this.getBidders();
            result = result * 59 + ($bidders == null ? 43 : $bidders.hashCode());
            FilterType $filter = this.getFilter();
            result = result * 59 + ($filter == null ? 43 : ((Object)((Object)$filter)).hashCode());
            return result;
        }

        public String toString() {
            return "CookieSyncRequest.MethodFilter(bidders=" + this.getBidders() + ", filter=" + this.getFilter() + ")";
        }
    }
}

