/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.proto.openrtb.ext.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Eid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ConsentedProvidersSettings;
import org.prebid.server.proto.openrtb.ext.request.ExtUserPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtUserTime;

public final class ExtUser
extends FlexibleExtension {
    private static final ExtUser EMPTY = ExtUser.builder().build();
    private final ExtUserPrebid prebid;
    private final String consent;
    private final List<Eid> eids;
    @JsonProperty(value="fcapids")
    private final List<String> fcapIds;
    private final ExtUserTime time;
    private final ObjectNode data;
    private final JsonNode digitrust;
    @JsonProperty(value="ConsentedProvidersSettings")
    private final ConsentedProvidersSettings consentedProvidersSettings;

    @JsonIgnore
    public boolean isEmpty() {
        return Objects.equals(this, EMPTY);
    }

    @ConstructorProperties(value={"prebid", "consent", "eids", "fcapIds", "time", "data", "digitrust", "consentedProvidersSettings"})
    ExtUser(ExtUserPrebid prebid, String consent, List<Eid> eids, List<String> fcapIds, ExtUserTime time, ObjectNode data, JsonNode digitrust, ConsentedProvidersSettings consentedProvidersSettings) {
        this.prebid = prebid;
        this.consent = consent;
        this.eids = eids;
        this.fcapIds = fcapIds;
        this.time = time;
        this.data = data;
        this.digitrust = digitrust;
        this.consentedProvidersSettings = consentedProvidersSettings;
    }

    public static ExtUserBuilder builder() {
        return new ExtUserBuilder();
    }

    public ExtUserBuilder toBuilder() {
        return new ExtUserBuilder().prebid(this.prebid).consent(this.consent).eids(this.eids).fcapIds(this.fcapIds).time(this.time).data(this.data).digitrust(this.digitrust).consentedProvidersSettings(this.consentedProvidersSettings);
    }

    public ExtUserPrebid getPrebid() {
        return this.prebid;
    }

    public String getConsent() {
        return this.consent;
    }

    public List<Eid> getEids() {
        return this.eids;
    }

    public List<String> getFcapIds() {
        return this.fcapIds;
    }

    public ExtUserTime getTime() {
        return this.time;
    }

    public ObjectNode getData() {
        return this.data;
    }

    public JsonNode getDigitrust() {
        return this.digitrust;
    }

    public ConsentedProvidersSettings getConsentedProvidersSettings() {
        return this.consentedProvidersSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtUser)) {
            return false;
        }
        ExtUser other = (ExtUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtUserPrebid this$prebid = this.getPrebid();
        ExtUserPrebid other$prebid = other.getPrebid();
        if (this$prebid == null ? other$prebid != null : !((Object)this$prebid).equals(other$prebid)) {
            return false;
        }
        String this$consent = this.getConsent();
        String other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !this$consent.equals(other$consent)) {
            return false;
        }
        List<Eid> this$eids = this.getEids();
        List<Eid> other$eids = other.getEids();
        if (this$eids == null ? other$eids != null : !((Object)this$eids).equals(other$eids)) {
            return false;
        }
        List<String> this$fcapIds = this.getFcapIds();
        List<String> other$fcapIds = other.getFcapIds();
        if (this$fcapIds == null ? other$fcapIds != null : !((Object)this$fcapIds).equals(other$fcapIds)) {
            return false;
        }
        ExtUserTime this$time = this.getTime();
        ExtUserTime other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        ObjectNode this$data = this.getData();
        ObjectNode other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        JsonNode this$digitrust = this.getDigitrust();
        JsonNode other$digitrust = other.getDigitrust();
        if (this$digitrust == null ? other$digitrust != null : !this$digitrust.equals(other$digitrust)) {
            return false;
        }
        ConsentedProvidersSettings this$consentedProvidersSettings = this.getConsentedProvidersSettings();
        ConsentedProvidersSettings other$consentedProvidersSettings = other.getConsentedProvidersSettings();
        return !(this$consentedProvidersSettings == null ? other$consentedProvidersSettings != null : !((Object)this$consentedProvidersSettings).equals(other$consentedProvidersSettings));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExtUser;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ExtUserPrebid $prebid = this.getPrebid();
        result = result * 59 + ($prebid == null ? 43 : ((Object)$prebid).hashCode());
        String $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : $consent.hashCode());
        List<Eid> $eids = this.getEids();
        result = result * 59 + ($eids == null ? 43 : ((Object)$eids).hashCode());
        List<String> $fcapIds = this.getFcapIds();
        result = result * 59 + ($fcapIds == null ? 43 : ((Object)$fcapIds).hashCode());
        ExtUserTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        ObjectNode $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        JsonNode $digitrust = this.getDigitrust();
        result = result * 59 + ($digitrust == null ? 43 : $digitrust.hashCode());
        ConsentedProvidersSettings $consentedProvidersSettings = this.getConsentedProvidersSettings();
        result = result * 59 + ($consentedProvidersSettings == null ? 43 : ((Object)$consentedProvidersSettings).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExtUser(super=" + super.toString() + ", prebid=" + this.getPrebid() + ", consent=" + this.getConsent() + ", eids=" + this.getEids() + ", fcapIds=" + this.getFcapIds() + ", time=" + this.getTime() + ", data=" + this.getData() + ", digitrust=" + this.getDigitrust() + ", consentedProvidersSettings=" + this.getConsentedProvidersSettings() + ")";
    }

    public static class ExtUserBuilder {
        private ExtUserPrebid prebid;
        private String consent;
        private List<Eid> eids;
        private List<String> fcapIds;
        private ExtUserTime time;
        private ObjectNode data;
        private JsonNode digitrust;
        private ConsentedProvidersSettings consentedProvidersSettings;

        ExtUserBuilder() {
        }

        public ExtUserBuilder prebid(ExtUserPrebid prebid) {
            this.prebid = prebid;
            return this;
        }

        public ExtUserBuilder consent(String consent) {
            this.consent = consent;
            return this;
        }

        public ExtUserBuilder eids(List<Eid> eids) {
            this.eids = eids;
            return this;
        }

        @JsonProperty(value="fcapids")
        public ExtUserBuilder fcapIds(List<String> fcapIds) {
            this.fcapIds = fcapIds;
            return this;
        }

        public ExtUserBuilder time(ExtUserTime time) {
            this.time = time;
            return this;
        }

        public ExtUserBuilder data(ObjectNode data) {
            this.data = data;
            return this;
        }

        public ExtUserBuilder digitrust(JsonNode digitrust) {
            this.digitrust = digitrust;
            return this;
        }

        @JsonProperty(value="ConsentedProvidersSettings")
        public ExtUserBuilder consentedProvidersSettings(ConsentedProvidersSettings consentedProvidersSettings) {
            this.consentedProvidersSettings = consentedProvidersSettings;
            return this;
        }

        public ExtUser build() {
            return new ExtUser(this.prebid, this.consent, this.eids, this.fcapIds, this.time, this.data, this.digitrust, this.consentedProvidersSettings);
        }

        public String toString() {
            return "ExtUser.ExtUserBuilder(prebid=" + this.prebid + ", consent=" + this.consent + ", eids=" + this.eids + ", fcapIds=" + this.fcapIds + ", time=" + this.time + ", data=" + this.data + ", digitrust=" + this.digitrust + ", consentedProvidersSettings=" + this.consentedProvidersSettings + ")";
        }
    }
}

