/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.vendorlist;

import com.iabtcf.decoder.TCString;
import io.vertx.core.Future;
import java.util.Map;
import java.util.Objects;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.privacy.gdpr.vendorlist.VendorListService;
import org.prebid.server.privacy.gdpr.vendorlist.proto.Vendor;

public class VersionedVendorListService {
    private final VendorListService vendorListServiceV2;
    private final VendorListService vendorListServiceV3;

    public VersionedVendorListService(VendorListService vendorListServiceV2, VendorListService vendorListServiceV3) {
        this.vendorListServiceV2 = Objects.requireNonNull(vendorListServiceV2);
        this.vendorListServiceV3 = Objects.requireNonNull(vendorListServiceV3);
    }

    public Future<Map<Integer, Vendor>> forConsent(TCString consent) {
        int tcfPolicyVersion = consent.getTcfPolicyVersion();
        int vendorListVersion = consent.getVendorListVersion();
        if (tcfPolicyVersion < 4) {
            return this.vendorListServiceV2.forVersion(vendorListVersion);
        }
        if (tcfPolicyVersion == 4) {
            return this.vendorListServiceV3.forVersion(vendorListVersion);
        }
        return Future.failedFuture((Throwable)new PreBidException("Invalid tcf policy version: %d".formatted(tcfPolicyVersion)));
    }
}

