/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies;

import com.iabtcf.decoder.TCString;
import com.iabtcf.utils.IntIterable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.privacy.gdpr.model.VendorPermissionWithGvl;
import org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies.EnforcePurposeStrategy;
import org.prebid.server.privacy.gdpr.vendorlist.proto.PurposeCode;

public class NoEnforcePurposeStrategy
extends EnforcePurposeStrategy {
    @Override
    public Collection<VendorPermission> allowedByTypeStrategy(PurposeCode purpose, TCString tcString, Collection<VendorPermissionWithGvl> vendorsForPurpose, Collection<VendorPermissionWithGvl> excludedVendors, boolean isEnforceVendors) {
        IntIterable vendorConsent = tcString.getVendorConsent();
        IntIterable vendorLIConsent = tcString.getVendorLegitimateInterest();
        List<VendorPermission> allowedVendorPermissions = vendorsForPurpose.stream().map(VendorPermissionWithGvl::getVendorPermission).filter(vendorPermission -> vendorPermission.getVendorId() != null).filter(vendorPermission -> this.isAllowedByVendorConsent(vendorPermission.getVendorId(), isEnforceVendors, vendorConsent, vendorLIConsent)).toList();
        return CollectionUtils.union(allowedVendorPermissions, NoEnforcePurposeStrategy.toVendorPermissions(excludedVendors));
    }

    private boolean isAllowedByVendorConsent(Integer vendorId, boolean isEnforceVendors, IntIterable vendorConsent, IntIterable vendorLIConsent) {
        return !isEnforceVendors || vendorConsent.contains(vendorId.intValue()) || vendorLIConsent.contains(vendorId.intValue());
    }
}

