/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.model;

import com.iabtcf.decoder.TCString;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.prebid.server.geolocation.model.GeoInfo;

public final class TcfContext {
    private final boolean inGdprScope;
    private final String consentString;
    private final TCString consent;
    private final boolean consentValid;
    private final GeoInfo geoInfo;
    private final Boolean inEea;
    private final String ipAddress;
    private final List<String> warnings;

    public static TcfContext empty() {
        return TcfContext.builder().warnings(Collections.emptyList()).build();
    }

    @ConstructorProperties(value={"inGdprScope", "consentString", "consent", "consentValid", "geoInfo", "inEea", "ipAddress", "warnings"})
    TcfContext(boolean inGdprScope, String consentString, TCString consent, boolean consentValid, GeoInfo geoInfo, Boolean inEea, String ipAddress, List<String> warnings) {
        this.inGdprScope = inGdprScope;
        this.consentString = consentString;
        this.consent = consent;
        this.consentValid = consentValid;
        this.geoInfo = geoInfo;
        this.inEea = inEea;
        this.ipAddress = ipAddress;
        this.warnings = warnings;
    }

    public static TcfContextBuilder builder() {
        return new TcfContextBuilder();
    }

    public TcfContextBuilder toBuilder() {
        return new TcfContextBuilder().inGdprScope(this.inGdprScope).consentString(this.consentString).consent(this.consent).consentValid(this.consentValid).geoInfo(this.geoInfo).inEea(this.inEea).ipAddress(this.ipAddress).warnings(this.warnings);
    }

    public boolean isInGdprScope() {
        return this.inGdprScope;
    }

    public String getConsentString() {
        return this.consentString;
    }

    public TCString getConsent() {
        return this.consent;
    }

    public boolean isConsentValid() {
        return this.consentValid;
    }

    public GeoInfo getGeoInfo() {
        return this.geoInfo;
    }

    public Boolean getInEea() {
        return this.inEea;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcfContext)) {
            return false;
        }
        TcfContext other = (TcfContext)o;
        if (this.isInGdprScope() != other.isInGdprScope()) {
            return false;
        }
        if (this.isConsentValid() != other.isConsentValid()) {
            return false;
        }
        Boolean this$inEea = this.getInEea();
        Boolean other$inEea = other.getInEea();
        if (this$inEea == null ? other$inEea != null : !((Object)this$inEea).equals(other$inEea)) {
            return false;
        }
        String this$consentString = this.getConsentString();
        String other$consentString = other.getConsentString();
        if (this$consentString == null ? other$consentString != null : !this$consentString.equals(other$consentString)) {
            return false;
        }
        TCString this$consent = this.getConsent();
        TCString other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !this$consent.equals(other$consent)) {
            return false;
        }
        GeoInfo this$geoInfo = this.getGeoInfo();
        GeoInfo other$geoInfo = other.getGeoInfo();
        if (this$geoInfo == null ? other$geoInfo != null : !((Object)this$geoInfo).equals(other$geoInfo)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        return !(this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInGdprScope() ? 79 : 97);
        result = result * 59 + (this.isConsentValid() ? 79 : 97);
        Boolean $inEea = this.getInEea();
        result = result * 59 + ($inEea == null ? 43 : ((Object)$inEea).hashCode());
        String $consentString = this.getConsentString();
        result = result * 59 + ($consentString == null ? 43 : $consentString.hashCode());
        TCString $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : $consent.hashCode());
        GeoInfo $geoInfo = this.getGeoInfo();
        result = result * 59 + ($geoInfo == null ? 43 : ((Object)$geoInfo).hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        return result;
    }

    public String toString() {
        return "TcfContext(inGdprScope=" + this.isInGdprScope() + ", consentString=" + this.getConsentString() + ", consent=" + this.getConsent() + ", consentValid=" + this.isConsentValid() + ", geoInfo=" + this.getGeoInfo() + ", inEea=" + this.getInEea() + ", ipAddress=" + this.getIpAddress() + ", warnings=" + this.getWarnings() + ")";
    }

    public static class TcfContextBuilder {
        private boolean inGdprScope;
        private String consentString;
        private TCString consent;
        private boolean consentValid;
        private GeoInfo geoInfo;
        private Boolean inEea;
        private String ipAddress;
        private List<String> warnings;

        TcfContextBuilder() {
        }

        public TcfContextBuilder inGdprScope(boolean inGdprScope) {
            this.inGdprScope = inGdprScope;
            return this;
        }

        public TcfContextBuilder consentString(String consentString) {
            this.consentString = consentString;
            return this;
        }

        public TcfContextBuilder consent(TCString consent) {
            this.consent = consent;
            return this;
        }

        public TcfContextBuilder consentValid(boolean consentValid) {
            this.consentValid = consentValid;
            return this;
        }

        public TcfContextBuilder geoInfo(GeoInfo geoInfo) {
            this.geoInfo = geoInfo;
            return this;
        }

        public TcfContextBuilder inEea(Boolean inEea) {
            this.inEea = inEea;
            return this;
        }

        public TcfContextBuilder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public TcfContextBuilder warnings(List<String> warnings) {
            this.warnings = warnings;
            return this;
        }

        public TcfContext build() {
            return new TcfContext(this.inGdprScope, this.consentString, this.consent, this.consentValid, this.geoInfo, this.inEea, this.ipAddress, this.warnings);
        }

        public String toString() {
            return "TcfContext.TcfContextBuilder(inGdprScope=" + this.inGdprScope + ", consentString=" + this.consentString + ", consent=" + this.consent + ", consentValid=" + this.consentValid + ", geoInfo=" + this.geoInfo + ", inEea=" + this.inEea + ", ipAddress=" + this.ipAddress + ", warnings=" + this.warnings + ")";
        }
    }
}

