/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.model;

import java.beans.ConstructorProperties;

public final class UpdateResult<T> {
    private final boolean updated;
    private final T value;

    public static <T> UpdateResult<T> unaltered(T value) {
        return new UpdateResult<T>(false, value);
    }

    public static <T> UpdateResult<T> updated(T value) {
        return new UpdateResult<T>(true, value);
    }

    @ConstructorProperties(value={"updated", "value"})
    public UpdateResult(boolean updated, T value) {
        this.updated = updated;
        this.value = value;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateResult)) {
            return false;
        }
        UpdateResult other = (UpdateResult)o;
        if (this.isUpdated() != other.isUpdated()) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUpdated() ? 79 : 97);
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateResult(updated=" + this.isUpdated() + ", value=" + this.getValue() + ")";
    }
}

