/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.UpdatableMetrics;
import org.prebid.server.metric.ValidationMetrics;

class ResponseMetrics
extends UpdatableMetrics {
    private final ValidationMetrics validationMetrics;

    ResponseMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), ResponseMetrics.nameCreator(ResponseMetrics.createPrefix(Objects.requireNonNull(prefix))));
        this.validationMetrics = new ValidationMetrics(metricRegistry, counterType, ResponseMetrics.createPrefix(prefix));
    }

    private static Function<MetricName, String> nameCreator(String prefix) {
        return metricName -> "%s.%s".formatted(prefix, metricName);
    }

    private static String createPrefix(String prefix) {
        return prefix + ".response";
    }

    ValidationMetrics validation() {
        return this.validationMetrics;
    }
}

