/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.TcfMetrics;
import org.prebid.server.metric.UpdatableMetrics;

class RequestTypeMetrics
extends UpdatableMetrics {
    private final TcfMetrics tcfMetrics;

    RequestTypeMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix, MetricName requestType) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), RequestTypeMetrics.nameCreator(Objects.requireNonNull(prefix), Objects.requireNonNull(requestType)));
        this.tcfMetrics = new TcfMetrics(metricRegistry, counterType, RequestTypeMetrics.createTcfPrefix(prefix, requestType));
    }

    TcfMetrics tcf() {
        return this.tcfMetrics;
    }

    private static Function<MetricName, String> nameCreator(String prefix, MetricName requestType) {
        return metricName -> "%s.%s.type.%s".formatted(new Object[]{prefix, metricName, requestType});
    }

    private static String createTcfPrefix(String prefix, MetricName requestType) {
        return "%s.%s".formatted(new Object[]{prefix, requestType});
    }
}

