/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.hooks.execution.model;

import org.prebid.server.hooks.execution.model.Stage;
import org.prebid.server.hooks.execution.model.StageWithHookTypeImpl;
import org.prebid.server.hooks.v1.Hook;
import org.prebid.server.hooks.v1.InvocationContext;
import org.prebid.server.hooks.v1.auction.AuctionResponseHook;
import org.prebid.server.hooks.v1.auction.ProcessedAuctionRequestHook;
import org.prebid.server.hooks.v1.auction.RawAuctionRequestHook;
import org.prebid.server.hooks.v1.bidder.AllProcessedBidResponsesHook;
import org.prebid.server.hooks.v1.bidder.BidderRequestHook;
import org.prebid.server.hooks.v1.bidder.ProcessedBidderResponseHook;
import org.prebid.server.hooks.v1.bidder.RawBidderResponseHook;
import org.prebid.server.hooks.v1.entrypoint.EntrypointHook;

public interface StageWithHookType<TYPE extends Hook<?, ? extends InvocationContext>> {
    public static final StageWithHookType<EntrypointHook> ENTRYPOINT = new StageWithHookTypeImpl<EntrypointHook>(Stage.entrypoint, EntrypointHook.class);
    public static final StageWithHookType<RawAuctionRequestHook> RAW_AUCTION_REQUEST = new StageWithHookTypeImpl<RawAuctionRequestHook>(Stage.raw_auction_request, RawAuctionRequestHook.class);
    public static final StageWithHookType<ProcessedAuctionRequestHook> PROCESSED_AUCTION_REQUEST = new StageWithHookTypeImpl<ProcessedAuctionRequestHook>(Stage.processed_auction_request, ProcessedAuctionRequestHook.class);
    public static final StageWithHookType<BidderRequestHook> BIDDER_REQUEST = new StageWithHookTypeImpl<BidderRequestHook>(Stage.bidder_request, BidderRequestHook.class);
    public static final StageWithHookType<RawBidderResponseHook> RAW_BIDDER_RESPONSE = new StageWithHookTypeImpl<RawBidderResponseHook>(Stage.raw_bidder_response, RawBidderResponseHook.class);
    public static final StageWithHookType<ProcessedBidderResponseHook> PROCESSED_BIDDER_RESPONSE = new StageWithHookTypeImpl<ProcessedBidderResponseHook>(Stage.processed_bidder_response, ProcessedBidderResponseHook.class);
    public static final StageWithHookType<AllProcessedBidResponsesHook> ALL_PROCESSED_BID_RESPONSES = new StageWithHookTypeImpl<AllProcessedBidResponsesHook>(Stage.all_processed_bid_responses, AllProcessedBidResponsesHook.class);
    public static final StageWithHookType<AuctionResponseHook> AUCTION_RESPONSE = new StageWithHookTypeImpl<AuctionResponseHook>(Stage.auction_response, AuctionResponseHook.class);

    public Stage stage();

    public Class<TYPE> hookType();

    public static StageWithHookType<? extends Hook<?, ? extends InvocationContext>> forStage(Stage stage) {
        return switch (stage) {
            default -> throw new IncompatibleClassChangeError();
            case Stage.entrypoint -> ENTRYPOINT;
            case Stage.raw_auction_request -> RAW_AUCTION_REQUEST;
            case Stage.processed_auction_request -> PROCESSED_AUCTION_REQUEST;
            case Stage.bidder_request -> BIDDER_REQUEST;
            case Stage.raw_bidder_response -> RAW_BIDDER_RESPONSE;
            case Stage.all_processed_bid_responses -> ALL_PROCESSED_BID_RESPONSES;
            case Stage.processed_bidder_response -> PROCESSED_BIDDER_RESPONSE;
            case Stage.auction_response -> AUCTION_RESPONSE;
        };
    }
}

