/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.health;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.atomic.LongAdder;

public class HealthMonitor {
    private final LongAdder totalCounter = new LongAdder();
    private final LongAdder successCounter = new LongAdder();

    public void incTotal() {
        this.totalCounter.increment();
    }

    public void incSuccess() {
        this.successCounter.increment();
    }

    public BigDecimal calculateHealthIndex() {
        BigDecimal success = BigDecimal.valueOf(this.successCounter.sumThenReset());
        BigDecimal total = BigDecimal.valueOf(this.totalCounter.sumThenReset());
        return total.longValue() == 0L ? BigDecimal.ONE : success.divide(total, 2, RoundingMode.HALF_EVEN);
    }
}

