/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.log.LoggerControlKnob;
import org.prebid.server.util.HttpUtil;

public class LoggerControlKnobHandler
implements Handler<RoutingContext> {
    private static final String LEVEL_PARAMETER = "level";
    private static final String DURATION_PARAMETER = "duration";
    private static final Set<String> ALLOWED_LEVELS = Set.of("error", "warn", "info", "debug");
    private final long maxDurationMs;
    private final LoggerControlKnob loggerControlKnob;
    private final String endpoint;

    public LoggerControlKnobHandler(long maxDurationMs, LoggerControlKnob loggerControlKnob, String endpoint) {
        this.maxDurationMs = maxDurationMs;
        this.loggerControlKnob = Objects.requireNonNull(loggerControlKnob);
        this.endpoint = Objects.requireNonNull(endpoint);
    }

    public void handle(RoutingContext routingContext) {
        try {
            MultiMap parameters = routingContext.request().params();
            this.loggerControlKnob.changeLogLevel(this.readLevel(parameters), this.readDuration(parameters));
            HttpUtil.executeSafely(routingContext, this.endpoint, HttpServerResponse::end);
        }
        catch (InvalidRequestException e) {
            HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(e.getMessage()));
        }
    }

    private String readLevel(MultiMap parameters) {
        String level = parameters.get(LEVEL_PARAMETER);
        if (level == null) {
            throw new InvalidRequestException("Missing required parameter '%s'".formatted(LEVEL_PARAMETER));
        }
        if (!ALLOWED_LEVELS.contains(level.toLowerCase())) {
            throw new InvalidRequestException("Invalid '%s' parameter value, allowed values '%s'".formatted(LEVEL_PARAMETER, ALLOWED_LEVELS));
        }
        return level;
    }

    private Duration readDuration(MultiMap parameters) {
        Integer duration = this.getIntParameter(DURATION_PARAMETER, parameters);
        if (duration == null) {
            throw new InvalidRequestException("Missing required parameter '%s'".formatted(DURATION_PARAMETER));
        }
        if (duration < 1 || (long)duration.intValue() > this.maxDurationMs) {
            throw new InvalidRequestException("Parameter '%s' must be between %d and %d".formatted(DURATION_PARAMETER, 0, this.maxDurationMs));
        }
        return Duration.ofMillis(duration.intValue());
    }

    private Integer getIntParameter(String parameterName, MultiMap parameters) {
        String value = parameters.get(parameterName);
        try {
            return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException("Invalid '%s' parameter value".formatted(parameterName));
        }
    }
}

