/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.cookie.model.UidWithExpiry;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.Endpoint;
import org.prebid.server.util.HttpUtil;

public class GetuidsHandler
implements Handler<RoutingContext> {
    private final UidsCookieService uidsCookieService;
    private final JacksonMapper mapper;

    public GetuidsHandler(UidsCookieService uidsCookieService, JacksonMapper mapper) {
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void handle(RoutingContext routingContext) {
        Map<String, String> uids = this.uidsFrom(routingContext);
        String body = this.mapper.encodeToString(BuyerUids.of(uids));
        HttpUtil.executeSafely(routingContext, Endpoint.getuids, response -> response.putHeader(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpUtil.APPLICATION_JSON_CONTENT_TYPE).end(body));
    }

    private Map<String, String> uidsFrom(RoutingContext routingContext) {
        UidsCookie uidsCookie = this.uidsCookieService.parseFromRequest(routingContext);
        return uidsCookie.getCookieUids().getUids().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, uidEntry -> ((UidWithExpiry)uidEntry.getValue()).getUid()));
    }

    private static final class BuyerUids {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private final Map<String, String> buyeruids;

        public Map<String, String> getBuyeruids() {
            return this.buyeruids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuyerUids)) {
                return false;
            }
            BuyerUids other = (BuyerUids)o;
            Map<String, String> this$buyeruids = this.getBuyeruids();
            Map<String, String> other$buyeruids = other.getBuyeruids();
            return !(this$buyeruids == null ? other$buyeruids != null : !((Object)this$buyeruids).equals(other$buyeruids));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $buyeruids = this.getBuyeruids();
            result = result * 59 + ($buyeruids == null ? 43 : ((Object)$buyeruids).hashCode());
            return result;
        }

        public String toString() {
            return "GetuidsHandler.BuyerUids(buyeruids=" + this.getBuyeruids() + ")";
        }

        @ConstructorProperties(value={"buyeruids"})
        private BuyerUids(Map<String, String> buyeruids) {
            this.buyeruids = buyeruids;
        }

        public static BuyerUids of(Map<String, String> buyeruids) {
            return new BuyerUids(buyeruids);
        }
    }
}

