/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.activity.infrastructure.creator.ActivityInfrastructureCreator;
import org.prebid.server.analytics.model.CookieSyncEvent;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.auction.gpp.CookieSyncGppService;
import org.prebid.server.bidder.UsersyncMethodChooser;
import org.prebid.server.cookie.CookieSyncService;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.cookie.exception.CookieSyncException;
import org.prebid.server.cookie.exception.InvalidCookieSyncRequestException;
import org.prebid.server.cookie.exception.UnauthorizedUidsException;
import org.prebid.server.cookie.model.BiddersContext;
import org.prebid.server.cookie.model.CookieSyncContext;
import org.prebid.server.exception.InvalidAccountConfigException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.Metrics;
import org.prebid.server.model.Endpoint;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.proto.openrtb.ext.request.TraceLevel;
import org.prebid.server.proto.request.CookieSyncRequest;
import org.prebid.server.proto.response.CookieSyncResponse;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.util.HttpUtil;

public class CookieSyncHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(CookieSyncHandler.class);
    private static final ConditionalLogger BAD_REQUEST_LOGGER = new ConditionalLogger(logger);
    private final long defaultTimeout;
    private final double logSamplingRate;
    private final UidsCookieService uidsCookieService;
    private final CookieSyncGppService gppService;
    private final ActivityInfrastructureCreator activityInfrastructureCreator;
    private final CookieSyncService cookieSyncService;
    private final ApplicationSettings applicationSettings;
    private final PrivacyEnforcementService privacyEnforcementService;
    private final AnalyticsReporterDelegator analyticsDelegator;
    private final Metrics metrics;
    private final TimeoutFactory timeoutFactory;
    private final JacksonMapper mapper;

    public CookieSyncHandler(long defaultTimeout, double logSamplingRate, UidsCookieService uidsCookieService, CookieSyncGppService gppService, ActivityInfrastructureCreator activityInfrastructureCreator, CookieSyncService cookieSyncService, ApplicationSettings applicationSettings, PrivacyEnforcementService privacyEnforcementService, AnalyticsReporterDelegator analyticsDelegator, Metrics metrics, TimeoutFactory timeoutFactory, JacksonMapper mapper) {
        this.defaultTimeout = defaultTimeout;
        this.logSamplingRate = logSamplingRate;
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
        this.gppService = Objects.requireNonNull(gppService);
        this.activityInfrastructureCreator = Objects.requireNonNull(activityInfrastructureCreator);
        this.cookieSyncService = Objects.requireNonNull(cookieSyncService);
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.privacyEnforcementService = Objects.requireNonNull(privacyEnforcementService);
        this.analyticsDelegator = Objects.requireNonNull(analyticsDelegator);
        this.metrics = Objects.requireNonNull(metrics);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void handle(RoutingContext routingContext) {
        this.metrics.updateCookieSyncRequestMetric();
        this.cookieSyncContext(routingContext).compose(this::fillWithAccount).map(this::fillWithGppContext).map(this::fillWithActivityInfrastructure).map(this::processGpp).compose(this::fillWithPrivacyContext).compose(this.cookieSyncService::processContext).onFailure(error -> this.respondWithError((Throwable)error, routingContext)).onSuccess(cookieSyncContext -> this.respondWithResult((CookieSyncContext)cookieSyncContext, this.cookieSyncService.prepareResponse((CookieSyncContext)cookieSyncContext)));
    }

    private Future<CookieSyncContext> cookieSyncContext(RoutingContext routingContext) {
        CookieSyncRequest cookieSyncRequest;
        try {
            cookieSyncRequest = this.parseRequest(routingContext);
        }
        catch (Exception e) {
            return Future.failedFuture((Throwable)e);
        }
        boolean debug = BooleanUtils.toBoolean((Boolean)cookieSyncRequest.getDebug());
        Timeout timeout = this.timeoutFactory.create(this.defaultTimeout);
        UidsCookie uidsCookie = this.uidsCookieService.parseFromRequest(routingContext);
        BiddersContext biddersContext = BiddersContext.builder().build();
        CookieSyncContext cookieSyncContext = CookieSyncContext.builder().routingContext(routingContext).uidsCookie(uidsCookie).cookieSyncRequest(cookieSyncRequest).usersyncMethodChooser(UsersyncMethodChooser.from(cookieSyncRequest.getFilterSettings())).biddersContext(biddersContext).timeout(timeout).debug(debug).warnings(new ArrayList<String>()).build();
        return Future.succeededFuture((Object)cookieSyncContext);
    }

    private CookieSyncRequest parseRequest(RoutingContext routingContext) {
        Buffer body = routingContext.getBody();
        if (body == null) {
            throw new InvalidCookieSyncRequestException("Request has no body");
        }
        try {
            return this.mapper.decodeValue(body, CookieSyncRequest.class);
        }
        catch (DecodeException e) {
            String message = "Request body cannot be parsed";
            logger.info((Object)"Request body cannot be parsed", (Throwable)e);
            throw new InvalidCookieSyncRequestException("Request body cannot be parsed");
        }
    }

    private Future<CookieSyncContext> fillWithAccount(CookieSyncContext cookieSyncContext) {
        return this.accountById(cookieSyncContext.getCookieSyncRequest().getAccount(), cookieSyncContext.getTimeout()).map(cookieSyncContext::with);
    }

    private Future<Account> accountById(String accountId, Timeout timeout) {
        return StringUtils.isBlank((CharSequence)accountId) ? Future.succeededFuture((Object)Account.empty(accountId)) : this.applicationSettings.getAccountById(accountId, timeout).otherwise((Object)Account.empty(accountId));
    }

    private CookieSyncContext fillWithGppContext(CookieSyncContext cookieSyncContext) {
        return cookieSyncContext.toBuilder().gppContext(this.gppService.contextFrom(cookieSyncContext)).build();
    }

    private CookieSyncContext fillWithActivityInfrastructure(CookieSyncContext cookieSyncContext) {
        return cookieSyncContext.toBuilder().activityInfrastructure(this.activityInfrastructureCreator.create(cookieSyncContext.getAccount(), cookieSyncContext.getGppContext(), cookieSyncContext.isDebug() ? TraceLevel.verbose : null)).build();
    }

    private CookieSyncContext processGpp(CookieSyncContext cookieSyncContext) {
        return cookieSyncContext.with(this.gppService.updateCookieSyncRequest(cookieSyncContext.getCookieSyncRequest(), cookieSyncContext));
    }

    private Future<CookieSyncContext> fillWithPrivacyContext(CookieSyncContext cookieSyncContext) {
        return this.privacyEnforcementService.contextFromCookieSyncRequest(cookieSyncContext.getCookieSyncRequest(), cookieSyncContext.getRoutingContext().request(), cookieSyncContext.getAccount(), cookieSyncContext.getTimeout()).map(cookieSyncContext::with);
    }

    private void respondWithResult(CookieSyncContext cookieSyncContext, CookieSyncResponse cookieSyncResponse) {
        HttpResponseStatus status = HttpResponseStatus.OK;
        HttpUtil.executeSafely(cookieSyncContext.getRoutingContext(), Endpoint.cookie_sync, response -> response.setStatusCode(status.code()).putHeader(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON).end(this.mapper.encodeToString(cookieSyncResponse)));
        CookieSyncEvent event = CookieSyncEvent.builder().status(status.code()).bidderStatus(cookieSyncResponse.getBidderStatus()).build();
        this.analyticsDelegator.processEvent(event, cookieSyncContext.getPrivacyContext().getTcfContext());
    }

    private void respondWithError(Throwable error, RoutingContext routingContext) {
        String body;
        HttpResponseStatus status;
        TcfContext tcfContext = error instanceof CookieSyncException ? ((CookieSyncException)error).tcfContext : null;
        String message = error.getMessage();
        if (error instanceof InvalidCookieSyncRequestException) {
            status = HttpResponseStatus.BAD_REQUEST;
            body = "Invalid request format: " + message;
            this.metrics.updateUserSyncBadRequestMetric();
            BAD_REQUEST_LOGGER.info(message, this.logSamplingRate);
        } else if (error instanceof UnauthorizedUidsException) {
            status = HttpResponseStatus.UNAUTHORIZED;
            body = "Unauthorized: " + message;
            this.metrics.updateUserSyncOptoutMetric();
        } else if (error instanceof InvalidAccountConfigException) {
            status = HttpResponseStatus.BAD_REQUEST;
            body = "Invalid account configuration: " + message;
            BAD_REQUEST_LOGGER.info(message, this.logSamplingRate);
        } else {
            status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            body = "Unexpected setuid processing error: " + message;
            logger.warn((Object)body, error);
        }
        HttpUtil.executeSafely(routingContext, Endpoint.cookie_sync, response -> response.setStatusCode(status.code()).end(body));
        CookieSyncEvent cookieSyncEvent = CookieSyncEvent.error(status.code(), body);
        if (tcfContext == null) {
            this.analyticsDelegator.processEvent(cookieSyncEvent);
        } else {
            this.analyticsDelegator.processEvent(cookieSyncEvent, tcfContext);
        }
    }
}

