/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.floors.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.prebid.server.floors.model.PriceFloorSchema;

public final class PriceFloorModelGroup {
    private final String currency;
    @JsonProperty(value="skipRate")
    private final Integer skipRate;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="modelWeight")
    private final Integer modelWeight;
    private final PriceFloorSchema schema;
    private final Map<String, BigDecimal> values;
    @JsonProperty(value="default")
    private final BigDecimal defaultFloor;

    @ConstructorProperties(value={"currency", "skipRate", "modelVersion", "modelWeight", "schema", "values", "defaultFloor"})
    PriceFloorModelGroup(String currency, Integer skipRate, String modelVersion, Integer modelWeight, PriceFloorSchema schema, Map<String, BigDecimal> values, BigDecimal defaultFloor) {
        this.currency = currency;
        this.skipRate = skipRate;
        this.modelVersion = modelVersion;
        this.modelWeight = modelWeight;
        this.schema = schema;
        this.values = values;
        this.defaultFloor = defaultFloor;
    }

    public static PriceFloorModelGroupBuilder builder() {
        return new PriceFloorModelGroupBuilder();
    }

    public String getCurrency() {
        return this.currency;
    }

    public Integer getSkipRate() {
        return this.skipRate;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public Integer getModelWeight() {
        return this.modelWeight;
    }

    public PriceFloorSchema getSchema() {
        return this.schema;
    }

    public Map<String, BigDecimal> getValues() {
        return this.values;
    }

    public BigDecimal getDefaultFloor() {
        return this.defaultFloor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PriceFloorModelGroup)) {
            return false;
        }
        PriceFloorModelGroup other = (PriceFloorModelGroup)o;
        Integer this$skipRate = this.getSkipRate();
        Integer other$skipRate = other.getSkipRate();
        if (this$skipRate == null ? other$skipRate != null : !((Object)this$skipRate).equals(other$skipRate)) {
            return false;
        }
        Integer this$modelWeight = this.getModelWeight();
        Integer other$modelWeight = other.getModelWeight();
        if (this$modelWeight == null ? other$modelWeight != null : !((Object)this$modelWeight).equals(other$modelWeight)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        PriceFloorSchema this$schema = this.getSchema();
        PriceFloorSchema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
            return false;
        }
        Map<String, BigDecimal> this$values = this.getValues();
        Map<String, BigDecimal> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        BigDecimal this$defaultFloor = this.getDefaultFloor();
        BigDecimal other$defaultFloor = other.getDefaultFloor();
        return !(this$defaultFloor == null ? other$defaultFloor != null : !((Object)this$defaultFloor).equals(other$defaultFloor));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $skipRate = this.getSkipRate();
        result = result * 59 + ($skipRate == null ? 43 : ((Object)$skipRate).hashCode());
        Integer $modelWeight = this.getModelWeight();
        result = result * 59 + ($modelWeight == null ? 43 : ((Object)$modelWeight).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        PriceFloorSchema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        Map<String, BigDecimal> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        BigDecimal $defaultFloor = this.getDefaultFloor();
        result = result * 59 + ($defaultFloor == null ? 43 : ((Object)$defaultFloor).hashCode());
        return result;
    }

    public String toString() {
        return "PriceFloorModelGroup(currency=" + this.getCurrency() + ", skipRate=" + this.getSkipRate() + ", modelVersion=" + this.getModelVersion() + ", modelWeight=" + this.getModelWeight() + ", schema=" + this.getSchema() + ", values=" + this.getValues() + ", defaultFloor=" + this.getDefaultFloor() + ")";
    }

    public static class PriceFloorModelGroupBuilder {
        private String currency;
        private Integer skipRate;
        private String modelVersion;
        private Integer modelWeight;
        private PriceFloorSchema schema;
        private ArrayList<String> values$key;
        private ArrayList<BigDecimal> values$value;
        private BigDecimal defaultFloor;

        PriceFloorModelGroupBuilder() {
        }

        public PriceFloorModelGroupBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @JsonProperty(value="skipRate")
        public PriceFloorModelGroupBuilder skipRate(Integer skipRate) {
            this.skipRate = skipRate;
            return this;
        }

        @JsonProperty(value="modelVersion")
        public PriceFloorModelGroupBuilder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @JsonProperty(value="modelWeight")
        public PriceFloorModelGroupBuilder modelWeight(Integer modelWeight) {
            this.modelWeight = modelWeight;
            return this;
        }

        public PriceFloorModelGroupBuilder schema(PriceFloorSchema schema) {
            this.schema = schema;
            return this;
        }

        public PriceFloorModelGroupBuilder value(String valueKey, BigDecimal valueValue) {
            if (this.values$key == null) {
                this.values$key = new ArrayList();
                this.values$value = new ArrayList();
            }
            this.values$key.add(valueKey);
            this.values$value.add(valueValue);
            return this;
        }

        public PriceFloorModelGroupBuilder values(Map<? extends String, ? extends BigDecimal> values) {
            if (values == null) {
                throw new NullPointerException("values cannot be null");
            }
            if (this.values$key == null) {
                this.values$key = new ArrayList();
                this.values$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends BigDecimal> $lombokEntry : values.entrySet()) {
                this.values$key.add($lombokEntry.getKey());
                this.values$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PriceFloorModelGroupBuilder clearValues() {
            if (this.values$key != null) {
                this.values$key.clear();
                this.values$value.clear();
            }
            return this;
        }

        @JsonProperty(value="default")
        public PriceFloorModelGroupBuilder defaultFloor(BigDecimal defaultFloor) {
            this.defaultFloor = defaultFloor;
            return this;
        }

        public PriceFloorModelGroup build() {
            Map<String, BigDecimal> values;
            switch (this.values$key == null ? 0 : this.values$key.size()) {
                case 0: {
                    values = Collections.emptyMap();
                    break;
                }
                case 1: {
                    values = Collections.singletonMap(this.values$key.get(0), this.values$value.get(0));
                    break;
                }
                default: {
                    values = new LinkedHashMap(this.values$key.size() < 0x40000000 ? 1 + this.values$key.size() + (this.values$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.values$key.size(); ++$i) {
                        values.put(this.values$key.get($i), this.values$value.get($i));
                    }
                    values = Collections.unmodifiableMap(values);
                }
            }
            return new PriceFloorModelGroup(this.currency, this.skipRate, this.modelVersion, this.modelWeight, this.schema, values, this.defaultFloor);
        }

        public String toString() {
            return "PriceFloorModelGroup.PriceFloorModelGroupBuilder(currency=" + this.currency + ", skipRate=" + this.skipRate + ", modelVersion=" + this.modelVersion + ", modelWeight=" + this.modelWeight + ", schema=" + this.schema + ", values$key=" + this.values$key + ", values$value=" + this.values$value + ", defaultFloor=" + this.defaultFloor + ")";
        }
    }
}

