/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.floors;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Dooh;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Video;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.floors.PriceFloorResolver;
import org.prebid.server.floors.model.DeviceType;
import org.prebid.server.floors.model.PriceFloorData;
import org.prebid.server.floors.model.PriceFloorField;
import org.prebid.server.floors.model.PriceFloorModelGroup;
import org.prebid.server.floors.model.PriceFloorResult;
import org.prebid.server.floors.model.PriceFloorRules;
import org.prebid.server.floors.model.PriceFloorSchema;
import org.prebid.server.geolocation.CountryCodeMapper;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebidFloors;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidChannel;
import org.prebid.server.proto.openrtb.ext.request.ImpMediaType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.ObjectUtil;

public class BasicPriceFloorResolver
implements PriceFloorResolver {
    private static final Logger logger = LoggerFactory.getLogger(BasicPriceFloorResolver.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private static final String DEFAULT_RULES_CURRENCY = "USD";
    private static final String SCHEMA_DEFAULT_DELIMITER = "|";
    private static final String WILDCARD_CATCH_ALL = "*";
    private static final String VIDEO_ALIAS = "video-instream";
    private static final JsonPointer PB_ADSLOT_POINTER = JsonPointer.valueOf((String)"/data/pbadslot");
    private static final JsonPointer ADSLOT_POINTER = JsonPointer.valueOf((String)"/data/adserver/adslot");
    private static final JsonPointer ADSERVER_NAME_POINTER = JsonPointer.valueOf((String)"/data/adserver/name");
    private static final Set<String> PHONE_PATTERNS = Set.of("Phone", "iPhone", "Android.*Mobile", "Mobile.*Android");
    private static final Set<String> TABLET_PATTERNS = Set.of("tablet", "iPad", "Windows NT.*touch", "touch.*Windows NT", "Android");
    private static final String GPID_PATH = "/gpid";
    private static final String PBADSLOT_PATH = "/data/pbadslot";
    private static final String STORED_REQUEST_ID_PATH = "/prebid/storedrequest/id";
    private final CurrencyConversionService currencyConversionService;
    private final CountryCodeMapper countryCodeMapper;
    private final Metrics metrics;
    private final JacksonMapper mapper;

    public BasicPriceFloorResolver(CurrencyConversionService currencyConversionService, CountryCodeMapper countryCodeMapper, Metrics metrics, JacksonMapper mapper) {
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.countryCodeMapper = Objects.requireNonNull(countryCodeMapper);
        this.metrics = Objects.requireNonNull(metrics);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public PriceFloorResult resolve(BidRequest bidRequest, PriceFloorRules floorRules, Imp imp, ImpMediaType mediaType, Format format, List<String> warnings) {
        if (BasicPriceFloorResolver.isPriceFloorsDisabledForRequest(bidRequest)) {
            return null;
        }
        PriceFloorModelGroup modelGroup = BasicPriceFloorResolver.extractFloorModelGroup(floorRules);
        if (modelGroup == null) {
            return null;
        }
        PriceFloorSchema schema = modelGroup.getSchema();
        if (schema == null || CollectionUtils.isEmpty(schema.getFields())) {
            return null;
        }
        if (MapUtils.isEmpty(modelGroup.getValues())) {
            return null;
        }
        String delimiter = (String)ObjectUtils.defaultIfNull((Object)schema.getDelimiter(), (Object)SCHEMA_DEFAULT_DELIMITER);
        List<List<String>> desiredRuleKey = this.createRuleKey(schema, bidRequest, imp, mediaType, format);
        Map<String, BigDecimal> rules = BasicPriceFloorResolver.keysToLowerCase(modelGroup.getValues());
        String rule = BasicPriceFloorResolver.findRule(rules, delimiter, desiredRuleKey);
        BigDecimal floorForRule = rule != null ? rules.get(rule) : null;
        BigDecimal floor = floorForRule != null ? floorForRule : modelGroup.getDefaultFloor();
        String modelGroupCurrency = modelGroup.getCurrency();
        String floorCurrency = StringUtils.isNotEmpty((CharSequence)modelGroupCurrency) ? modelGroupCurrency : BasicPriceFloorResolver.getDataCurrency(floorRules);
        try {
            return this.resolveResult(floor, rule, floorForRule, imp, bidRequest, floorCurrency, warnings);
        }
        catch (PreBidException e) {
            String logMessage = "Error occurred while resolving floor for imp: %s, cause: %s".formatted(imp.getId(), e.getMessage());
            if (warnings != null) {
                warnings.add(logMessage);
            }
            logger.debug((Object)logMessage);
            conditionalLogger.error(logMessage, 0.01);
            this.metrics.updatePriceFloorGeneralAlertsMetric(MetricName.err);
            return null;
        }
    }

    private static boolean isPriceFloorsDisabledForRequest(BidRequest bidRequest) {
        PriceFloorRules requestFloors = BasicPriceFloorResolver.extractRequestFloors(bidRequest);
        Boolean enabled = ObjectUtil.getIfNotNull(requestFloors, PriceFloorRules::getEnabled);
        Boolean skipped = ObjectUtil.getIfNotNull(requestFloors, PriceFloorRules::getSkipped);
        return BooleanUtils.isFalse((Boolean)enabled) || BooleanUtils.isTrue((Boolean)skipped);
    }

    private static PriceFloorRules extractRequestFloors(BidRequest bidRequest) {
        ExtRequestPrebid prebid = ObjectUtil.getIfNotNull(bidRequest.getExt(), ExtRequest::getPrebid);
        return ObjectUtil.getIfNotNull(prebid, ExtRequestPrebid::getFloors);
    }

    private static PriceFloorModelGroup extractFloorModelGroup(PriceFloorRules floors) {
        PriceFloorData data = ObjectUtil.getIfNotNull(floors, PriceFloorRules::getData);
        List modelGroups = ObjectUtil.getIfNotNull(data, PriceFloorData::getModelGroups);
        return CollectionUtils.isNotEmpty((Collection)modelGroups) ? (PriceFloorModelGroup)modelGroups.get(0) : null;
    }

    private List<List<String>> createRuleKey(PriceFloorSchema schema, BidRequest bidRequest, Imp imp, ImpMediaType mediaType, Format format) {
        return schema.getFields().stream().map(field -> this.toFieldValues((PriceFloorField)((Object)field), bidRequest, imp, mediaType, format)).map(BasicPriceFloorResolver::prepareFieldValues).toList();
    }

    private List<String> toFieldValues(PriceFloorField field, BidRequest bidRequest, Imp imp, ImpMediaType mediaType, Format format) {
        List<ImpMediaType> resolvedMediaTypes = mediaType != null ? Collections.singletonList(mediaType) : BasicPriceFloorResolver.mediaTypesFromImp(imp);
        return switch (field) {
            default -> throw new IncompatibleClassChangeError();
            case PriceFloorField.siteDomain -> BasicPriceFloorResolver.siteDomainFromRequest(bidRequest);
            case PriceFloorField.pubDomain -> BasicPriceFloorResolver.pubDomainFromRequest(bidRequest);
            case PriceFloorField.domain -> BasicPriceFloorResolver.domainFromRequest(bidRequest);
            case PriceFloorField.bundle -> BasicPriceFloorResolver.bundleFromRequest(bidRequest);
            case PriceFloorField.channel -> BasicPriceFloorResolver.channelFromRequest(bidRequest);
            case PriceFloorField.mediaType -> BasicPriceFloorResolver.mediaTypeToRuleKey(resolvedMediaTypes);
            case PriceFloorField.size -> BasicPriceFloorResolver.sizeFromFormat((Format)ObjectUtils.defaultIfNull((Object)format, (Object)BasicPriceFloorResolver.resolveFormatFromImp(imp, resolvedMediaTypes)));
            case PriceFloorField.gptSlot -> BasicPriceFloorResolver.gptAdSlotFromImp(imp);
            case PriceFloorField.adUnitCode -> BasicPriceFloorResolver.adUnitCodeFromImp(imp);
            case PriceFloorField.country -> this.countryFromRequest(bidRequest);
            case PriceFloorField.deviceType -> BasicPriceFloorResolver.resolveDeviceTypeFromRequest(bidRequest);
        };
    }

    private static List<ImpMediaType> mediaTypesFromImp(Imp imp) {
        Video video;
        ArrayList<ImpMediaType> impMediaTypes = new ArrayList<ImpMediaType>();
        if (imp.getBanner() != null) {
            impMediaTypes.add(ImpMediaType.banner);
        }
        if ((video = imp.getVideo()) != null) {
            Integer placement = video.getPlacement();
            if (placement == null || Objects.equals(placement, 1)) {
                impMediaTypes.add(ImpMediaType.video);
            } else {
                impMediaTypes.add(ImpMediaType.video_outstream);
            }
        }
        if (imp.getXNative() != null) {
            impMediaTypes.add(ImpMediaType.xNative);
        }
        if (imp.getAudio() != null) {
            impMediaTypes.add(ImpMediaType.audio);
        }
        return impMediaTypes;
    }

    private static List<String> siteDomainFromRequest(BidRequest bidRequest) {
        return Optional.ofNullable(bidRequest.getSite()).map(Site::getDomain).or(() -> Optional.ofNullable(bidRequest.getApp()).map(App::getDomain)).or(() -> Optional.ofNullable(bidRequest.getDooh()).map(Dooh::getDomain)).map(List::of).orElse(Collections.emptyList());
    }

    private static List<String> pubDomainFromRequest(BidRequest bidRequest) {
        return Optional.ofNullable(bidRequest.getSite()).map(Site::getPublisher).or(() -> Optional.ofNullable(bidRequest.getApp()).map(App::getPublisher)).or(() -> Optional.ofNullable(bidRequest.getDooh()).map(Dooh::getPublisher)).map(Publisher::getDomain).map(List::of).orElse(Collections.emptyList());
    }

    private static List<String> domainFromRequest(BidRequest bidRequest) {
        return ListUtils.union(BasicPriceFloorResolver.siteDomainFromRequest(bidRequest), BasicPriceFloorResolver.pubDomainFromRequest(bidRequest));
    }

    private static List<String> bundleFromRequest(BidRequest bidRequest) {
        App app = bidRequest.getApp();
        String appBundle = ObjectUtil.getIfNotNull(app, App::getBundle);
        return Collections.singletonList(appBundle);
    }

    private static List<String> channelFromRequest(BidRequest bidRequest) {
        ExtRequest extRequest = bidRequest.getExt();
        ExtRequestPrebid prebid = ObjectUtil.getIfNotNull(extRequest, ExtRequest::getPrebid);
        ExtRequestPrebidChannel channel = ObjectUtil.getIfNotNull(prebid, ExtRequestPrebid::getChannel);
        String channelName = ObjectUtil.getIfNotNull(channel, ExtRequestPrebidChannel::getName);
        return Collections.singletonList(channelName);
    }

    private static List<String> mediaTypeToRuleKey(List<ImpMediaType> impMediaTypes) {
        if (CollectionUtils.isEmpty(impMediaTypes) || CollectionUtils.size(impMediaTypes) > 1) {
            return Collections.singletonList(WILDCARD_CATCH_ALL);
        }
        ImpMediaType impMediaType = impMediaTypes.get(0);
        if (impMediaType == ImpMediaType.video) {
            return List.of(impMediaType.toString(), VIDEO_ALIAS);
        }
        return Collections.singletonList(impMediaType.toString());
    }

    private static Format resolveFormatFromImp(Imp imp, List<ImpMediaType> mediaTypes) {
        if (CollectionUtils.isEmpty(mediaTypes) || CollectionUtils.size(mediaTypes) > 1) {
            return null;
        }
        ImpMediaType mediaType = mediaTypes.get(0);
        if (mediaType == ImpMediaType.banner) {
            return BasicPriceFloorResolver.resolveFormatFromBannerImp(imp);
        }
        if (mediaType == ImpMediaType.video) {
            return BasicPriceFloorResolver.resolveFormatFromVideoImp(imp);
        }
        return null;
    }

    private static Format resolveFormatFromBannerImp(Imp imp) {
        Banner banner = imp.getBanner();
        List formats = ObjectUtil.getIfNotNull(banner, Banner::getFormat);
        int formatsSize = CollectionUtils.size((Object)formats);
        if (formatsSize == 1) {
            return (Format)formats.get(0);
        }
        if (formatsSize > 1) {
            return null;
        }
        Integer bannerWidth = ObjectUtil.getIfNotNull(banner, Banner::getW);
        Integer bannerHeight = ObjectUtil.getIfNotNull(banner, Banner::getH);
        return ObjectUtils.allNotNull((Object[])new Object[]{bannerWidth, bannerHeight}) ? Format.builder().w(bannerWidth).h(bannerHeight).build() : null;
    }

    private static Format resolveFormatFromVideoImp(Imp imp) {
        Video video = imp.getVideo();
        Integer videoWidth = ObjectUtil.getIfNotNull(video, Video::getW);
        Integer videoHeight = ObjectUtil.getIfNotNull(video, Video::getH);
        return ObjectUtils.allNotNull((Object[])new Object[]{videoWidth, videoHeight}) ? Format.builder().w(videoWidth).h(videoHeight).build() : null;
    }

    private static List<String> sizeFromFormat(Format size) {
        String sizeRuleKey = size != null ? "%dx%d".formatted(size.getW(), size.getH()) : WILDCARD_CATCH_ALL;
        return Collections.singletonList(sizeRuleKey);
    }

    private static List<String> gptAdSlotFromImp(Imp imp) {
        ObjectNode impExt = imp.getExt();
        if (impExt == null) {
            return Collections.singletonList(WILDCARD_CATCH_ALL);
        }
        JsonNode adServerNameNode = impExt.at(ADSERVER_NAME_POINTER);
        JsonNode adSlotNode = adServerNameNode.isTextual() && Objects.equals(adServerNameNode.asText(), "gam") ? impExt.at(ADSLOT_POINTER) : impExt.at(PB_ADSLOT_POINTER);
        String gptAdSlot = !adSlotNode.isMissingNode() ? adSlotNode.asText() : null;
        return Collections.singletonList(gptAdSlot);
    }

    private static List<String> adUnitCodeFromImp(Imp imp) {
        ObjectNode impExt = imp.getExt();
        String tagId = imp.getTagid();
        if (impExt == null) {
            return BasicPriceFloorResolver.catchAllIfBlank(tagId);
        }
        String gpid = BasicPriceFloorResolver.stringByPath(impExt, GPID_PATH);
        if (StringUtils.isNotBlank((CharSequence)gpid)) {
            return Collections.singletonList(gpid);
        }
        if (StringUtils.isNotBlank((CharSequence)tagId)) {
            return Collections.singletonList(tagId);
        }
        String adSlot = BasicPriceFloorResolver.stringByPath(impExt, PBADSLOT_PATH);
        if (StringUtils.isNotBlank((CharSequence)adSlot)) {
            return Collections.singletonList(adSlot);
        }
        String storedRequestId = BasicPriceFloorResolver.stringByPath(impExt, STORED_REQUEST_ID_PATH);
        return BasicPriceFloorResolver.catchAllIfBlank(storedRequestId);
    }

    private static List<String> catchAllIfBlank(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Collections.singletonList(value) : Collections.singletonList(WILDCARD_CATCH_ALL);
    }

    private static String stringByPath(ObjectNode node, String path) {
        JsonNode gpidNode = node.at(path);
        return !gpidNode.isMissingNode() ? gpidNode.asText() : null;
    }

    private List<String> countryFromRequest(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        Geo geo = ObjectUtil.getIfNotNull(device, Device::getGeo);
        String country = ObjectUtil.getIfNotNull(geo, Geo::getCountry);
        String alpha3Code = StringUtils.isNotBlank((CharSequence)country) ? this.countryCodeMapper.mapToAlpha3(country) : null;
        String countryRuleKey = StringUtils.isNotBlank((CharSequence)alpha3Code) ? alpha3Code : country;
        return Collections.singletonList(countryRuleKey);
    }

    public static List<String> resolveDeviceTypeFromRequest(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        String userAgent = ObjectUtil.getIfNotNull(device, Device::getUa);
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return Collections.singletonList(WILDCARD_CATCH_ALL);
        }
        for (String pattern : PHONE_PATTERNS) {
            if (!userAgent.matches(pattern)) continue;
            return Collections.singletonList(DeviceType.phone.name());
        }
        for (String pattern : TABLET_PATTERNS) {
            if (!userAgent.matches(pattern)) continue;
            return Collections.singletonList(DeviceType.tablet.name());
        }
        return Collections.singletonList(DeviceType.desktop.name());
    }

    private static List<String> prepareFieldValues(List<String> fieldValues) {
        List<String> preparedFieldValues = CollectionUtils.emptyIfNull(fieldValues).stream().filter(StringUtils::isNotEmpty).map(String::toLowerCase).toList();
        if (CollectionUtils.isEmpty(preparedFieldValues)) {
            return Collections.singletonList(WILDCARD_CATCH_ALL);
        }
        return preparedFieldValues;
    }

    private static String findRule(Map<String, BigDecimal> rules, String delimiter, List<List<String>> desiredRuleKey) {
        return RuleKeyCandidateIterator.from(desiredRuleKey, delimiter).asStream().filter(rules::containsKey).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static <V> Map<String, V> keysToLowerCase(Map<String, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
    }

    private static String getDataCurrency(PriceFloorRules rules) {
        PriceFloorData data = ObjectUtil.getIfNotNull(rules, PriceFloorRules::getData);
        return ObjectUtil.getIfNotNull(data, PriceFloorData::getCurrency);
    }

    private PriceFloorResult resolveResult(BigDecimal floor, String rule, BigDecimal floorForRule, Imp imp, BidRequest bidRequest, String rulesCurrency, List<String> warnings) {
        if (floor == null) {
            return null;
        }
        Price floorMinValues = this.resolveFloorMin(bidRequest, imp, warnings);
        BigDecimal floorMin = floorMinValues.getValue();
        String floorMinCur = floorMinValues.getCurrency();
        String effectiveRulesCurrency = (String)ObjectUtils.defaultIfNull((Object)rulesCurrency, (Object)DEFAULT_RULES_CURRENCY);
        String effectiveFloorMinCurrency = (String)ObjectUtils.firstNonNull((Object[])new String[]{floorMinCur, rulesCurrency, DEFAULT_RULES_CURRENCY});
        BigDecimal convertedFloorMinValue = !StringUtils.equals((CharSequence)effectiveRulesCurrency, (CharSequence)effectiveFloorMinCurrency) ? this.currencyConversionService.convertCurrency(floorMin, bidRequest, effectiveFloorMinCurrency, effectiveRulesCurrency) : null;
        Price effectiveFloor = Price.of(effectiveRulesCurrency, floor);
        Price effectiveFloorMin = Price.of(effectiveFloorMinCurrency, floorMin);
        Price convertedFloorMin = convertedFloorMinValue != null ? Price.of(effectiveRulesCurrency, convertedFloorMinValue) : Price.of(effectiveFloorMinCurrency, floorMin);
        Price resolvedPrice = BasicPriceFloorResolver.resolvePrice(effectiveFloor, convertedFloorMin, effectiveFloorMin);
        return PriceFloorResult.of(rule, floorForRule, ObjectUtil.getIfNotNull(resolvedPrice, Price::getValue), ObjectUtil.getIfNotNull(resolvedPrice, Price::getCurrency));
    }

    private Price resolveFloorMin(BidRequest bidRequest, Imp imp, List<String> warnings) {
        Optional<ExtImpPrebidFloors> extImpPrebidFloors = Optional.ofNullable(imp.getExt()).map(ext -> ext.get("prebid")).map(this::extImpPrebid).map(ExtImpPrebid::getFloors);
        BigDecimal impFloorMin = extImpPrebidFloors.map(ExtImpPrebidFloors::getFloorMin).orElse(null);
        String impFloorMinCur = extImpPrebidFloors.map(ExtImpPrebidFloors::getFloorMinCur).orElse(null);
        Optional<PriceFloorRules> floorRules = BasicPriceFloorResolver.extractRules(bidRequest);
        BigDecimal requestFloorMin = floorRules.map(PriceFloorRules::getFloorMin).orElse(null);
        String requestFloorMinCur = floorRules.map(PriceFloorRules::getFloorMinCur).orElse(null);
        if (ObjectUtils.allNotNull((Object[])new Object[]{impFloorMinCur, requestFloorMinCur}) && !impFloorMinCur.equals(requestFloorMinCur)) {
            warnings.add("imp[].ext.prebid.floors.floorMinCur and ext.prebid.floors.floorMinCur has different values");
        }
        return Price.of((String)ObjectUtils.defaultIfNull((Object)impFloorMinCur, (Object)requestFloorMinCur), (BigDecimal)ObjectUtils.defaultIfNull((Object)impFloorMin, (Object)requestFloorMin));
    }

    private ExtImpPrebid extImpPrebid(JsonNode extImpPrebid) {
        try {
            return (ExtImpPrebid)this.mapper.mapper().treeToValue((TreeNode)extImpPrebid, ExtImpPrebid.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Error decoding imp.ext.prebid: " + e.getMessage(), e);
        }
    }

    private static Optional<PriceFloorRules> extractRules(BidRequest bidRequest) {
        return Optional.ofNullable(bidRequest).map(BidRequest::getExt).map(ExtRequest::getPrebid).map(ExtRequestPrebid::getFloors);
    }

    private static Price roundPrice(Price price) {
        return price != null ? Price.of(price.getCurrency(), BidderUtil.roundFloor(price.getValue())) : null;
    }

    private static Price resolvePrice(Price floor, Price convertedFloorMin, Price floorMin) {
        BigDecimal floorValue = ObjectUtil.getIfNotNull(floor, Price::getValue);
        String floorCurrency = ObjectUtil.getIfNotNull(floor, Price::getCurrency);
        BigDecimal floorMinValue = ObjectUtil.getIfNotNull(convertedFloorMin, Price::getValue);
        String floorMinCurrency = ObjectUtil.getIfNotNull(floor, Price::getCurrency);
        if (StringUtils.equals((CharSequence)floorCurrency, (CharSequence)floorMinCurrency) && floorValue != null && floorMinValue != null) {
            return floorValue.compareTo(floorMinValue) > 0 ? BasicPriceFloorResolver.roundPrice(floor) : BasicPriceFloorResolver.roundPrice(convertedFloorMin);
        }
        return BasicPriceFloorResolver.roundPrice((Price)ObjectUtils.defaultIfNull((Object)floor, (Object)floorMin));
    }

    private static class RuleKeyCandidateIterator
    implements Iterator<String> {
        private final List<List<String>> desiredRuleKey;
        private final String delimiter;
        private int wildcardNum;
        private Iterator<String> currentIterator = null;
        private final List<Integer> implicitWildcardIndexes;

        private RuleKeyCandidateIterator(List<List<String>> desiredRuleKey, String delimiter) {
            this.desiredRuleKey = desiredRuleKey;
            this.delimiter = delimiter;
            this.implicitWildcardIndexes = RuleKeyCandidateIterator.findImplicitWildcards(desiredRuleKey);
            this.wildcardNum = this.implicitWildcardIndexes.size();
        }

        public static RuleKeyCandidateIterator from(List<List<String>> desiredRuleKey, String delimiter) {
            return new RuleKeyCandidateIterator(desiredRuleKey, delimiter);
        }

        @Override
        public boolean hasNext() {
            return this.wildcardNum <= this.desiredRuleKey.size();
        }

        @Override
        public String next() {
            if (this.currentIterator == null && this.wildcardNum <= this.desiredRuleKey.size()) {
                this.currentIterator = this.createIterator(this.wildcardNum, this.desiredRuleKey, this.delimiter);
            }
            if (this.currentIterator != null) {
                String candidate = this.currentIterator.next();
                if (!this.currentIterator.hasNext()) {
                    this.currentIterator = null;
                    ++this.wildcardNum;
                }
                return candidate;
            }
            throw new NoSuchElementException();
        }

        public Stream<String> asStream() {
            return RuleKeyCandidateIterator.asStream(this);
        }

        private static <T> Stream<T> asStream(Iterator<T> iterator) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
        }

        private static List<Integer> findImplicitWildcards(List<List<String>> desiredRuleKey) {
            return IntStream.range(0, desiredRuleKey.size()).filter(i -> ((String)((List)desiredRuleKey.get(i)).get(0)).equals(BasicPriceFloorResolver.WILDCARD_CATCH_ALL)).boxed().toList();
        }

        private Iterator<String> createIterator(int wildcardNum, List<List<String>> desiredRuleKey, String delimiter) {
            int ruleSegmentsNum = desiredRuleKey.size();
            return RuleKeyCandidateIterator.asStream(CombinatoricsUtils.combinationsIterator((int)ruleSegmentsNum, (int)wildcardNum)).map(combination -> IntStream.of(combination).boxed().toList()).filter(combination -> combination.containsAll(this.implicitWildcardIndexes)).sorted(Comparator.comparingInt(combination -> RuleKeyCandidateIterator.calculateWeight(combination, ruleSegmentsNum))).flatMap(combination -> RuleKeyCandidateIterator.combinationToCandidate(combination, desiredRuleKey, delimiter).stream()).iterator();
        }

        private static Integer calculateWeight(List<Integer> combination, int ruleSegmentsNum) {
            return combination.stream().mapToInt(i -> 1 << ruleSegmentsNum - i).sum();
        }

        private static Set<String> combinationToCandidate(List<Integer> combination, List<List<String>> desiredRuleKey, String delimiter) {
            int biggestRuleKeySize = desiredRuleKey.stream().mapToInt(List::size).boxed().max(Integer::compare).orElse(0);
            List candidates = IntStream.range(0, desiredRuleKey.size()).boxed().map(position -> RuleKeyCandidateIterator.candidatesForPosition(position, desiredRuleKey, biggestRuleKeySize)).flatMap(Collection::stream).toList();
            for (int positionToReplace : combination) {
                candidates.forEach(candidate -> candidate.set(positionToReplace, BasicPriceFloorResolver.WILDCARD_CATCH_ALL));
            }
            return candidates.stream().map(candidate -> String.join((CharSequence)delimiter, candidate)).collect(Collectors.toSet());
        }

        private static List<List<String>> candidatesForPosition(int multPosition, List<List<String>> desiredRuleKey, int biggestRuleKeySize) {
            return desiredRuleKey.get(multPosition).stream().flatMap(ruleKey -> IntStream.range(0, biggestRuleKeySize).mapToObj(i -> RuleKeyCandidateIterator.candidateForPosition(desiredRuleKey, ruleKey, multPosition, i))).toList();
        }

        private static List<String> candidateForPosition(List<List<String>> desiredRuleKey, String currentRuleKey, int currentPosition, int position) {
            return IntStream.range(0, desiredRuleKey.size()).mapToObj(index -> {
                if (index == currentPosition) {
                    return currentRuleKey;
                }
                return RuleKeyCandidateIterator.getLastOrNext((List)desiredRuleKey.get(index), position);
            }).collect(Collectors.toCollection(ArrayList::new));
        }

        private static String getLastOrNext(List<String> ruleKeys, int index) {
            if (ruleKeys.size() <= index) {
                return ruleKeys.get(ruleKeys.size() - 1);
            }
            return (String)IterableUtils.get(ruleKeys, (int)index);
        }
    }
}

