/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.execution;

import java.time.Clock;

public class Timeout {
    private final Clock clock;
    private final long deadline;

    Timeout(Clock clock, long deadline) {
        this.clock = clock;
        this.deadline = deadline;
    }

    public Timeout minus(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Amount must be non-negative");
        }
        return new Timeout(this.clock, this.deadline - amount);
    }

    public long remaining() {
        return Math.max(this.deadline - this.clock.millis(), 0L);
    }

    public long getDeadline() {
        return this.deadline;
    }
}

