/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting.syntax;

import java.util.Arrays;

public enum MatchingFunction {
    MATCHES("$matches"),
    IN("$in"),
    INTERSECTS("$intersects"),
    WITHIN("$within");

    private final String value;

    private MatchingFunction(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static boolean isMatchingFunction(String candidate) {
        return Arrays.stream(MatchingFunction.values()).anyMatch(op -> op.value.equals(candidate));
    }

    public static MatchingFunction fromString(String candidate) {
        for (MatchingFunction op : MatchingFunction.values()) {
            if (!op.value.equals(candidate)) continue;
            return op;
        }
        throw new IllegalArgumentException("Unrecognized matching function: " + candidate);
    }
}

