/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Segment;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.prebid.server.deals.model.TxnLog;
import org.prebid.server.deals.targeting.model.GeoLocation;
import org.prebid.server.deals.targeting.model.LookupResult;
import org.prebid.server.deals.targeting.model.Size;
import org.prebid.server.deals.targeting.syntax.TargetingCategory;
import org.prebid.server.exception.TargetingSyntaxException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtApp;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.ExtUserTime;
import org.prebid.server.util.StreamUtil;

public class RequestContext {
    private static final String EXT_BIDDER = "bidder.";
    private static final String EXT_CONTEXT_DATA = "context.data.";
    private static final String EXT_DATA = "data.";
    private final BidRequest bidRequest;
    private final Imp imp;
    private final TxnLog txnLog;
    private final AttributeReader<Imp> impReader;
    private final AttributeReader<Geo> geoReader;
    private final AttributeReader<Device> deviceReader;
    private final AttributeReader<User> userReader;
    private final AttributeReader<Site> siteReader;
    private final AttributeReader<App> appReader;

    public RequestContext(BidRequest bidRequest, Imp imp, TxnLog txnLog, JacksonMapper mapper) {
        this.bidRequest = Objects.requireNonNull(bidRequest);
        this.imp = Objects.requireNonNull(imp);
        this.txnLog = Objects.requireNonNull(txnLog);
        this.impReader = AttributeReader.forImp();
        this.geoReader = AttributeReader.forGeo(RequestContext.getExtNode(bidRequest.getDevice(), device -> RequestContext.getIfNotNull(RequestContext.getIfNotNull(device, Device::getGeo), Geo::getExt), mapper));
        this.deviceReader = AttributeReader.forDevice(RequestContext.getExtNode(bidRequest.getDevice(), Device::getExt, mapper));
        this.userReader = AttributeReader.forUser();
        this.siteReader = AttributeReader.forSite();
        this.appReader = AttributeReader.forApp();
    }

    private static <T> ObjectNode getExtNode(T target, Function<T, FlexibleExtension> extExtractor, JacksonMapper mapper) {
        FlexibleExtension ext = target != null ? extExtractor.apply(target) : null;
        return ext != null ? (ObjectNode)mapper.mapper().valueToTree((Object)ext) : null;
    }

    public LookupResult<String> lookupString(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        String path = category.path();
        return switch (type) {
            case TargetingCategory.Type.domain -> RequestContext.lookupResult(RequestContext.getIfNotNull(this.bidRequest.getSite(), Site::getDomain), RequestContext.getIfNotNull(RequestContext.getIfNotNull(this.bidRequest.getSite(), Site::getPublisher), Publisher::getDomain));
            case TargetingCategory.Type.publisherDomain -> RequestContext.lookupResult(RequestContext.getIfNotNull(RequestContext.getIfNotNull(this.bidRequest.getSite(), Site::getPublisher), Publisher::getDomain));
            case TargetingCategory.Type.referrer -> RequestContext.lookupResult(RequestContext.getIfNotNull(this.bidRequest.getSite(), Site::getPage));
            case TargetingCategory.Type.appBundle -> RequestContext.lookupResult(RequestContext.getIfNotNull(this.bidRequest.getApp(), App::getBundle));
            case TargetingCategory.Type.adslot -> RequestContext.lookupResult(this.imp.getTagid(), this.impReader.readFromExt(this.imp, "gpid", RequestContext::nodeToString), this.impReader.readFromExt(this.imp, "data.pbadslot", RequestContext::nodeToString), this.impReader.readFromExt(this.imp, "data.adserver.adslot", RequestContext::nodeToString));
            case TargetingCategory.Type.deviceGeoExt -> RequestContext.lookupResult(this.geoReader.readFromExt(RequestContext.getIfNotNull(this.bidRequest.getDevice(), Device::getGeo), path, RequestContext::nodeToString));
            case TargetingCategory.Type.deviceExt -> RequestContext.lookupResult(this.deviceReader.readFromExt(this.bidRequest.getDevice(), path, RequestContext::nodeToString));
            case TargetingCategory.Type.bidderParam -> RequestContext.lookupResult(this.impReader.readFromExt(this.imp, EXT_BIDDER + path, RequestContext::nodeToString));
            case TargetingCategory.Type.userFirstPartyData -> this.userReader.read(this.bidRequest.getUser(), path, RequestContext::nodeToString, String.class);
            case TargetingCategory.Type.siteFirstPartyData -> this.getSiteFirstPartyData(path, RequestContext::nodeToString);
            default -> LookupResult.empty();
        };
    }

    public LookupResult<Integer> lookupInteger(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        String path = category.path();
        return switch (type) {
            case TargetingCategory.Type.pagePosition -> RequestContext.lookupResult(RequestContext.getIfNotNull(RequestContext.getIfNotNull(this.imp, Imp::getBanner), Banner::getPos));
            case TargetingCategory.Type.dow -> RequestContext.lookupResult(RequestContext.getIfNotNull(RequestContext.getIfNotNull(RequestContext.getIfNotNull(this.bidRequest.getUser(), User::getExt), ExtUser::getTime), ExtUserTime::getUserdow));
            case TargetingCategory.Type.hour -> RequestContext.lookupResult(RequestContext.getIfNotNull(RequestContext.getIfNotNull(RequestContext.getIfNotNull(this.bidRequest.getUser(), User::getExt), ExtUser::getTime), ExtUserTime::getUserhour));
            case TargetingCategory.Type.deviceGeoExt -> RequestContext.lookupResult(this.geoReader.readFromExt(RequestContext.getIfNotNull(this.bidRequest.getDevice(), Device::getGeo), path, RequestContext::nodeToInteger));
            case TargetingCategory.Type.bidderParam -> RequestContext.lookupResult(this.impReader.readFromExt(this.imp, EXT_BIDDER + path, RequestContext::nodeToInteger));
            case TargetingCategory.Type.userFirstPartyData -> this.userReader.read(this.bidRequest.getUser(), path, RequestContext::nodeToInteger, Integer.class);
            case TargetingCategory.Type.siteFirstPartyData -> this.getSiteFirstPartyData(path, RequestContext::nodeToInteger);
            default -> LookupResult.empty();
        };
    }

    public LookupResult<List<String>> lookupStrings(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        String path = category.path();
        User user = this.bidRequest.getUser();
        return switch (type) {
            case TargetingCategory.Type.mediaType -> RequestContext.lookupResult(this.getMediaTypes());
            case TargetingCategory.Type.bidderParam -> RequestContext.lookupResult(this.impReader.readFromExt(this.imp, EXT_BIDDER + path, RequestContext::nodeToListOfStrings));
            case TargetingCategory.Type.userSegment -> RequestContext.lookupResult(this.getSegments(category));
            case TargetingCategory.Type.userFirstPartyData -> RequestContext.lookupResult(RequestContext.listOfNonNulls(this.userReader.readFromObject(user, path, String.class)), this.userReader.readFromExt(user, path, RequestContext::nodeToListOfStrings));
            case TargetingCategory.Type.siteFirstPartyData -> this.getSiteFirstPartyData(path, RequestContext::nodeToListOfStrings);
            default -> LookupResult.empty();
        };
    }

    public LookupResult<List<Integer>> lookupIntegers(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        String path = category.path();
        User user = this.bidRequest.getUser();
        return switch (type) {
            case TargetingCategory.Type.bidderParam -> RequestContext.lookupResult(this.impReader.readFromExt(this.imp, EXT_BIDDER + path, RequestContext::nodeToListOfIntegers));
            case TargetingCategory.Type.userFirstPartyData -> RequestContext.lookupResult(RequestContext.listOfNonNulls(this.userReader.readFromObject(user, path, Integer.class)), this.userReader.readFromExt(user, path, RequestContext::nodeToListOfIntegers));
            case TargetingCategory.Type.siteFirstPartyData -> this.getSiteFirstPartyData(path, RequestContext::nodeToListOfIntegers);
            default -> LookupResult.empty();
        };
    }

    public LookupResult<List<Size>> lookupSizes(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        if (type != TargetingCategory.Type.size) {
            throw new TargetingSyntaxException("Unexpected category for fetching sizes for: " + type);
        }
        List sizes = ListUtils.union(RequestContext.sizesFromBanner(this.imp), RequestContext.sizesFromVideo(this.imp));
        return !sizes.isEmpty() ? LookupResult.ofValue(sizes) : LookupResult.empty();
    }

    private static List<Size> sizesFromBanner(Imp imp) {
        List formats = RequestContext.getIfNotNull(imp.getBanner(), Banner::getFormat);
        return ListUtils.emptyIfNull((List)formats).stream().map(format -> Size.of(format.getW(), format.getH())).toList();
    }

    private static List<Size> sizesFromVideo(Imp imp) {
        Video video = imp.getVideo();
        Integer width = video != null ? video.getW() : null;
        Integer height = video != null ? video.getH() : null;
        return width != null && height != null ? Collections.singletonList(Size.of(width, height)) : Collections.emptyList();
    }

    public GeoLocation lookupGeoLocation(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        if (type != TargetingCategory.Type.location) {
            throw new TargetingSyntaxException("Unexpected category for fetching geo location for: " + type);
        }
        Geo geo = RequestContext.getIfNotNull(RequestContext.getIfNotNull(this.bidRequest, BidRequest::getDevice), Device::getGeo);
        Float lat = RequestContext.getIfNotNull(geo, Geo::getLat);
        Float lon = RequestContext.getIfNotNull(geo, Geo::getLon);
        return lat != null && lon != null ? GeoLocation.of(lat, lon) : null;
    }

    public TxnLog txnLog() {
        return this.txnLog;
    }

    @SafeVarargs
    private static <T> LookupResult<T> lookupResult(T ... candidates) {
        return LookupResult.of(RequestContext.listOfNonNulls(candidates));
    }

    @SafeVarargs
    private static <T> List<T> listOfNonNulls(T ... candidates) {
        return Stream.of(candidates).filter(Objects::nonNull).toList();
    }

    private static <S, T> T getIfNotNull(S source, Function<S, T> getter) {
        return source != null ? (T)getter.apply(source) : null;
    }

    private List<String> getMediaTypes() {
        ArrayList<String> mediaTypes = new ArrayList<String>();
        if (this.imp.getBanner() != null) {
            mediaTypes.add("banner");
        }
        if (this.imp.getVideo() != null) {
            mediaTypes.add("video");
        }
        if (this.imp.getXNative() != null) {
            mediaTypes.add("native");
        }
        return mediaTypes;
    }

    private <T> LookupResult<T> getSiteFirstPartyData(String path, Function<JsonNode, T> valueExtractor) {
        return RequestContext.lookupResult(this.impReader.readFromExt(this.imp, EXT_CONTEXT_DATA + path, valueExtractor), this.impReader.readFromExt(this.imp, EXT_DATA + path, valueExtractor), this.siteReader.readFromExt(this.bidRequest.getSite(), path, valueExtractor), this.appReader.readFromExt(this.bidRequest.getApp(), path, valueExtractor));
    }

    private List<String> getSegments(TargetingCategory category) {
        List userData = RequestContext.getIfNotNull(this.bidRequest.getUser(), User::getData);
        List<String> segments = ListUtils.emptyIfNull((List)userData).stream().filter(Objects::nonNull).filter(data -> Objects.equals(data.getId(), category.path())).flatMap(data -> ListUtils.emptyIfNull(data.getSegment()).stream()).map(Segment::getId).filter(Objects::nonNull).toList();
        return !segments.isEmpty() ? segments : null;
    }

    private static String toJsonPointer(String path) {
        return Arrays.stream(path.split("\\.")).collect(Collectors.joining("/", "/", ""));
    }

    private static String nodeToString(JsonNode node) {
        return node.isTextual() ? node.asText() : null;
    }

    private static Integer nodeToInteger(JsonNode node) {
        return node.isInt() ? Integer.valueOf(node.asInt()) : null;
    }

    private static List<String> nodeToListOfStrings(JsonNode node) {
        Function<JsonNode, String> valueExtractor = RequestContext::nodeToString;
        return node.isTextual() ? Collections.singletonList(valueExtractor.apply(node)) : RequestContext.nodeToList(node, valueExtractor);
    }

    private static List<Integer> nodeToListOfIntegers(JsonNode node) {
        Function<JsonNode, Integer> valueExtractor = RequestContext::nodeToInteger;
        return node.isInt() ? Collections.singletonList(valueExtractor.apply(node)) : RequestContext.nodeToList(node, valueExtractor);
    }

    private static <T> List<T> nodeToList(JsonNode node, Function<JsonNode, T> valueExtractor) {
        if (!node.isArray()) {
            return null;
        }
        return StreamUtil.asStream(node.spliterator()).map(valueExtractor).filter(Objects::nonNull).toList();
    }

    private static class AttributeReader<T> {
        private static final Set<Class<?>> SUPPORTED_PROPERTY_TYPES = Set.of(String.class, Integer.class, Integer.TYPE);
        private final Map<String, PropertyDescriptor> properties;
        private final Function<T, JsonNode> extPathExtractor;

        private AttributeReader(Class<T> type, Function<T, JsonNode> extPathExtractor) {
            this.properties = AttributeReader.supportedBeanProperties(type);
            this.extPathExtractor = extPathExtractor;
        }

        public static AttributeReader<Imp> forImp() {
            return new AttributeReader<Imp>(Imp.class, imp -> (JsonNode)RequestContext.getIfNotNull(imp, Imp::getExt));
        }

        public static AttributeReader<Geo> forGeo(ObjectNode geoExt) {
            return new AttributeReader<Geo>(Geo.class, ignored -> geoExt);
        }

        public static AttributeReader<Device> forDevice(ObjectNode deviceExt) {
            return new AttributeReader<Device>(Device.class, ignored -> deviceExt);
        }

        public static AttributeReader<User> forUser() {
            return new AttributeReader<User>(User.class, user -> (JsonNode)RequestContext.getIfNotNull(RequestContext.getIfNotNull(user, User::getExt), ExtUser::getData));
        }

        public static AttributeReader<Site> forSite() {
            return new AttributeReader<Site>(Site.class, site -> (JsonNode)RequestContext.getIfNotNull(RequestContext.getIfNotNull(site, Site::getExt), ExtSite::getData));
        }

        public static AttributeReader<App> forApp() {
            return new AttributeReader<App>(App.class, app -> (JsonNode)RequestContext.getIfNotNull(RequestContext.getIfNotNull(app, App::getExt), ExtApp::getData));
        }

        public <A> LookupResult<A> read(T target, String path, Function<JsonNode, A> valueExtractor, Class<A> attributeType) {
            return RequestContext.lookupResult(this.readFromObject(target, path, attributeType), this.readFromExt(target, path, valueExtractor));
        }

        public <A> A readFromObject(T target, String path, Class<A> attributeType) {
            return (A)(this.isTopLevelAttribute(path) ? RequestContext.getIfNotNull(target, user -> this.readProperty(user, path, attributeType)) : null);
        }

        public <A> A readFromExt(T target, String path, Function<JsonNode, A> valueExtractor) {
            JsonNode extPath = RequestContext.getIfNotNull(target, this.extPathExtractor);
            JsonNode value = RequestContext.getIfNotNull(extPath, node -> node.at(RequestContext.toJsonPointer(path)));
            return RequestContext.getIfNotNull(value, valueExtractor);
        }

        private boolean isTopLevelAttribute(String path) {
            return !path.contains(".");
        }

        private static Map<String, PropertyDescriptor> supportedBeanProperties(Class<?> beanClass) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass, Object.class);
                return Arrays.stream(beanInfo.getPropertyDescriptors()).filter(descriptor -> SUPPORTED_PROPERTY_TYPES.contains(descriptor.getPropertyType())).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
            }
            catch (IntrospectionException e) {
                return (Map)ExceptionUtils.rethrow((Throwable)e);
            }
        }

        private <A> A readProperty(T target, String path, Class<A> attributeType) {
            PropertyDescriptor descriptor = this.properties.get(path);
            if (descriptor != null && descriptor.getPropertyType().equals(attributeType)) {
                try {
                    return (A)descriptor.getReadMethod().invoke(target, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

